/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTypeIntentionAction;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OCTypeCompatibilityVisitor_OCFunctionType
extends OCTypeCompatibilityVisitor<OCFunctionType> {
    protected OCTypeCompatibilityVisitor_OCFunctionType(@NotNull OCFunctionType sourceType, @Nullable OCTypeOwner source, @Nullable PsiElement context, boolean allowImplicitConversions, boolean assumeNullSubstitutionsEquals, @NotNull OCResolveContext resolveContext) {
        super(sourceType, source, context, allowImplicitConversions, assumeNullSubstitutionsEquals, resolveContext);
    }

    @Override
    public OCType.TypeCheckResult visitFunctionType(final OCFunctionType type2) {
        final OCFunctionType functionType = (OCFunctionType)this.mySourceType;
        if (!this.isSuperTypeForFunctionChecks(type2.getReturnType(), functionType.getReturnType())) {
            OCTypeElement annotationElement = null;
            OCSymbol blockSymbol = null;
            if (this.mySource instanceof OCBlockExpression) {
                annotationElement = ((OCBlockExpression)this.mySource).getReturnTypeElement();
                blockSymbol = ((OCBlockExpression)this.mySource).getSymbol();
            }
            return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR_IF_CPP, OCInspections.IncompatiblePointers.class, "ext_typecheck_convert_incompatible_pointer", annotationElement, new IntentionAction[]{new OCChangeTypeIntentionAction(blockSymbol, type2.getReturnType(), true)}){

                @Override
                public String getMessage() {
                    return "Incompatible function return types '" + type2.getReturnType().getName(OCTypeCompatibilityVisitor_OCFunctionType.this.myContext) + "' and '" + functionType.getReturnType().getName(OCTypeCompatibilityVisitor_OCFunctionType.this.myContext) + "'";
                }
            };
        }
        if (OCCodeInsightUtil.isInPlainOldC((PsiElement)this.myResolveContext.getFile()) && type2.getParameterTypes(true).isEmpty()) {
            return OK_RESULT;
        }
        if (type2.getParameterTypes().size() != functionType.getParameterTypes().size()) {
            return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR_IF_CPP, "Incompatible number of arguments in function types", OCInspections.IncompatiblePointers.class, "CIDRincompatible-function-pointer-arguments", new IntentionAction[0]);
        }
        for (int i2 = 0; i2 < type2.getParameterTypes().size(); ++i2) {
            List<OCDeclarator> parameters2;
            final OCType selfArgumentType = type2.getParameterTypes().get(i2);
            final OCType hisArgumentType = functionType.getParameterTypes().get(i2);
            if (this.isSuperTypeForFunctionChecks(hisArgumentType, selfArgumentType)) continue;
            PsiElement annotationElement = null;
            OCSymbol parameterSymbol = null;
            if (this.mySource instanceof OCBlockExpression && (parameters2 = ((OCBlockExpression)this.mySource).getParameters()) != null && parameters2.size() == type2.getParameterTypes().size()) {
                parameterSymbol = parameters2.get(i2).getSymbol();
                annotationElement = parameters2.get(i2).getParent();
            }
            return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR_IF_CPP, OCInspections.IncompatiblePointers.class, "CIDRincompatible-function-pointer-arguments", annotationElement, new IntentionAction[]{new OCChangeTypeIntentionAction(parameterSymbol, selfArgumentType)}){

                @Override
                public String getMessage() {
                    return "Incompatible function parameter types '" + selfArgumentType.getName(OCTypeCompatibilityVisitor_OCFunctionType.this.myContext) + "' and '" + hisArgumentType.getName(OCTypeCompatibilityVisitor_OCFunctionType.this.myContext) + "'";
                }
            };
        }
        return OK_RESULT;
    }

    @Override
    public OCType.TypeCheckResult visitObjectType(OCObjectType type2) {
        return this.visitType(type2);
    }

    @Override
    public OCType.TypeCheckResult visitPointerType(final OCPointerType type2) {
        OCType.TypeCheckResult result2;
        OCType lTerminalType = type2.getTerminalType();
        if (!lTerminalType.isUnknown() && !(lTerminalType instanceof OCFunctionType) && type2.isPointerToPointerToObjectCompatible() && OCCompilerHelper.isArcEnabled(this.myContext.getContainingFile()) && (result2 = this.checkArcBridgeCast(type2, false)) != null) {
            return result2;
        }
        boolean isCpp = ((OCFile)this.myContext.getContainingFile()).isCpp();
        if (type2.getRefType() instanceof OCFunctionType && !(type2 instanceof OCBlockPointerType)) {
            return type2.getRefType().checkCompatible(this.mySourceType, this.mySource, this.myContext);
        }
        if (type2.isPointerToVoid() && !isCpp) {
            return OK_RESULT;
        }
        return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR_IF_CPP, OCInspections.IncompatiblePointers.class, "ext_typecheck_convert_incompatible_pointer", new IntentionAction[0]){

            @Override
            public String getMessage() {
                return "Incompatible pointer types '" + type2.getName(OCTypeCompatibilityVisitor_OCFunctionType.this.myResolveContext) + "' and '" + OCTypeCompatibilityVisitor_OCFunctionType.this.getSourceTypeName() + "'";
            }
        };
    }

    @Override
    public OCType.TypeCheckResult visitStructType(OCStructType type2) {
        if (type2.getKind() == OCSymbolKind.ENUM && !type2.isEnumClass()) {
            Computable message2 = () -> "Taking enum type '" + type2.getBestNameInContext(this.myContext) + "' from pointer";
            return this.checkAssignToEnum(type2, (Computable<String>)message2);
        }
        return this.checkStructCompatibleCtor(type2);
    }
}

