/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OCTypeCompatibilityVisitor_OCIntType
extends OCTypeCompatibilityVisitor<OCIntType> {
    protected OCTypeCompatibilityVisitor_OCIntType(@NotNull OCIntType sourceType, @Nullable OCTypeOwner source, @Nullable PsiElement context, boolean allowImplicitConversions, boolean assumeNullSubstitutionsEquals, @NotNull OCResolveContext resolveContext) {
        super(sourceType, source, context, allowImplicitConversions, assumeNullSubstitutionsEquals, resolveContext);
    }

    @Override
    public OCType.TypeCheckResult visitFunctionType(OCFunctionType type2) {
        String message2 = "Taking pointer from integer without a cast";
        return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR_IF_CPP, "Taking pointer from integer without a cast", OCInspections.ImplicitPointerAndIntegerConversion.class, "ext_typecheck_convert_int_pointer", new IntentionAction[0]);
    }

    @Override
    public OCType.TypeCheckResult visitObjectType(OCObjectType type2) {
        return this.visitType(type2);
    }

    @Override
    public OCType.TypeCheckResult visitPointerType(OCPointerType type2) {
        OCType.TypeCheckResult result2;
        OCType lTerminalType = type2.getTerminalType();
        if (((OCIntType)this.mySourceType).isPointerCompatible(this.myContext, false) && !lTerminalType.isUnknown() && type2.isPointerToPointerToObjectCompatible() ^ ((OCIntType)this.mySourceType).isPointerToPointerToObjectCompatible() && OCCompilerHelper.isArcEnabled(this.myContext.getContainingFile()) && (result2 = this.checkArcBridgeCast(type2, false)) != null) {
            return result2;
        }
        return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR_IF_CPP, "Taking pointer from integer without a cast", OCInspections.ImplicitPointerAndIntegerConversion.class, "ext_typecheck_convert_int_pointer", new IntentionAction[0]);
    }

    @Override
    public OCType.TypeCheckResult visitStructType(OCStructType type2) {
        if (type2.getKind() == OCSymbolKind.ENUM) {
            Computable message2;
            if (type2.isUnnamed() && type2.getTypedefName() == null) {
                if (!type2.isEnumClass()) {
                    return OK_RESULT;
                }
                message2 = () -> "Taking enum class type '" + type2.getBestNameInContext(this.myContext) + "' from integer";
            } else {
                message2 = () -> "Taking enum type '" + type2.getBestNameInContext(this.myContext) + "' from integer";
            }
            return this.checkAssignToEnum(type2, (Computable<String>)message2);
        }
        return this.checkStructCompatibleCtor(type2);
    }
}

