/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCTollFreeBridges;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OCTypeCompatibilityVisitor_OCPointerType
extends OCTypeCompatibilityVisitor<OCPointerType> {
    protected OCTypeCompatibilityVisitor_OCPointerType(@NotNull OCPointerType sourceType, @Nullable OCTypeOwner source, @Nullable PsiElement context, boolean allowImplicitConversions, boolean assumeNullSubstitutionsEquals, @NotNull OCResolveContext resolveContext) {
        super(sourceType, source, context, allowImplicitConversions, assumeNullSubstitutionsEquals, resolveContext);
    }

    @Override
    public OCType.TypeCheckResult visitFunctionType(final OCFunctionType type2) {
        if (((OCPointerType)this.mySourceType).getRefType() instanceof OCVoidType) {
            return OK_RESULT;
        }
        return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR_IF_CPP, OCInspections.IncompatiblePointers.class, "ext_typecheck_convert_incompatible_pointer", new IntentionAction[0]){

            @Override
            public String getMessage() {
                return "Incompatible pointer types '" + type2.getName(OCTypeCompatibilityVisitor_OCPointerType.this.myContext) + "' and '" + OCTypeCompatibilityVisitor_OCPointerType.this.getSourceTypeName() + "'";
            }
        };
    }

    @Override
    public OCType.TypeCheckResult visitObjectType(OCObjectType type2) {
        return this.visitType(type2);
    }

    @Override
    public OCType.TypeCheckResult visitArrayType(OCArrayType type2) {
        OCType.TypeCheckResult result2 = this.checkAssignPointerToArray(type2);
        return result2 != null ? result2 : super.visitArrayType(type2);
    }

    @Override
    public OCType.TypeCheckResult visitPointerType(final OCPointerType type2) {
        OCType lTerminalType = type2.getTerminalType();
        OCType rTerminalType = ((OCPointerType)this.mySourceType).getTerminalType();
        int lPointersDepth = type2.pointersDepth();
        int rPointersDepth = ((OCPointerType)this.mySourceType).pointersDepth();
        OCType.TypeCheckResult error = new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR_IF_CPP, OCInspections.IncompatiblePointers.class, "ext_typecheck_convert_incompatible_pointer", new IntentionAction[0]){

            @Override
            public String getMessage() {
                return "Incompatible pointer types '" + type2.getName(OCTypeCompatibilityVisitor_OCPointerType.this.myResolveContext) + "' and '" + OCTypeCompatibilityVisitor_OCPointerType.this.getSourceTypeName() + "'";
            }
        };
        if (type2.getClassQualifier() != null && ((OCPointerType)this.mySourceType).getClassQualifier() != null ? !((OCPointerType)this.mySourceType).getClassQualifier().isCompatible(type2.getClassQualifier(), this.myContext) : type2.getClassQualifier() != null && !(type2.getClassQualifier() instanceof OCMagicType) || ((OCPointerType)this.mySourceType).getClassQualifier() != null && !(((OCPointerType)this.mySourceType).getClassQualifier() instanceof OCMagicType)) {
            return error;
        }
        if (!(lTerminalType.isUnknown() || rTerminalType.isUnknown() || lTerminalType instanceof OCFunctionType && rTerminalType instanceof OCFunctionType || !(type2.isPointerToPointerToObjectCompatible() ^ ((OCPointerType)this.mySourceType).isPointerToPointerToObjectCompatible()))) {
            boolean isTollFreeBridge = OCTollFreeBridges.isCompatible(type2, this.mySourceType);
            if (OCCompilerHelper.isArcEnabled(this.myContext.getContainingFile())) {
                OCType.TypeCheckResult result2 = this.checkArcBridgeCast(type2, isTollFreeBridge);
                if (result2 != null) {
                    return result2;
                }
            } else if (isTollFreeBridge) {
                return OK_RESULT;
            }
        }
        boolean isCpp = ((OCFile)this.myContext.getContainingFile()).isCpp();
        OCType.TypeCheckResult checkResult = type2.validateConstPointers(this.mySourceType, this.myContext);
        if (checkResult.getState() != OCType.TypeCheckState.ERROR) {
            return checkResult;
        }
        if (lTerminalType instanceof OCObjectType && rTerminalType instanceof OCObjectType && type2.getRefType().isCompatible(((OCPointerType)this.mySourceType).getRefType(), this.myContext)) {
            return OK_RESULT;
        }
        if (type2.isPointerToVoid() && !isCpp) {
            return OK_RESULT;
        }
        if (((OCPointerType)this.mySourceType).isPointerToVoid() && !isCpp) {
            return OK_RESULT;
        }
        if (lTerminalType instanceof OCObjectType && rTerminalType instanceof OCObjectType && lPointersDepth == rPointersDepth) {
            return type2.getRefType().checkCompatible(((OCPointerType)this.mySourceType).getRefType(), this.mySource, this.myContext);
        }
        if (lTerminalType instanceof OCMagicType) {
            return OK_RESULT;
        }
        if (this.isCppClassType(lTerminalType) && this.isCppClassType(rTerminalType) && lPointersDepth == rPointersDepth) {
            OCType.TypeCheckResult result3 = type2.getRefType().checkCompatible(((OCPointerType)this.mySourceType).getRefType(), this.mySource, this.myContext);
            if ((!isCpp || this.myContext instanceof OCCastExpression) && result3.getState().isError(this.myContext)) {
                result3.setState(OCType.TypeCheckState.WARNING);
            }
            return result3;
        }
        if (lTerminalType instanceof OCFunctionType && rTerminalType instanceof OCFunctionType && lPointersDepth == rPointersDepth && (type2 instanceof OCBlockPointerType || !(this.mySourceType instanceof OCBlockPointerType))) {
            return type2.getRefType().checkCompatible(((OCPointerType)this.mySourceType).getRefType(), this.mySource, this.myContext);
        }
        if (type2.getRefType() instanceof OCIdType && ((OCIdType)type2.getRefType()).getAllProtocols().isEmpty() && ((OCPointerType)this.mySourceType).isPointerToObjectCompatible() || type2.isPointerToObjectCompatible() && ((OCPointerType)this.mySourceType).isPointerToID() && ((OCPointerType)this.mySourceType).getTerminalType() instanceof OCObjectType && ((OCObjectType)((OCPointerType)this.mySourceType).getTerminalType()).getAllProtocols().isEmpty()) {
            return OK_RESULT;
        }
        if ((lTerminalType instanceof OCReferenceType || rTerminalType instanceof OCReferenceType) && type2.getCanonicalName(this.myContext).equals(((OCPointerType)this.mySourceType).getCanonicalName(this.myContext))) {
            return OK_RESULT;
        }
        if (checkResult.getState() == OCType.TypeCheckState.ERROR_IF_CPP) {
            return checkResult;
        }
        return error;
    }

    @Override
    public OCType.TypeCheckResult visitStructType(OCStructType type2) {
        if (OCTollFreeBridges.isCompatible(this.mySourceType, type2)) {
            return OK_RESULT;
        }
        if (type2.getKind() == OCSymbolKind.ENUM && !type2.isEnumClass()) {
            Computable message2 = () -> "Taking enum type '" + type2.getBestNameInContext(this.myContext) + "' from pointer";
            return this.checkAssignToEnum(type2, (Computable<String>)message2);
        }
        return this.checkStructCompatibleCtor(type2);
    }
}

