/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.quickfixes.OCSetSuperclassIntentionAction;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCTollFreeBridges;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OCTypeCompatibilityVisitor_OCStructType
extends OCTypeCompatibilityVisitor<OCStructType> {
    protected OCTypeCompatibilityVisitor_OCStructType(@NotNull OCStructType sourceType, @Nullable OCTypeOwner source, @Nullable PsiElement context, boolean allowImplicitConversions, boolean assumeNullSubstitutionsEquals, @NotNull OCResolveContext resolveContext) {
        super(sourceType, source, context, allowImplicitConversions, assumeNullSubstitutionsEquals, resolveContext);
    }

    @Override
    public OCType.TypeCheckResult visitFunctionType(final OCFunctionType type2) {
        if (((OCStructType)this.mySourceType).isIntegerCompatible(this.myContext, false)) {
            String message2 = "Taking pointer from integer without a cast";
            return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR_IF_CPP, "Taking pointer from integer without a cast", OCInspections.ImplicitPointerAndIntegerConversion.class, "ext_typecheck_convert_int_pointer", new IntentionAction[0]);
        }
        if (((OCStructType)this.mySourceType).getKind() == OCSymbolKind.ENUM && !((OCStructType)this.mySourceType).isEnumClass()) {
            return new OCType.TypeCheckResult(OCType.TypeCheckState.WARNING, OCInspections.ImplicitIntegerAndEnumConversion.class, "CIDR", new IntentionAction[0]){

                @Override
                public String getMessage() {
                    return "Taking integer from enum type '" + OCTypeCompatibilityVisitor_OCStructType.this.getSourceTypeName() + "'";
                }
            };
        }
        if (((OCStructType)this.mySourceType).isPointerCompatible(this.myContext, false)) {
            return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR_IF_CPP, OCInspections.IncompatiblePointers.class, "ext_typecheck_convert_incompatible_pointer", new IntentionAction[0]){

                @Override
                public String getMessage() {
                    return "Incompatible pointer types '" + type2.getName(OCTypeCompatibilityVisitor_OCStructType.this.myContext) + "' and '" + OCTypeCompatibilityVisitor_OCStructType.this.getSourceTypeName() + "'";
                }
            };
        }
        return this.visitType(type2);
    }

    @Override
    public OCType.TypeCheckResult visitObjectType(OCObjectType type2) {
        return this.visitType(type2);
    }

    @Override
    public OCType.TypeCheckResult visitPointerType(final OCPointerType type2) {
        OCType.TypeCheckResult result2;
        OCType lTerminalType = type2.getTerminalType();
        if (((OCStructType)this.mySourceType).isPointerCompatible(this.myContext, false) && !lTerminalType.isUnknown() && type2.isPointerToPointerToObjectCompatible() ^ ((OCStructType)this.mySourceType).isPointerToPointerToObjectCompatible() && OCCompilerHelper.isArcEnabled(this.myContext.getContainingFile()) && (result2 = this.checkArcBridgeCast(type2, false)) != null) {
            return result2;
        }
        boolean isCpp = ((OCFile)this.myContext.getContainingFile()).isCpp();
        if (((OCStructType)this.mySourceType).isIntegerCompatible(this.myContext, false)) {
            return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR_IF_CPP, "Taking pointer from integer without a cast", OCInspections.ImplicitPointerAndIntegerConversion.class, "ext_typecheck_convert_int_pointer", new IntentionAction[0]);
        }
        if (type2.isPointerToVoid() && ((OCStructType)this.mySourceType).isPointerCompatible(this.myContext, this.myAllowImplicitConversions) && !isCpp) {
            return OK_RESULT;
        }
        if (((OCStructType)this.mySourceType).isPointerCompatible(this.myContext, false)) {
            return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR_IF_CPP, OCInspections.IncompatiblePointers.class, "ext_typecheck_convert_incompatible_pointer", new IntentionAction[0]){

                @Override
                public String getMessage() {
                    return "Incompatible pointer types '" + type2.getName(OCTypeCompatibilityVisitor_OCStructType.this.myResolveContext) + "' and '" + OCTypeCompatibilityVisitor_OCStructType.this.getSourceTypeName() + "'";
                }
            };
        }
        return this.visitType(type2);
    }

    @Override
    protected OCType.TypeCheckResult checkRefType(OCCppReferenceType type2) {
        OCType.TypeCheckResult result2 = super.checkRefType(type2);
        if (this.myContext instanceof OCCastExpression && result2.getState().isError(this.myContext) && this.isCppClassType(type2.getTerminalType()) && ((OCFile)this.myContext.getContainingFile()).isCpp() && ((OCStructType)this.mySourceType).getKind() == OCSymbolKind.STRUCT) {
            result2.setState(OCType.TypeCheckState.WARNING);
        }
        return result2;
    }

    @Override
    public OCType.TypeCheckResult visitStructType(final OCStructType type2) {
        OCFunctionDefinition declaringFun;
        if (new OCTypeEqualityVisitor(this.mySourceType, false, false, true, this.myAssumeNullSubstitutionsEquals, true, true, true, this.myResolveContext).equal(type2) && (!((OCStructType)this.mySourceType).isVolatile() || type2.isVolatile())) {
            return OK_RESULT;
        }
        if (OCTollFreeBridges.isCompatible(this.mySourceType, type2)) {
            return OK_RESULT;
        }
        if (type2.getKind() == OCSymbolKind.ENUM) {
            if (((OCStructType)this.mySourceType).getKind() == OCSymbolKind.ENUM) {
                return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR_IF_CPP, OCInspections.IncompatibleEnums.class, "warn_impcast_different_enum_types", new IntentionAction[0]){

                    @Override
                    public String getMessage() {
                        return "Incompatible enum types '" + type2.getBestNameInContext(OCTypeCompatibilityVisitor_OCStructType.this.myContext) + "' and '" + OCTypeCompatibilityVisitor_OCStructType.this.getSourceTypeName() + "'";
                    }
                };
            }
            Computable message2 = null;
            if (((OCStructType)this.mySourceType).isIntegerCompatible(this.myContext, false)) {
                message2 = () -> "Taking enum type '" + type2.getBestNameInContext(this.myContext) + "' from integer";
            } else if (!type2.isEnumClass() && ((OCStructType)this.mySourceType).isPointerCompatible(this.myContext, false)) {
                message2 = () -> "Taking enum type '" + type2.getBestNameInContext(this.myContext) + "' from pointer";
            }
            if (message2 != null) {
                return this.checkAssignToEnum(type2, (Computable<String>)message2);
            }
        }
        OCFunctionSymbol declaringSymbol = (declaringFun = (OCFunctionDefinition)PsiTreeUtil.getParentOfType((PsiElement)this.myContext, OCFunctionDefinition.class)) != null ? declaringFun.getSymbol() : null;
        boolean isFunctionReturnTypeContext = this.myContext.getParent() instanceof OCFunctionDeclaration && ((OCFunctionDeclaration)this.myContext.getParent()).getReturnTypeElement() == this.myContext;
        for (final OCStructSymbol struct : type2.getStructs()) {
            OCType.TypeCheckResult result2 = this.processTransparentUnion(struct, type2);
            if (result2 != null) {
                return result2;
            }
            if (this.myAllowImplicitConversions) {
                result2 = this.processConstructors(struct);
            }
            if (((OCFile)this.myContext.getContainingFile()).isCpp() && ((OCStructType)this.mySourceType).getKind() == OCSymbolKind.STRUCT && this.isCppClassType(type2)) {
                boolean isInsideClass = declaringSymbol != null && declaringSymbol.getResolvedOwner() instanceof OCStructSymbol && struct.isAncestor((OCStructSymbol)declaringSymbol.getResolvedOwner());
                for (final OCStructSymbol symbol : ((OCStructType)this.mySourceType).getStructs()) {
                    final Ref visibilityRef = new Ref();
                    if (!symbol.processAllBaseClasses(new OCResolveContext((PsiElement)this.myContext.getContainingFile()), (baseSymbol, visibility) -> {
                        if (baseSymbol instanceof OCStructSymbol && ((OCStructSymbol)baseSymbol).resolvedNamesEqual(struct) || baseSymbol instanceof OCTypeParameterSymbol) {
                            visibilityRef.set((Object)visibility);
                            return false;
                        }
                        return true;
                    }, isInsideClass)) {
                        if (!isFunctionReturnTypeContext && (!isInsideClass && visibilityRef.get() != OCVisibility.PUBLIC || visibilityRef.get() == OCVisibility.PRIVATE)) {
                            if (result2 == null) {
                                result2 = new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR, OCInspections.MemberVisibility.class, "err_typecheck_convert_incompatible", new IntentionAction[]{new OCSetSuperclassIntentionAction(symbol, struct, OCVisibility.PUBLIC), this.getNewConstructorFix(struct)}){

                                    @Override
                                    public String getMessage() {
                                        return struct.getKindUppercase() + " '" + type2.getBestNameInContext(OCTypeCompatibilityVisitor_OCStructType.this.myContext) + "' is a " + visibilityRef.toString() + " base class of " + symbol.getKindLowercase() + " '" + OCTypeCompatibilityVisitor_OCStructType.this.getSourceTypeName() + "'";
                                    }
                                };
                            }
                        } else {
                            return OK_RESULT;
                        }
                    }
                    if (result2 != null) continue;
                    result2 = new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR, OCInspections.NotSuperclass.class, "err_ovl_no_viable_oper", new IntentionAction[]{new OCSetSuperclassIntentionAction(symbol, struct, OCVisibility.PUBLIC), this.getNewConstructorFix(struct)}){

                        @Override
                        public String getMessage() {
                            return symbol.getKindUppercase() + " '" + OCTypeCompatibilityVisitor_OCStructType.this.getSourceTypeName() + "' is not compatible with " + struct.getKindLowercase() + " '" + type2.getBestNameInContext(OCTypeCompatibilityVisitor_OCStructType.this.myContext) + "'";
                        }
                    };
                }
            }
            if (result2 == null) continue;
            return result2;
        }
        OCType.TypeCheckResult result3 = this.visitType(type2);
        if (result3 != OK_RESULT && this.isCppClassType(type2)) {
            result3.setQuickFixes(new IntentionAction[]{this.getNewConstructorFix(type2.getSymbol())});
        }
        return result3;
    }
}

