/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.HashSet;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCTollFreeBridges;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTypeEqualityAfterResolvingVisitor
extends OCTypeEqualityVisitor {
    private final boolean myAssumeNotResolvedTypesEquals;
    private final boolean myAssumeMagicTypesEquals;
    private final boolean myAssumeTollFreeTypesEquals;

    public OCTypeEqualityAfterResolvingVisitor(OCType type2, boolean assumeNotResolvedTypeEquals, boolean assumeMagicTypeEquals, boolean assumeConstValueEquals, boolean differentSubstitutionsEquals, boolean assumeTollFreeTypesEquals, @Nullable PsiFile file2) {
        this(type2, assumeNotResolvedTypeEquals, assumeMagicTypeEquals, assumeConstValueEquals, differentSubstitutionsEquals, assumeTollFreeTypesEquals, new OCResolveContext((PsiElement)file2));
    }

    public OCTypeEqualityAfterResolvingVisitor(OCType type2, boolean assumeNotResolvedTypeEquals, boolean assumeMagicTypeEquals, boolean assumeConstValueEquals, boolean differentSubstitutionsEquals, boolean assumeTollFreeTypesEquals, @NotNull OCResolveContext context) {
        super(type2, true, differentSubstitutionsEquals, false, false, true, true, assumeConstValueEquals, context);
        this.myAssumeNotResolvedTypesEquals = assumeNotResolvedTypeEquals;
        this.myAssumeMagicTypesEquals = assumeMagicTypeEquals;
        this.myAssumeTollFreeTypesEquals = assumeTollFreeTypesEquals;
    }

    public OCTypeEqualityAfterResolvingVisitor(OCType type2, boolean assumeNotResolvedTypeEquals, @NotNull OCResolveContext context) {
        this(type2, assumeNotResolvedTypeEquals, false, false, false, true, context);
    }

    @Override
    public boolean equal(OCType type2, boolean checkCV) {
        if (this.myAssumeMagicTypesEquals && (this.myType instanceof OCMagicType || type2 instanceof OCMagicType || this.myType instanceof OCAutoType || type2 instanceof OCAutoType)) {
            return true;
        }
        this.myType = this.myType.resolve(this.myContext);
        OCType resolvedType = type2.resolve(this.myContext);
        if (checkCV && this.myType.isConst() != type2.isConst()) {
            return false;
        }
        if (checkCV && this.myType.isVolatile() != type2.isVolatile()) {
            return false;
        }
        if (this.myType instanceof OCUnknownType || resolvedType instanceof OCUnknownType) {
            return true;
        }
        if (this.myAssumeNotResolvedTypesEquals && (this.myType instanceof OCReferenceType || resolvedType instanceof OCReferenceType)) {
            return true;
        }
        if (this.myType instanceof OCTypeParameterType && resolvedType instanceof OCTypeParameterType) {
            return true;
        }
        if (this.myAssumeTollFreeTypesEquals && OCTollFreeBridges.isCompatible(this.myType, resolvedType)) {
            return true;
        }
        return resolvedType.accept(this);
    }

    @Override
    public Boolean visitObjectType(OCObjectType type2) {
        if (type2 == this.myType) {
            return true;
        }
        if (!(this.myType instanceof OCObjectType)) {
            return false;
        }
        OCObjectType that = (OCObjectType)this.myType;
        if (!(type2 instanceof OCIdType && type2.getAugmentedProtocols().isEmpty() || that instanceof OCIdType && that.getAugmentedProtocols().isEmpty() || OCTypeEqualityAfterResolvingVisitor.getProtocolNames(type2).equals(OCTypeEqualityAfterResolvingVisitor.getProtocolNames(that)))) {
            return false;
        }
        OCInterfaceSymbol thisInterface = type2.getInterface();
        OCInterfaceSymbol thatInterface = that.getInterface();
        if (thisInterface == null || thatInterface == null) {
            return thisInterface == thatInterface;
        }
        return Comparing.equal((String)thisInterface.getName(), (String)thatInterface.getName());
    }

    private static Set<String> getProtocolNames(OCObjectType type2) {
        HashSet result2 = new HashSet();
        for (OCProtocolSymbol protocol : type2.getAugmentedProtocols()) {
            result2.add(protocol.getName());
        }
        return result2;
    }

    @Override
    protected Boolean substitutionTypesEqual(@NotNull OCType thatSust, @NotNull OCType mySust, @NotNull OCResolveContext context) {
        return thatSust.accept(new OCTypeEqualityAfterResolvingVisitor(mySust, true, this.myAssumeMagicTypesEquals, this.myDontCheckCV, false, true, this.myContext));
    }
}

