/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCExpansionPackType;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeNameVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeUnificationVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTypeEqualityVisitor
implements OCTypeVisitor<Boolean> {
    protected OCType myType;
    private final boolean myAssumeMagicTypesEquals;
    private final boolean myAssumeDifferentSubstitutionsEquals;
    private final boolean myAssumeNonExpandedVariadicsEquals;
    private final boolean myAssumeNullSubstitutionsEquals;
    private final boolean myAssumeTypeParametersEquals;
    private final boolean myEvaluateExpressionSubstitutions;
    protected final boolean myDontCheckCV;
    @NotNull
    protected final OCResolveContext myContext;

    public OCTypeEqualityVisitor(OCType type2, boolean magicTypesEquals, boolean differentSubstitutionsEquals, boolean typeParametersEquals, boolean constValueEquals, @NotNull OCResolveContext context) {
        this(type2, magicTypesEquals, differentSubstitutionsEquals, false, false, typeParametersEquals, true, constValueEquals, context);
    }

    public OCTypeEqualityVisitor(OCType type2, boolean magicTypesEquals, boolean differentSubstitutionsEquals, boolean assumeNonExpandedVariadicsEquals, boolean nullSubstitutionsEquals, boolean typeParametersEquals, boolean evaluateExpressionSubstitutions, boolean dontCheckCV, @NotNull OCResolveContext context) {
        this.myType = type2;
        this.myAssumeMagicTypesEquals = magicTypesEquals;
        this.myAssumeDifferentSubstitutionsEquals = differentSubstitutionsEquals;
        this.myAssumeNonExpandedVariadicsEquals = assumeNonExpandedVariadicsEquals;
        this.myAssumeNullSubstitutionsEquals = nullSubstitutionsEquals;
        this.myAssumeTypeParametersEquals = typeParametersEquals;
        this.myEvaluateExpressionSubstitutions = evaluateExpressionSubstitutions;
        this.myDontCheckCV = dontCheckCV;
        this.myContext = context;
    }

    public OCTypeEqualityVisitor(OCType type2, boolean assumeMagicTypesEquals, @NotNull OCResolveContext context) {
        this(type2, assumeMagicTypesEquals, false, false, false, context);
    }

    public boolean equal(OCType type2) {
        return this.equal(type2, !this.myDontCheckCV);
    }

    public boolean equal(OCType type2, boolean checkCV) {
        if (checkCV && this.myType.isConst() != type2.isConst()) {
            return false;
        }
        if (this.myAssumeMagicTypesEquals && (this.myType instanceof OCMagicType || type2 instanceof OCMagicType)) {
            return true;
        }
        if (this.myAssumeTypeParametersEquals && (this.myType instanceof OCTypeParameterType || type2 instanceof OCTypeParameterType)) {
            return true;
        }
        if (checkCV && this.myType.isVolatile() != type2.isVolatile()) {
            return false;
        }
        return type2.accept(this);
    }

    protected boolean equal(@NotNull OCType type1, @NotNull OCType type2) {
        return this.equal(type1, type2, !this.myDontCheckCV);
    }

    protected boolean equal(@NotNull OCType type1, @NotNull OCType type2, boolean checkConst) {
        OCType save2 = this.myType;
        this.myType = type2;
        boolean equal = this.equal(type1, checkConst);
        this.myType = save2;
        return equal;
    }

    @Override
    public Boolean visitEllipsisReferenceType(OCEllipsisType type2) {
        return this.myType != null && type2.getClass() == this.myType.getClass();
    }

    @Override
    public Boolean visitFunctionType(OCFunctionType type2) {
        if (type2 == this.myType) {
            return true;
        }
        if (this.myType == null || type2.getClass() != this.myType.getClass()) {
            return false;
        }
        OCFunctionType that = (OCFunctionType)this.myType;
        if (!this.isFunctionSignatureEqual(type2)) {
            return false;
        }
        if (!this.equal(type2.getReturnType(), that.getReturnType(), false)) {
            return false;
        }
        return true;
    }

    public boolean isFunctionSignatureEqual(OCType type2) {
        if (!(type2 instanceof OCFunctionType)) {
            return false;
        }
        if (!(this.myType instanceof OCFunctionType)) {
            return false;
        }
        if (this.myType.isConst() != type2.isConst()) {
            return false;
        }
        if (this.myType.isVolatile() != type2.isVolatile()) {
            return false;
        }
        OCFunctionType thisFun = (OCFunctionType)type2;
        OCFunctionType thatFun = (OCFunctionType)this.myType;
        List<OCType> myArgumentTypes = thisFun.getParameterTypes();
        List<OCType> thatArgumentTypes = thatFun.getParameterTypes();
        if (((OCFunctionType)type2).isLValueRef() != ((OCFunctionType)this.myType).isLValueRef()) {
            return false;
        }
        if (((OCFunctionType)type2).isRValueRef() != ((OCFunctionType)this.myType).isRValueRef()) {
            return false;
        }
        if (myArgumentTypes.size() != thatArgumentTypes.size()) {
            return false;
        }
        if (thisFun.isVararg() != thatFun.isVararg()) {
            return false;
        }
        for (int i2 = 0; i2 < myArgumentTypes.size(); ++i2) {
            if (this.equal(myArgumentTypes.get(i2), thatArgumentTypes.get(i2), false)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Boolean visitMagicType(OCMagicType type2) {
        if (this.myType == null || type2.getClass() != this.myType.getClass()) {
            return false;
        }
        return this.myType == type2 || ((OCMagicType)this.myType).getMagicName().equals(type2.getMagicName());
    }

    @Override
    public Boolean visitTypeParameterType(OCTypeParameterType type2) {
        if (this.myType == null || type2.getClass() != this.myType.getClass()) {
            return false;
        }
        return this.myType == type2 || ((OCTypeParameterType)this.myType).getSymbol().equals(type2.getSymbol()) && ((OCSymbol)((Object)type2.getSymbol())).isSynthetic() == ((OCSymbol)((Object)((OCTypeParameterType)this.myType).getSymbol())).isSynthetic() && this.visitMagicType(type2) != false;
    }

    @Override
    public Boolean visitAutoType(OCAutoType type2) {
        if (type2 == this.myType) {
            return true;
        }
        if (this.myType == null || type2.getClass() != this.myType.getClass()) {
            return false;
        }
        OCAutoType that = (OCAutoType)this.myType;
        if (!Comparing.equal((Object)type2.getExpressionSymbol(), (Object)that.getExpressionSymbol())) {
            return false;
        }
        OCType incompleteType1 = type2.getIncompleteType();
        OCType incompleteType2 = that.getIncompleteType();
        if (!(incompleteType1 == null && incompleteType2 == null || incompleteType1 != null && incompleteType1.equals((Object)incompleteType2, this.myContext))) {
            return false;
        }
        OCTypeSubstitution substitution1 = type2.getSubstitution();
        OCTypeSubstitution substitution2 = that.getSubstitution();
        if (!(type2.getExpressionSymbol() == null || substitution1 == null && substitution2 == null || substitution1 != null && substitution1.equals(substitution2))) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visitObjectType(OCObjectType type2) {
        if (type2 == this.myType) {
            return true;
        }
        if (this.myType == null || type2.getClass() != this.myType.getClass()) {
            return false;
        }
        OCObjectType that = (OCObjectType)this.myType;
        if (!Comparing.equal((Object)type2.getInterface(), (Object)that.getInterface())) {
            return false;
        }
        if (!Comparing.equal((Object)type2.getImplementation(), (Object)that.getImplementation())) {
            return false;
        }
        if (!type2.getAllProtocols().equals(that.getAllProtocols())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visitArrayType(OCArrayType type2) {
        if (this.myType == type2) {
            return true;
        }
        if (this.myType == null || type2.getClass() != this.myType.getClass()) {
            return false;
        }
        OCArrayType that = (OCArrayType)this.myType;
        if (type2.hasLength() && that.hasLength() && type2.getLength() != that.getLength()) {
            return false;
        }
        if (type2.getARCAttribute() != that.getARCAttribute()) {
            return false;
        }
        if (!this.equal(type2.getRefType(), that.getRefType())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visitPointerType(OCPointerType type2) {
        if (this.myType == type2) {
            return true;
        }
        if (this.myType == null || type2.getClass() != this.myType.getClass()) {
            return false;
        }
        OCPointerType that = (OCPointerType)this.myType;
        if (type2.getARCAttribute() != that.getARCAttribute()) {
            return false;
        }
        if (!this.equal(type2.getRefType(), that.getRefType(), true)) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visitBlockPointerType(OCBlockPointerType type2) {
        if (this.myType == null || type2.getClass() != this.myType.getClass()) {
            return false;
        }
        return this.visitPointerType(type2);
    }

    @Override
    public Boolean visitCppReferenceType(OCCppReferenceType type2) {
        if (this.myType == type2) {
            return true;
        }
        if (this.myType == null || type2.getClass() != this.myType.getClass()) {
            return false;
        }
        OCCppReferenceType that = (OCCppReferenceType)this.myType;
        if (!this.equal(type2.getRefType(), that.getRefType(), true)) {
            return false;
        }
        if (type2.isRvalueRef() != that.isRvalueRef()) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visitIdType(OCIdType type2) {
        if (this.myType == null || type2.getClass() != this.myType.getClass()) {
            return false;
        }
        return this.visitObjectType(type2);
    }

    @Override
    public Boolean visitIntType(OCIntType type2) {
        if (type2 == this.myType) {
            return true;
        }
        if (this.myType == null || type2.getClass() != this.myType.getClass()) {
            return false;
        }
        OCIntType ocIntType = (OCIntType)this.myType;
        if (type2.isSigned() != ocIntType.isSigned()) {
            return false;
        }
        if (!type2.getCTypeId().equals((Object)ocIntType.getCTypeId())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visitRealType(OCRealType type2) {
        if (this.myType == null || type2.getClass() != this.myType.getClass()) {
            return false;
        }
        return type2.getCTypeId().equals((Object)((OCRealType)this.myType).getCTypeId()) && type2.isComplex() == ((OCRealType)this.myType).isComplex();
    }

    @Override
    public Boolean visitReferenceType(OCReferenceType type2) {
        if (type2 == this.myType) {
            return true;
        }
        if (this.myType == null || type2.getClass() != this.myType.getClass()) {
            return false;
        }
        OCReferenceType that = (OCReferenceType)this.myType;
        if (!type2.getProtocolNames().equals(that.getProtocolNames())) {
            return false;
        }
        if (!type2.getReference().equals(that.getReference())) {
            return false;
        }
        if (!type2.getSubstitution().equals(that.getSubstitution())) {
            return false;
        }
        if (type2.getARCAttribute() != that.getARCAttribute()) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visitStructType(OCStructType type2) {
        if (this.myType == null || type2.getClass() != this.myType.getClass()) {
            return false;
        }
        ProgressManager.checkCanceled();
        OCStructType myStructType = (OCStructType)this.myType;
        if (type2.getTypedefName() != null && myStructType.getTypedefName() != null && !type2.getTypedefName().equals(myStructType.getTypedefName())) {
            return false;
        }
        FactoryMap<OCStructSymbol, String> map2 = new FactoryMap<OCStructSymbol, String>(){

            @Nullable
            protected String create(OCStructSymbol symbol) {
                return new OCTypeNameVisitor(OCType.Presentation.SHORT, OCTypeEqualityVisitor.this.myContext).getName(symbol.getType());
            }
        };
        Function namer = arg_0 -> OCTypeEqualityVisitor.lambda$visitStructType$0((FactoryMap)map2, arg_0);
        HashSet<String> names = new HashSet<String>(ContainerUtil.map(type2.getStructs(), (Function)namer));
        names.retainAll(ContainerUtil.map(myStructType.getStructs(), (Function)namer));
        OCStructSymbol thatStruct = OCTypeEqualityVisitor.getTopmostStruct(type2.getStructs(), names, (Function<OCStructSymbol, String>)namer, this.myContext);
        OCStructSymbol myStruct = OCTypeEqualityVisitor.getTopmostStruct(myStructType.getStructs(), names, (Function<OCStructSymbol, String>)namer, this.myContext);
        if (thatStruct == myStruct) {
            return true;
        }
        if (thatStruct.isUnnamed() && myStruct.isUnnamed()) {
            return thatStruct.equals(myStruct);
        }
        if (!thatStruct.resolvedNamesEqual(myStruct)) {
            return false;
        }
        if (this.myAssumeDifferentSubstitutionsEquals) {
            return true;
        }
        List<OCTypeArgument> thatStructArgs = thatStruct.getTemplateArguments(this.myContext);
        List<OCTypeArgument> myStructArgs = myStruct.getTemplateArguments(this.myContext);
        if (!(thatStructArgs.size() == myStructArgs.size() || this.myAssumeNonExpandedVariadicsEquals && (ContainerUtil.getLastItem(thatStructArgs) instanceof OCVariadicType || ContainerUtil.getLastItem(myStructArgs) instanceof OCVariadicType))) {
            return false;
        }
        Iterator<OCTypeArgument> thatIterator = thatStructArgs.iterator();
        Iterator<OCTypeArgument> myIterator = myStructArgs.iterator();
        while (thatIterator.hasNext() && myIterator.hasNext()) {
            OCTypeArgument thatSubst = thatIterator.next();
            OCTypeArgument mySubst = myIterator.next();
            if (this.myAssumeNonExpandedVariadicsEquals && (thatSubst instanceof OCVariadicType || mySubst instanceof OCVariadicType)) break;
            if (thatSubst == null || thatSubst instanceof OCUnknownType || mySubst == null || mySubst instanceof OCUnknownType) {
                OCSymbolWithQualifiedName functionSymbol;
                if (this.myAssumeNullSubstitutionsEquals) continue;
                OCFunctionDeclaration containingFunction = (OCFunctionDeclaration)PsiTreeUtil.getParentOfType((PsiElement)this.myContext.getElement(), OCFunctionDeclaration.class);
                OCSymbolWithQualifiedName oCSymbolWithQualifiedName = functionSymbol = containingFunction != null ? (OCSymbolWithQualifiedName)containingFunction.getSymbol() : null;
                if (functionSymbol != null && functionSymbol.getResolvedOwner() == myStruct) continue;
            }
            if (thatSubst instanceof OCTypeParameterType || mySubst instanceof OCTypeParameterType) {
                if (this.myAssumeTypeParametersEquals || mySubst instanceof OCType && thatSubst instanceof OCType && this.substitutionTypesEqual((OCType)thatSubst, (OCType)mySubst, this.myContext).booleanValue()) continue;
                return false;
            }
            if (thatSubst instanceof OCType && mySubst instanceof OCType) {
                if (this.substitutionTypesEqual((OCType)thatSubst, (OCType)mySubst, this.myContext).booleanValue()) continue;
                return false;
            }
            if (thatSubst instanceof OCType || mySubst instanceof OCType) {
                return false;
            }
            if (this.myAssumeMagicTypesEquals) continue;
            if (this.myEvaluateExpressionSubstitutions && thatSubst instanceof OCExpressionTypeArgument && mySubst instanceof OCExpressionTypeArgument) {
                Number myValue;
                if (thatSubst.equals(mySubst, this.myContext)) {
                    return true;
                }
                Number thatValue = OCExpressionEvaluator.evaluate(((OCExpressionTypeArgument)thatSubst).getSymbol(), this.myContext);
                if (OCTypeUnificationVisitor.isSameValue(thatValue, myValue = OCExpressionEvaluator.evaluate(((OCExpressionTypeArgument)mySubst).getSymbol(), this.myContext))) continue;
                return false;
            }
            if (Comparing.equal((Object)thatSubst, (Object)mySubst)) continue;
            return false;
        }
        if (!(!thatIterator.hasNext() || this.myAssumeNonExpandedVariadicsEquals && thatIterator.next() instanceof OCVariadicType)) {
            return false;
        }
        if (!(!myIterator.hasNext() || this.myAssumeNonExpandedVariadicsEquals && myIterator.next() instanceof OCVariadicType)) {
            return false;
        }
        return true;
    }

    protected Boolean substitutionTypesEqual(OCType thatSust, OCType mySust, @NotNull OCResolveContext context) {
        return new OCTypeEqualityVisitor(mySust, this.myAssumeMagicTypesEquals, false, this.myAssumeTypeParametersEquals, false, this.myContext).equal(thatSust);
    }

    private static OCStructSymbol getTopmostStruct(List<OCStructSymbol> structs, Set<String> names, Function<OCStructSymbol, String> namer, @NotNull OCResolveContext context) {
        if (structs.size() == 1) {
            return structs.get(0);
        }
        for (OCStructSymbol struct : structs) {
            if (struct.isPredeclaration() || !names.contains(namer.fun((Object)struct))) continue;
            return struct;
        }
        int size = Integer.MAX_VALUE;
        OCStructSymbol result2 = null;
        for (OCStructSymbol symbol : structs) {
            OCQualifiedName name = symbol.getResolvedQualifiedName(context, false);
            if (name == null || name.flatten().size() >= size) continue;
            result2 = symbol;
            size = name.flatten().size();
        }
        return result2;
    }

    @Override
    public Boolean visitVariadicType(OCVariadicType type2) {
        if (this.myType == type2) {
            return true;
        }
        if (this.myType == null || type2.getClass() != this.myType.getClass()) {
            return false;
        }
        OCVariadicType that = (OCVariadicType)this.myType;
        return this.equal(type2.getUnderlyingType(), that.getUnderlyingType(), true);
    }

    @Override
    public Boolean visitExpansionPackType(OCExpansionPackType type2) {
        if (this.myType == type2) {
            return true;
        }
        if (this.myType == null || type2.getClass() != this.myType.getClass()) {
            return false;
        }
        OCExpansionPackType that = (OCExpansionPackType)this.myType;
        return DeepEqual.equalObjects(type2.getExpansions(), that.getExpansions());
    }

    @Override
    public Boolean visitUnknownType(OCUnknownType type2) {
        return this.myType != null && type2.getClass() == this.myType.getClass();
    }

    @Override
    public Boolean visitVoidType(OCVoidType type2) {
        return this.myType != null && type2.getClass() == this.myType.getClass();
    }

    private static /* synthetic */ String lambda$visitStructType$0(FactoryMap map2, OCStructSymbol symbol) {
        return (String)map2.get((Object)symbol);
    }
}

