/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCInternator;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCAliasUsingSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLambdaExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCCompatibilityAliasSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCNonPrimitiveTypeCloneVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCloneVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeUnificationVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTypeResolveVisitor
extends OCNonPrimitiveTypeCloneVisitor {
    private static final int MAX_TYPES_TO_RESOLVE_PER_CONTEXT = 10000;
    private final boolean myResolveIgnoreImports;
    private final boolean myIsInOldC;
    private Set<VirtualFile> myUsedFiles = new HashSet<VirtualFile>();
    private OCFile myFile;
    @NotNull
    private final OCResolveContext myContext;
    private int myDepth;
    private int myMaxDepth = 256;
    private static final Key<CachedValue<Map<TypeKey, ResultInfo>>> RESOLVE_CACHE = Key.create((String)"RESOLVE_CACHE_IN_FILE");
    private static final OCInternator<ArrayList<VirtualFile>> USED_FILE_LIST_INTERNATOR = new OCInternator<ArrayList<VirtualFile>>(){

        @Override
        @NotNull
        protected ArrayList<VirtualFile> valueToStore(@NotNull ArrayList<VirtualFile> original) {
            original.trimToSize();
            return original;
        }
    };
    private static final Comparator<VirtualFile> FILE_PATH_COMPARATOR = (o1, o2) -> Comparing.compare((Comparable)((Object)o1.getPath()), (Comparable)((Object)o2.getPath()));

    public OCTypeResolveVisitor(@NotNull OCResolveContext context, boolean resolveIgnoreImports) {
        PsiFile psiFile = context.getFile();
        this.myFile = psiFile instanceof OCFile ? (OCFile)psiFile : null;
        this.myResolveIgnoreImports = resolveIgnoreImports;
        this.myContext = context;
        boolean bl = this.myIsInOldC = this.myFile != null && !this.myFile.isCpp();
        if (this.myFile instanceof OCCodeFragment) {
            PsiElement parent = this.myFile.getContext();
            this.myFile = parent != null ? (OCFile)parent.getContainingFile() : null;
        }
    }

    public OCTypeResolveVisitor(@Nullable PsiFile file2, boolean resolveIgnoreImports) {
        this(new OCResolveContext((PsiElement)file2), resolveIgnoreImports);
    }

    public OCTypeResolveVisitor(@NotNull OCResolveContext context) {
        this(context, false);
    }

    @Override
    public OCType visitStructType(OCStructType type2) {
        return type2;
    }

    @Override
    public OCType visitFunctionType(OCFunctionType type2) {
        List<String> oldParamNames = type2.getParameterNames(true);
        List<OCType> paramTypes = OCArgumentsList.expandVariadicTypes(type2.getParameterTypes(true), this.myContext);
        OCFunctionType functionType = (OCFunctionType)super.visitFunctionType(new OCFunctionType(type2.getReturnType(), paramTypes, null, type2.isConst(), type2.isVolatile(), type2.isLValueRef(), type2.isRValueRef()));
        List<OCType> parameterTypes = functionType.getParameterTypes(true);
        ArrayList<String> clonedNames = null;
        if (oldParamNames != null) {
            clonedNames = new ArrayList<String>();
            for (int i2 = 0; i2 < parameterTypes.size(); ++i2) {
                clonedNames.add(i2 < oldParamNames.size() ? oldParamNames.get(i2) : null);
            }
        }
        return new OCFunctionType(functionType.getReturnType(), parameterTypes, clonedNames, functionType.isConst(), functionType.isVolatile(), functionType.isLValueRef(), functionType.isRValueRef());
    }

    @Override
    public OCType visitAutoType(OCAutoType type2) {
        return this.getCachedOrResolve((OCType)type2, (TypeKey)this.getTypeKey((OCType)type2), (Object)PsiModificationTracker.MODIFICATION_COUNT).resolvedType;
    }

    @Override
    public OCType visitReferenceType(OCReferenceType type2) {
        ResultInfo resolved;
        if (type2.getReference(this.myFile).getQualifiedName().getName() == null) {
            return OCUnknownType.INSTANCE;
        }
        if (this.myFile == null) {
            return type2;
        }
        if (this.myDepth > this.myMaxDepth) {
            return type2;
        }
        ++this.myDepth;
        TypeKey typeKey = this.getTypeKey(type2);
        if (!this.myResolveIgnoreImports && type2.getReference(this.myFile) instanceof OCSymbolReference.GlobalReference) {
            resolved = this.getCachedOrResolve(type2, typeKey, FileSymbolTablesCache.getInstance(this.myFile.getProject()).getOutOfBlockModificationTracker());
        } else {
            OCType resolvedType = this.doResolve(type2, typeKey);
            Set<OCTypeParameterSymbol> dependencies = this.myContext.getTypeDependencies();
            resolved = new ResultInfo(resolvedType, this.myUsedFiles, !dependencies.isEmpty() ? dependencies : null);
        }
        --this.myDepth;
        OCFileSymbols.markImportsNeeded(this.myFile, resolved.usedFiles);
        OCType myGuessedType = type2.getGuessedType();
        return myGuessedType != type2 ? resolved.resolvedType.cloneWithGuessedType(myGuessedType.resolve(this.myFile)) : resolved.resolvedType;
    }

    protected ResultInfo getCachedOrResolve(OCType type2, TypeKey typeKey, Object modificationTracker) {
        ResultInfo resolved;
        Map cacheValue;
        ResultInfo cached;
        CachedValue cache2 = (CachedValue)this.myFile.getUserData(RESOLVE_CACHE);
        if (cache2 == null) {
            cache2 = CachedValuesManager.getManager((Project)this.myFile.getProject()).createCachedValue(() -> new CachedValueProvider.Result((Object)ContainerUtil.newConcurrentMap(), new Object[]{modificationTracker}), false);
            cache2 = (CachedValue)((UserDataHolderEx)this.myFile).putUserDataIfAbsent(RESOLVE_CACHE, (Object)cache2);
        }
        if ((cached = (ResultInfo)(cacheValue = (Map)cache2.getValue()).get(typeKey)) == null) {
            OCType resolvedType;
            Set<OCTypeParameterSymbol> oldDependencies = this.myContext.getTypeDependencies();
            this.myContext.clearTypeDependencies();
            if (type2 instanceof OCReferenceType) {
                OCReferenceType referenceType = (OCReferenceType)type2;
                resolvedType = this.doResolve(referenceType, typeKey);
                if (resolvedType instanceof OCArrayType && referenceType.isFunctionParameterType()) {
                    resolvedType = OCFunctionType.convertArrayParameterType(resolvedType);
                }
            } else {
                resolvedType = this.doResolve((OCAutoType)type2, typeKey);
            }
            Set<OCTypeParameterSymbol> dependencies = this.myContext.getTypeDependencies();
            dependencies = !dependencies.isEmpty() ? dependencies : null;
            resolved = new ResultInfo(resolvedType, this.internedUsedFilesCopy(), dependencies);
            this.myContext.addTypeDependencies(oldDependencies);
            if (!(resolvedType instanceof OCUnknownType) && !(resolvedType instanceof OCReferenceType)) {
                cacheValue.put(typeKey, resolved);
            }
        } else {
            resolved = cached;
            ContainerUtil.addAllNotNull(this.myUsedFiles, cached.usedFiles);
            if (cached.typeDependencies != null) {
                this.myContext.addTypeDependencies(cached.typeDependencies);
            }
        }
        return resolved;
    }

    @NotNull
    private TypeKey getTypeKey(OCType type2) {
        OCTypeSubstitution substitution = this.myContext.getSubstitution();
        if (!(type2 instanceof OCAutoType)) {
            substitution = substitution.getMinimalDependentSubstitution(type2, this.myContext);
        }
        return new TypeKey(type2, substitution, this.myContext.isInSFINAE());
    }

    @NotNull
    private Collection<VirtualFile> internedUsedFilesCopy() {
        if (this.myUsedFiles.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<VirtualFile> copy = new ArrayList<VirtualFile>(this.myUsedFiles);
        Collections.sort(copy, FILE_PATH_COMPARATOR);
        return USED_FILE_LIST_INTERNATOR.intern(copy);
    }

    private OCType doResolve(OCReferenceType type2, TypeKey typeKey) {
        int typesResolved = this.myContext.getTypeResolveCounter();
        this.myContext.incTypeResolveCounter();
        OCQualifiedName qualifiedName = type2.getReference(this.myFile).getQualifiedName();
        if (typesResolved > 10000) {
            return new OCMagicType(type2);
        }
        Resolver resolver = new Resolver(type2);
        String canonicalName = type2.getCanonicalName(this.myFile);
        OCSymbolReference.NameWithToken nameWithToken = OCSymbolReference.removeTypeToken(canonicalName);
        if (nameWithToken.typeToken != null) {
            resolver.setPreferableKind(OCSymbolKind.parse(nameWithToken.typeToken));
        }
        if (this.addProcessingType(typeKey)) {
            OCType answer;
            if (qualifiedName.getQualifier() == null && "id".equals(qualifiedName.getName())) {
                OCIdType idType = new OCIdType(resolver.getProtocols(false, true), resolver.getProtocols(false, false), this.myFile.getProject(), false, false);
                idType.attachNullability(type2.getNullability());
                return OCPointerType.to(idType, type2.getARCAttribute(), null, type2.getNullability(), false, false);
            }
            if (this.myResolveIgnoreImports || !this.processPossibleSymbols(type2, resolver, false) && this.myFile.isInLibraries()) {
                this.processPossibleSymbols(type2, resolver, true);
            }
            if ((answer = resolver.getAnswer()) != null) {
                answer = answer.cloneWithAddedCVQualifiers(type2.getCVQualifiers(), this.myContext.getProject());
            }
            this.removeProcessingType(typeKey);
            return answer != null ? answer : type2;
        }
        return OCUnknownType.INSTANCE;
    }

    protected OCType doResolve(OCAutoType type2, TypeKey typeKey) {
        OCTypeArgument argument;
        OCTypeParameterType typeParameterType;
        OCType result2;
        OCFunctionSymbol function;
        OCResolveContext context = this.myContext.substituteFirst(type2.getSubstitution());
        if (type2.needsAutoParamsResolving()) {
            return type2;
        }
        if (!this.addProcessingType(typeKey)) {
            return OCUnknownType.INSTANCE;
        }
        OCExpressionSymbol symbol = type2.getExpressionSymbol();
        OCExpression element = type2.getExpressionElement();
        if (type2.getLambdaExpression() != null) {
            Collection<OCType> expectedTypes = OCExpectedTypeUtil.getExpectedTypes(type2.getLambdaExpression(), false, this.myContext);
            OCType expectedType = ((OCType)ContainerUtil.getFirstItem(expectedTypes, (Object)OCUnknownType.INSTANCE)).resolve(this.myContext).getTerminalType();
            if (expectedType instanceof OCFunctionType) {
                OCType result3;
                List<OCType> parameterTypes = ((OCFunctionType)expectedType).getParameterTypes();
                if (type2.getParameterIndex() < parameterTypes.size() && !((result3 = parameterTypes.get(type2.getParameterIndex())).getTerminalType() instanceof OCAutoType)) {
                    return result3;
                }
            }
            this.removeProcessingType(typeKey);
            return type2;
        }
        if (symbol instanceof OCLambdaExpressionSymbol && (function = ((OCLambdaExpressionSymbol)symbol).getFunctionSymbol()) != null && function.isConstexpr() && type2.getIncompleteType() != null) {
            this.removeProcessingType(typeKey);
            return type2.getIncompleteType().resolve(context);
        }
        if (element != null && element.isValid() && !(element instanceof OCLambdaExpression)) {
            result2 = element.getResolvedType(context);
        } else {
            if (element != null && !element.isValid()) {
                PsiFile file2 = this.myContext.getFile();
                if (file2 != null) {
                    OCLog.LOG.error("Invalid PSI context in auto type", new Attachment[]{new Attachment(file2.getName(), file2.getText())});
                } else {
                    OCLog.LOG.error("Invalid PSI context in auto type");
                }
            }
            OCType oCType = result2 = symbol != null ? symbol.getResolvedType(context) : null;
        }
        if (result2 != null) {
            result2 = result2.cloneWithAddedCVQualifiers(type2.getCVQualifiers(), context.getProject());
        }
        this.removeProcessingType(typeKey);
        OCType incompleteType = type2.getIncompleteType();
        if (result2 instanceof OCAutoType && ((OCAutoType)result2).needsAutoParamsResolving() && (incompleteType == null || incompleteType instanceof OCAutoType)) {
            return result2;
        }
        if (result2 != null && element != null && element.getParent() instanceof OCForeachStatement && (result2 = OCCodeInsightUtil.getCollectionElementType(element, result2)) == null) {
            return OCUnknownType.INSTANCE;
        }
        if (result2 != null && incompleteType != null) {
            Map<OCTypeParameterSymbol, OCTypeArgument> substitutionMap;
            Map<OCType, OCType> map2;
            if (!(incompleteType instanceof OCCppReferenceType) && (result2 = result2.cloneWithCVQualifiers(CVQualifiers.EMPTY, context.getProject())) instanceof OCCppReferenceType) {
                result2 = OCCppReferenceType.to(((OCCppReferenceType)result2).getRefType().cloneWithCVQualifiers(CVQualifiers.EMPTY, context.getProject()), ((OCCppReferenceType)result2).isRvalueRef(), false, false);
            }
            if (OCSimpleTypeSubstitution.unify(incompleteType = OCTypeUtils.replaceAutoTypesWithTypeParameters(incompleteType, map2 = OCTypeUtils.newTypesMap()), result2, element, substitutionMap = OCTypeUtils.newTypeParameterMap(), null, true, false, context) != OCTypeUnificationVisitor.NOT_UNIFIED) {
                for (OCType typeParameterType2 : map2.values()) {
                    OCTypeParameterSymbol autoSymbol = ((OCTypeParameterType)typeParameterType2).getSymbol();
                    if (substitutionMap.containsKey(autoSymbol)) continue;
                    substitutionMap.put(autoSymbol, OCUnknownType.INSTANCE);
                }
                return new OCSimpleTypeSubstitution(substitutionMap).substitute(incompleteType, context);
            }
            return OCUnknownType.INSTANCE;
        }
        if (context.getAutoParamTypeMapping(type2) != null && (typeParameterType = context.getAutoParamTypeMapping(type2)) != null && (argument = context.getSubstitution().getSubstitutionFor(typeParameterType.getSymbol())) instanceof OCType) {
            return (OCType)argument;
        }
        return result2 != null ? result2 : (incompleteType != null ? incompleteType : type2);
    }

    private boolean processPossibleSymbols(OCReferenceType type2, Resolver resolver, boolean ignoreImports) {
        OCResolveContext context = this.myContext.substituteFirst(type2.getSubstitution());
        context.setProcessNonImported(ignoreImports);
        List<OCSymbol> symbols = context.resolveToSymbols(type2.getReference(this.myFile), false, false, false, true);
        int oldMaxDepth = this.myMaxDepth;
        if (context.wasDependentType()) {
            this.myMaxDepth = 6;
        }
        ContainerUtil.process(symbols, (Processor)resolver);
        this.myMaxDepth = oldMaxDepth;
        this.myContext.addTypeDependencies(context.getTypeDependencies());
        return !symbols.isEmpty();
    }

    private boolean addProcessingType(TypeKey typeKey) {
        return this.myContext.getResolvingTypes().add(typeKey);
    }

    private void removeProcessingType(TypeKey typeKey) {
        this.myContext.getResolvingTypes().remove(typeKey);
    }

    private boolean containsProcessingType(TypeKey typeKey) {
        return this.myContext.getResolvingTypes().contains(typeKey);
    }

    public static class OCObjectTypeReResolver
    extends OCTypeCloneVisitor {
        private PsiFile myFile;

        public OCObjectTypeReResolver(@Nullable PsiFile file2) {
            super(false);
            this.myFile = file2;
        }

        @Override
        public OCType visitObjectType(OCObjectType type2) {
            Function protocolNameCalculator = symbol -> symbol.getName();
            return OCReferenceType.fromText(type2.getClassName(), ContainerUtil.map(type2.getAllProtocols(), (Function)protocolNameCalculator)).resolve(this.myFile, true);
        }
    }

    private class Resolver
    implements Processor<OCSymbol> {
        private OCReferenceType myType;
        private OCType myAnswer;
        private OCInterfaceSymbol myInterface;
        private OCImplementationSymbol myImplementation;
        private List<OCInterfaceSymbol> myCategoryInterfaces = new ArrayList<OCInterfaceSymbol>();
        private List<OCImplementationSymbol> myCategoryImplementations = new ArrayList<OCImplementationSymbol>();
        private OCSymbolKind myPreferableKind;

        private Resolver(OCReferenceType type2) {
            this.myType = type2;
        }

        void setPreferableKind(OCSymbolKind kind2) {
            this.myPreferableKind = kind2;
        }

        private int getInterfaceClassRank(OCInterfaceSymbol clazz) {
            if (clazz == null) {
                return 0;
            }
            if (clazz.isPredeclaration()) {
                return 1;
            }
            return 2;
        }

        public boolean process(OCSymbol symbol) {
            OCSymbol definition;
            if (OCTypeResolveVisitor.this.myResolveIgnoreImports && symbol.isPredeclaration() && (definition = symbol.getDefinitionSymbol()) != null) {
                symbol = definition;
            }
            if (symbol instanceof OCClassSymbol) {
                OCClassSymbol aClass = (OCClassSymbol)symbol;
                if (aClass.getCategoryName() == null) {
                    if (aClass instanceof OCInterfaceSymbol && this.getInterfaceClassRank((OCInterfaceSymbol)aClass) > this.getInterfaceClassRank(this.myInterface)) {
                        this.myInterface = (OCInterfaceSymbol)aClass;
                        this.addUsedImport(symbol);
                    } else if (aClass instanceof OCImplementationSymbol) {
                        this.myImplementation = (OCImplementationSymbol)aClass;
                    }
                } else if (aClass instanceof OCInterfaceSymbol) {
                    this.myCategoryInterfaces.add((OCInterfaceSymbol)aClass);
                    if (!aClass.getProtocolNames().isEmpty()) {
                        this.addUsedImport(symbol);
                    }
                } else if (aClass instanceof OCImplementationSymbol) {
                    this.myCategoryImplementations.add((OCImplementationSymbol)aClass);
                }
            } else if (symbol instanceof OCDeclaratorSymbol || symbol instanceof OCCompatibilityAliasSymbol || symbol instanceof OCAliasUsingSymbol) {
                if (symbol.getKind().isTypedefOrAlias() && (this.isNullOrMagic(this.myAnswer) || this.myAnswer instanceof OCStructType)) {
                    OCType type2 = this.myType.getSubstitution().substitute(symbol.getType(), OCTypeResolveVisitor.this.myContext);
                    if ((type2 = type2.cloneWithAddedCVQualifiers(this.myType.getCVQualifiers(), OCTypeResolveVisitor.this.myContext.getProject())).getName().startsWith("__builtin")) {
                        this.myAnswer = OCUnknownType.INSTANCE;
                    } else if (!(type2 instanceof OCReferenceType && OCTypeResolveVisitor.this.containsProcessingType(OCTypeResolveVisitor.this.getTypeKey(type2)) || symbol.getContainingFile() == null || symbol.getProject() == null)) {
                        OCFile containingFile = symbol.getContainingOCFile();
                        if (containingFile != null) {
                            OCType inner = type2.accept(OCTypeResolveVisitor.this);
                            inner = this.myType.getSubstitution().substitute(inner, OCTypeResolveVisitor.this.myContext);
                            if (inner instanceof OCStructType) {
                                for (OCStructSymbol innerStruct : ((OCStructType)inner).getStructs()) {
                                    this.storeStructSymbolInAnswer(innerStruct, ((OCStructType)inner).getTypedefName());
                                }
                                this.myAnswer = this.myAnswer.cloneWithAddedCVQualifiers(inner.getCVQualifiers(), symbol.getProject());
                            }
                            if (this.myAnswer == null || this.myAnswer instanceof OCTypeParameterType && !(inner instanceof OCTypeParameterType)) {
                                this.myAnswer = this.handleSubstitutedVoid(inner);
                            }
                            if (symbol instanceof OCSymbolWithQualifiedName) {
                                OCSymbolWithQualifiedName substitutedSymbol = (OCSymbolWithQualifiedName)OCTypeResolveVisitor.this.myContext.getSubstitution().substitute(symbol, OCTypeResolveVisitor.this.myContext);
                                substitutedSymbol = this.myType.getSubstitution().substitute(substitutedSymbol, OCTypeResolveVisitor.this.myContext);
                                OCQualifiedName qualifiedName = substitutedSymbol.getResolvedQualifiedName(true, OCTypeResolveVisitor.this.myContext, true, true, true, true, true);
                                if (qualifiedName != null) {
                                    String alias = qualifiedName.getCanonicalName(OCType.Presentation.FULL, false, OCTypeResolveVisitor.this.myContext, 0);
                                    alias = CVQualifiers.appendCVQualifiers(alias, this.myType, OCTypeResolveVisitor.this.myContext.getProject());
                                    this.myAnswer = this.myAnswer.equals((Object)OCIntType.BOOL, containingFile) && Comparing.equal((String)"BOOL", (String)alias) ? OCIntType.BOOL : this.myAnswer.cloneWithAliasName(alias);
                                }
                            }
                        }
                    } else {
                        this.myAnswer = OCUnknownType.INSTANCE;
                    }
                    this.addUsedImport(symbol);
                    if (this.myAnswer == null) {
                        this.myAnswer = type2.cloneWithAliasName(this.myType.getCanonicalName(OCTypeResolveVisitor.this.myFile));
                    }
                    return true;
                }
            } else {
                if (symbol instanceof OCStructSymbol) {
                    if (this.myPreferableKind != null && this.myPreferableKind != symbol.getKind() || OCTypeResolveVisitor.this.myIsInOldC && this.myPreferableKind == null) {
                        return true;
                    }
                    this.addUsedImport(symbol);
                    this.storeStructSymbolInAnswer((OCStructSymbol)symbol, null);
                    return true;
                }
                if (symbol instanceof OCTypeParameterSymbol) {
                    TypeKey typeKey;
                    OCTypeArgument argument = this.myType.getSubstitution().getSubstitutionFor((OCTypeParameterSymbol)((Object)symbol));
                    String aliasName = null;
                    if (argument == null) {
                        argument = OCTypeResolveVisitor.this.myContext.getSubstitution().getSubstitutionFor((OCTypeParameterSymbol)((Object)symbol));
                    }
                    if (argument instanceof OCReferenceType || argument instanceof OCAutoType) {
                        OCType substituted = this.myType.getSubstitution().substitute((OCType)argument, OCTypeResolveVisitor.this.myContext);
                        this.myAnswer = substituted.accept(OCTypeResolveVisitor.this).cloneWithAliasName(this.myType.getCanonicalName(OCTypeResolveVisitor.this.myFile));
                        return true;
                    }
                    if (argument instanceof OCTypeParameterType && OCTypeResolveVisitor.this.addProcessingType(typeKey = OCTypeResolveVisitor.this.getTypeKey((OCType)argument))) {
                        boolean result2 = this.process((OCSymbol)((Object)((OCTypeParameterType)argument).getSymbol()));
                        OCTypeResolveVisitor.this.removeProcessingType(typeKey);
                        if (this.myAnswer != null) {
                            this.myAnswer = this.myAnswer.cloneWithAddedCVQualifiers(((OCTypeParameterType)argument).getCVQualifiers(), symbol.getProject());
                        }
                        return result2;
                    }
                    if (argument instanceof OCType) {
                        this.myAnswer = (OCType)argument;
                    } else if (this.myAnswer == null) {
                        this.myAnswer = new OCTypeParameterType((OCTypeParameterSymbol)((Object)symbol));
                    }
                    if (aliasName != null) {
                        this.myAnswer = this.myAnswer.cloneWithAliasName(aliasName);
                    }
                    this.myAnswer = this.handleSubstitutedVoid(this.myAnswer);
                } else if (symbol instanceof OCUsingSymbol) {
                    this.addUsedImport(symbol);
                    return ((OCUsingSymbol)symbol).getSymbolReference().processPossibleSymbols((Processor<OCSymbol>)this, OCTypeResolveVisitor.this.myFile);
                }
            }
            return true;
        }

        private OCType handleSubstitutedVoid(OCType answer) {
            if (this.myType.isFunctionParameterType() && answer.resolve(OCTypeResolveVisitor.this.myContext) instanceof OCVoidType) {
                return OCUnknownType.INSTANCE;
            }
            return answer;
        }

        private boolean isNullOrMagic(@Nullable OCType type2) {
            return type2 == null || type2 instanceof OCReferenceType || type2 instanceof OCTypeParameterType;
        }

        private void addUsedImport(@NotNull OCSymbol symbol) {
            ContainerUtil.addIfNotNull((Collection)OCTypeResolveVisitor.this.myUsedFiles, (Object)OCFileSymbols.getFileToImport(OCTypeResolveVisitor.this.myFile, symbol));
        }

        private void storeStructSymbolInAnswer(OCStructSymbol symbol, String typedefName) {
            List<OCTypeArgument> arguments;
            OCStructSymbol substitute = this.myType.getSubstitution().substitute(symbol, OCTypeResolveVisitor.this.myContext);
            OCQualifiedName qualifiedName = this.myType.getReference(OCTypeResolveVisitor.this.myFile).getQualifiedName();
            List<OCTypeArgument> list = arguments = qualifiedName instanceof OCQualifiedNameWithArguments ? ((OCQualifiedNameWithArguments)qualifiedName).getArguments() : null;
            if (this.myAnswer instanceof OCStructType) {
                List<OCStructSymbol> innerStructs = null;
                if (((OCStructType)this.myAnswer).isPredeclaration() && !symbol.isPredeclaration()) {
                    innerStructs = new ArrayList<OCStructSymbol>();
                    this.myAnswer = new OCStructType(innerStructs, typedefName, arguments);
                } else if (((OCStructType)this.myAnswer).isPredeclaration() == symbol.isPredeclaration() && !((OCStructType)this.myAnswer).getStructs().contains(substitute)) {
                    innerStructs = ((OCStructType)this.myAnswer).getStructs();
                }
                if (innerStructs != null) {
                    if (!innerStructs.isEmpty() && !Comparing.equal((String)((OCStructSymbol)innerStructs.get(0)).getName(), (String)substitute.getName())) {
                        this.myAnswer = OCUnknownType.INSTANCE;
                    }
                    innerStructs.add(substitute);
                }
            } else if (this.isNullOrMagic(this.myAnswer)) {
                ArrayList<OCStructSymbol> innerStructs = new ArrayList<OCStructSymbol>();
                innerStructs.add(substitute);
                this.myAnswer = new OCStructType(innerStructs, typedefName, arguments);
            }
        }

        public List<OCProtocolSymbol> getProtocols(boolean addDeclaredProtocols, boolean isTransitive) {
            ArrayDeque<String> queue = new ArrayDeque<String>(this.myType.getProtocolNames());
            if (addDeclaredProtocols) {
                if (this.myInterface != null) {
                    queue.addAll(this.myInterface.getProtocolNames());
                }
                for (OCInterfaceSymbol category : this.myCategoryInterfaces) {
                    queue.addAll(category.getProtocolNames());
                }
            }
            com.intellij.util.containers.HashSet processed2 = new com.intellij.util.containers.HashSet();
            ArrayList<OCProtocolSymbol> result2 = new ArrayList<OCProtocolSymbol>();
            while (!queue.isEmpty()) {
                String protocol = (String)queue.poll();
                if (processed2.contains(protocol)) continue;
                processed2.add(protocol);
                OCClassSymbol foundProtocol = null;
                for (OCSymbol symbol : OCSymbolReference.getGlobalReference(protocol, null).resolveToSymbols(OCTypeResolveVisitor.this.myFile)) {
                    if (!(symbol instanceof OCProtocolSymbol)) continue;
                    if (!symbol.isPredeclaration()) {
                        foundProtocol = (OCProtocolSymbol)symbol;
                        break;
                    }
                    foundProtocol = (OCProtocolSymbol)symbol;
                }
                if (foundProtocol == null) continue;
                result2.add((OCProtocolSymbol)foundProtocol);
                if (!isTransitive) continue;
                queue.addAll(foundProtocol.getProtocolNames());
            }
            return result2;
        }

        @Nullable
        public OCType getAnswer() {
            if (this.myAnswer != null) {
                return this.myAnswer;
            }
            if (this.myInterface != null || this.myImplementation != null || this.myType.getProtocolNames().size() > 0) {
                OCReferenceType superType;
                OCType resolved;
                OCObjectType resolvedSuper = null;
                if ((this.myInterface != null || this.myImplementation != null) && (resolved = OCTypeResolveVisitor.this.visitReferenceType(superType = this.myInterface != null ? this.myInterface.getSuperType() : this.myImplementation.getSuperType())) instanceof OCObjectType) {
                    resolvedSuper = (OCObjectType)resolved;
                }
                OCObjectType answer = new OCObjectType(this.myInterface, this.myImplementation, this.getProtocols(true, true), this.getProtocols(false, false), this.myCategoryInterfaces, this.myCategoryImplementations, resolvedSuper, false, false, this.myType.isKindof());
                answer.attachNullability(this.myType.getNullability());
                return answer;
            }
            return null;
        }
    }

    public static class TypeKey {
        private OCType type;
        private OCTypeSubstitution substitution;
        private final boolean isInSFINAE;

        public TypeKey(OCType type2, OCTypeSubstitution substitution, boolean isInSFINAE) {
            this.type = type2;
            this.substitution = substitution;
            this.isInSFINAE = isInSFINAE;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TypeKey)) {
                return false;
            }
            TypeKey key2 = (TypeKey)obj;
            return DeepEqual.equalObjects(this.type, key2.type) && DeepEqual.equalObjects(this.substitution, key2.substitution) && this.isInSFINAE == key2.isInSFINAE;
        }

        public int hashCode() {
            int result2 = this.type != null ? this.type.hashCode() : 0;
            result2 = 31 * result2 + (this.substitution != null ? this.substitution.hashCode() : 0);
            result2 = 31 * result2 + (this.isInSFINAE ? 1 : 0);
            return result2;
        }
    }

    private static class ResultInfo {
        final OCType resolvedType;
        final Collection<VirtualFile> usedFiles;
        final Set<OCTypeParameterSymbol> typeDependencies;

        private ResultInfo(OCType type2, Collection<VirtualFile> files, Set<OCTypeParameterSymbol> typeDependencies) {
            this.resolvedType = type2;
            this.usedFiles = files;
            this.typeDependencies = typeDependencies;
        }
    }
}

