/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.util.Processor;
import com.intellij.util.Producer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithSubstitution;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCAliasUsingSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCCallExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCReferenceExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCSizeofExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbolImpl;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCReferenceTypeBuilder;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.visitors.OCBooleanTypeVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCMultiTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCNonPrimitiveTypeCloneVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCTypeSubstitution
implements Serializable,
DeepEqual.Equality {
    public static final OCSimpleTypeSubstitution ID = new OCSimpleTypeSubstitution(OCTypeUtils.newTypeParameterMap());

    public abstract OCType substitute(@NotNull OCType var1, @NotNull OCResolveContext var2);

    public abstract OCTypeArgument getSubstitutionFor(@NotNull OCTypeParameterSymbol var1);

    public abstract Collection<OCTypeArgument> getSubstitutedTypes();

    public abstract boolean processSubstitutions(Processor<Map.Entry<OCTypeParameterSymbol, OCTypeArgument>> var1);

    public abstract boolean hasSubstitutionForName(@NotNull String var1);

    public static OCTypeSubstitution compose(OCTypeSubstitution a, OCTypeSubstitution b, @NotNull OCResolveContext context) {
        return OCTypeSubstitution.compose(a, b, false, context);
    }

    public static OCTypeSubstitution compose(OCTypeSubstitution a, OCTypeSubstitution b, boolean overwriteSubstitution, @NotNull OCResolveContext context) {
        if (a == ID) {
            return b;
        }
        if (b == ID) {
            return a;
        }
        if (a.equals(b)) {
            return a;
        }
        TObjectHashingStrategy<OCSimpleTypeSubstitution> strategy = new TObjectHashingStrategy<OCSimpleTypeSubstitution>(){

            public int computeHashCode(OCSimpleTypeSubstitution object) {
                return object.hashCode();
            }

            public boolean equals(OCSimpleTypeSubstitution o1, OCSimpleTypeSubstitution o2) {
                return o1.equals(o2);
            }
        };
        THashSet oldSubsts = new THashSet((TObjectHashingStrategy)strategy);
        THashSet newSubsts = new THashSet((TObjectHashingStrategy)strategy);
        HashMap map2 = new HashMap();
        if (a instanceof OCMultiTypeSubstitution) {
            oldSubsts.addAll(((OCMultiTypeSubstitution)a).getSubstitutions());
        } else {
            oldSubsts.add((OCSimpleTypeSubstitution)a);
        }
        if (b instanceof OCMultiTypeSubstitution) {
            newSubsts.addAll(((OCMultiTypeSubstitution)b).getSubstitutions());
        } else {
            newSubsts.add((OCSimpleTypeSubstitution)b);
        }
        for (OCSimpleTypeSubstitution substitution : oldSubsts) {
            for (OCTypeParameterSymbol typeParam : substitution.getTypeParameters()) {
                map2.put(typeParam, substitution);
            }
        }
        for (OCSimpleTypeSubstitution substitution : newSubsts) {
            if (oldSubsts.contains(substitution)) continue;
            if (overwriteSubstitution) {
                oldSubsts.add(substitution);
                for (OCTypeParameterSymbol typeParam : substitution.getTypeParameters()) {
                    OCSimpleTypeSubstitution oldSubst = (OCSimpleTypeSubstitution)map2.get(typeParam);
                    if (oldSubst == null) continue;
                    Map<OCTypeParameterSymbol, OCTypeArgument> substMap = oldSubst.getSubstitutions();
                    oldSubsts.remove(oldSubst);
                    if (substMap.size() <= 1) continue;
                    map2.remove(typeParam);
                    HashMap newSubstMap = new HashMap(substMap);
                    newSubstMap.remove(typeParam);
                    OCSimpleTypeSubstitution newSubst = new OCSimpleTypeSubstitution((Map<OCTypeParameterSymbol, OCTypeArgument>)newSubstMap);
                    oldSubsts.add(newSubst);
                    for (OCTypeParameterSymbol typeParameter : newSubst.getTypeParameters()) {
                        map2.put(typeParameter, newSubst);
                    }
                }
                continue;
            }
            if (ContainerUtil.intersects(substitution.getTypeParameters(), map2.keySet())) continue;
            oldSubsts.add(substitution);
        }
        return new OCMultiTypeSubstitution(new ArrayList<OCSimpleTypeSubstitution>((Collection<OCSimpleTypeSubstitution>)oldSubsts));
    }

    public boolean dependsOn(@Nullable OCSymbolReference reference, @NotNull OCResolveContext context) {
        if (reference instanceof OCSymbolReference.GlobalReference) {
            OCSymbolReference.GlobalReference globalReference = (OCSymbolReference.GlobalReference)reference;
            return this.dependsOn(globalReference.getSymbolContext(), context) || this.dependsOn(globalReference.getQualifiedName(), context);
        }
        return true;
    }

    public boolean dependsOn(@NotNull OCQualifiedName name, @NotNull OCResolveContext context) {
        if (name instanceof OCQualifiedNameWithArguments) {
            for (OCTypeArgument argument : ((OCQualifiedNameWithArguments)name).getArguments()) {
                if (!this.dependsOn(argument, context)) continue;
                return true;
            }
        }
        return name.getQualifier() != null && this.dependsOn(name.getQualifier(), context);
    }

    public boolean dependsOn(@Nullable OCTypeArgument argument, final @NotNull OCResolveContext context) {
        if (argument instanceof OCExpressionTypeArgument) {
            return this.dependsOn(((OCExpressionTypeArgument)argument).getSymbol(), context);
        }
        if (argument instanceof OCType) {
            return ((OCType)argument).accept(new OCBooleanTypeVisitor(){

                @Override
                public Boolean visitReferenceType(OCReferenceType type2) {
                    return OCTypeSubstitution.this.dependsOn(type2.getReference(context), context) || type2.getSubstitution().dependsOn(OCTypeSubstitution.this, context);
                }

                @Override
                public Boolean visitStructType(OCStructType type2) {
                    return OCTypeSubstitution.this.dependsOn(type2.getSymbol(), context);
                }

                @Override
                public Boolean visitObjectType(OCObjectType type2) {
                    return OCTypeSubstitution.this.dependsOn(type2.getClassSymbol(), context);
                }

                @Override
                public Boolean visitTypeParameterType(OCTypeParameterType type2) {
                    return OCTypeSubstitution.this.dependsOn((OCSymbol)((Object)type2.getSymbol()), context);
                }

                @Override
                public Boolean visitAutoType(OCAutoType type2) {
                    return OCTypeSubstitution.this.dependsOn(type2.getExpressionSymbol(), context) || OCTypeSubstitution.this.dependsOn(type2.getSubstitution(), context);
                }
            });
        }
        return false;
    }

    public boolean dependsOn(@Nullable OCSymbol symbol, final @NotNull OCResolveContext context) {
        if (this == ID || symbol == null || symbol.getKind() == OCSymbolKind.NAMESPACE) {
            return false;
        }
        OCSymbol<Object> parent = symbol;
        if (symbol instanceof OCExpressionSymbol) {
            return ((OCExpressionSymbol)symbol).evaluate(new OCExpressionEvaluator.CachingEvaluator<Boolean>(context){

                @Override
                @Nullable
                public Boolean evalInteger(Number value2) {
                    return false;
                }

                @Override
                @Nullable
                public Boolean evalBool(Boolean value2) {
                    return false;
                }

                @Override
                @Nullable
                public Boolean evalDefault(OCExpression psi) {
                    return false;
                }

                @Override
                @Nullable
                public Boolean evalBinary(OCElementType t, @Nullable Boolean l, @Nullable Boolean r) {
                    return l == Boolean.TRUE || r == Boolean.TRUE;
                }

                @Override
                @Nullable
                public Boolean evalUnary(OCElementType t, @Nullable Boolean arg) {
                    return arg;
                }

                @Override
                @Nullable
                public Boolean evalConditional(Boolean condition2, @Nullable Producer<Boolean> l, @Nullable Producer<Boolean> r) {
                    return condition2 == Boolean.TRUE || l.produce() == Boolean.TRUE || r.produce() == Boolean.TRUE;
                }

                @Override
                @Nullable
                public Boolean evalCast(OCType type2, Boolean operand2) {
                    return operand2 == Boolean.TRUE || OCTypeSubstitution.this.dependsOn(type2, context);
                }

                @Override
                @Nullable
                public Boolean evalCall(OCCallExpressionSymbol symbol) {
                    if (symbol.getCalleeSymbol().evaluate(this) == Boolean.TRUE) {
                        return true;
                    }
                    for (OCExpressionSymbol argSymbol : symbol.getArguments()) {
                        if (argSymbol.evaluate(this) != Boolean.TRUE) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                @Nullable
                public Boolean evalReference(OCReferenceExpressionSymbol symbol) {
                    return OCTypeSubstitution.this.dependsOn(symbol.getReference(), context);
                }

                @Override
                @Nullable
                public Boolean evalSizeof(OCSizeofExpressionSymbol symbol) {
                    OCExpressionSymbol operand2 = symbol.getExpressionOperand();
                    return operand2 != null && operand2.evaluate(this) == Boolean.TRUE || OCTypeSubstitution.this.dependsOn(symbol.getTypeOperand(), context);
                }
            }) == Boolean.TRUE;
        }
        if (symbol instanceof OCTypeParameterSymbol) {
            return this.getSubstitutionFor((OCTypeParameterSymbol)((Object)symbol)) != null || this.dependsOn((OCTypeArgument)((OCTypeParameterSymbol)((Object)symbol)).getDefaultValue(), context);
        }
        while (parent instanceof OCSymbolWithParent) {
            if (parent instanceof OCSymbolWithSubstitution) {
                // empty if block
            }
            if (parent instanceof OCTemplateSymbol) {
                for (OCTypeParameterSymbol param : ((OCTemplateSymbol)parent).getTemplateParameters()) {
                    if (((OCSymbolWithSubstitution)((Object)parent)).getSubstitution().getSubstitutionFor(param) != null || this.getSubstitutionFor(param) == null) continue;
                    return true;
                }
            }
            parent = ((OCSymbolWithParent)parent).getParent();
        }
        return false;
    }

    public boolean dependsOn(Collection<Object> list, @NotNull OCResolveContext context) {
        for (Object object : list) {
            if (!this.dependsOn(object, context)) continue;
            return true;
        }
        return false;
    }

    public boolean dependsOn(@Nullable Object object, @NotNull OCResolveContext context) {
        if (object instanceof OCSymbolReference) {
            return this.dependsOn((OCSymbolReference)object, context);
        }
        if (object instanceof OCQualifiedName) {
            return this.dependsOn((OCQualifiedName)object, context);
        }
        if (object instanceof OCTypeArgument) {
            return this.dependsOn((OCTypeArgument)object, context);
        }
        if (object instanceof OCSymbol) {
            return this.dependsOn((OCSymbol)object, context);
        }
        if (object instanceof Collection) {
            return this.dependsOn((Collection)object, context);
        }
        if (object instanceof OCSimpleTypeSubstitution) {
            return this.dependsOn(((OCSimpleTypeSubstitution)object).getSubstitutedTypes(), context);
        }
        if (object != null) {
            throw new IllegalArgumentException(object.getClass().getName());
        }
        return false;
    }

    protected boolean dependsOn(OCTypeSubstitution substitution, @NotNull OCResolveContext context) {
        for (OCTypeArgument argument : substitution.getSubstitutedTypes()) {
            if (!this.dependsOn(argument, context)) continue;
            return true;
        }
        return false;
    }

    public OCTypeSubstitution getMinimalDependentSubstitution(Object reference, @NotNull OCResolveContext context) {
        return this.dependsOn(reference, context) ? this : ID;
    }

    public <T extends OCSymbol> T substitute(T symbol, @NotNull OCResolveContext context) {
        return this.substitute(symbol, null, false, context);
    }

    public <T extends OCSymbol> T substitute(T symbol, @Nullable OCSymbolWithQualifiedName parent, boolean overwriteSubstitution, @NotNull OCResolveContext context) {
        if (symbol == null || this == ID || !this.dependsOn(symbol, context)) {
            return symbol;
        }
        OCTypeSubstitution minSubstitution = this.getMinimalDependentSubstitution(symbol, context);
        if (symbol instanceof OCTypeParameterValueSymbol) {
            return (T)new OCTypeParameterValueSymbol((OCTypeParameterValueSymbol)symbol, minSubstitution, context);
        }
        if (symbol instanceof OCStructSymbol) {
            return (T)new OCStructSymbol((OCStructSymbol)symbol, minSubstitution, parent != null ? parent : this.substitute(((OCStructSymbol)symbol).getParent(), context), overwriteSubstitution, context);
        }
        if (symbol instanceof OCFunctionSymbol) {
            return (T)new OCFunctionSymbol((OCFunctionSymbol)symbol, minSubstitution, parent != null ? parent : this.substitute(((OCFunctionSymbol)symbol).getParent(), context), context);
        }
        if (symbol instanceof OCDeclaratorSymbol) {
            return (T)new OCDeclaratorSymbol((OCDeclaratorSymbol)symbol, minSubstitution, ((OCDeclaratorSymbol)symbol).getQualifiedName(), parent != null ? parent : this.substitute(((OCDeclaratorSymbol)symbol).getParent(), context), context);
        }
        if (symbol instanceof OCUsingSymbol) {
            return (T)new OCUsingSymbol((OCUsingSymbol)symbol, minSubstitution, context);
        }
        if (symbol instanceof OCAliasUsingSymbol) {
            return (T)new OCAliasUsingSymbol((OCAliasUsingSymbol)symbol, minSubstitution, context);
        }
        if (symbol instanceof OCInterfaceSymbolImpl) {
            return (T)new OCInterfaceSymbolImpl((OCInterfaceSymbolImpl)symbol, minSubstitution, overwriteSubstitution, context);
        }
        if (symbol instanceof OCMethodSymbolImpl) {
            return (T)new OCMethodSymbolImpl((OCMethodSymbolImpl)symbol, minSubstitution, context);
        }
        if (symbol instanceof OCPropertySymbolImpl) {
            return (T)new OCPropertySymbolImpl((OCPropertySymbolImpl)symbol, minSubstitution, context);
        }
        return symbol;
    }

    @NotNull
    public <T extends OCSymbol> List<T> substitute(List<T> symbols, @NotNull OCResolveContext context) {
        if (this == ID) {
            return symbols;
        }
        ArrayList<OCSymbol> result2 = new ArrayList<OCSymbol>();
        for (OCSymbol symbol : symbols) {
            result2.add(this.substitute(symbol, context));
        }
        return result2;
    }

    public boolean equals(Object o) {
        return DeepEqual.equalObjects(this, o);
    }

    @NotNull
    protected static OCReferenceType substituteReferenceType(@NotNull OCReferenceType type2, OCTypeSubstitution substitution, @NotNull OCResolveContext context) {
        OCReferenceTypeBuilder typeBuilder = new OCReferenceTypeBuilder(type2.getReference(context));
        typeBuilder.setConstVolatile(type2);
        typeBuilder.setProtocolNames(type2.getProtocolNames());
        typeBuilder.setSubstitution(OCTypeSubstitution.compose(type2.getSubstitution(), substitution, context));
        typeBuilder.setFunctionParameterType(type2.isFunctionParameterType());
        return typeBuilder.build();
    }

    protected static class TypeSubstituteVisitor
    extends OCNonPrimitiveTypeCloneVisitor {
        private OCTypeSubstitution mySubstitution;
        @NotNull
        private OCResolveContext mycontext;

        TypeSubstituteVisitor(OCTypeSubstitution substitution, @NotNull OCResolveContext context) {
            this.mySubstitution = substitution;
            this.mycontext = context;
        }

        @Override
        public OCType visitReferenceType(OCReferenceType type2) {
            return OCTypeSubstitution.substituteReferenceType(type2, this.mySubstitution, this.mycontext);
        }

        @Override
        public OCType visitAutoType(OCAutoType type2) {
            return new OCAutoType(type2, this.mySubstitution, this.mycontext);
        }

        @Override
        public OCType visitStructType(OCStructType type2) {
            return new OCStructType(ContainerUtil.map(type2.getStructs(), symbol -> this.mySubstitution.substitute(symbol, this.mycontext)), type2.getTypedefName(), type2.isConst(), type2.isVolatile());
        }
    }
}

