/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.ui;

import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.AbstractTreeClassChooserDialog;
import com.intellij.ide.util.TreeChooser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.jetbrains.cidr.lang.navigation.OCGotoClassContributor;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCClassChooserDialog
extends AbstractTreeClassChooserDialog<OCSymbolHolderVirtualPsiElement> {
    private Condition<OCSymbol> mySymbolCondition;

    public OCClassChooserDialog(String title, Project project2, TreeChooser.Filter<OCSymbolHolderVirtualPsiElement> filter, @Nullable OCSymbolHolderVirtualPsiElement initialClass, Condition<OCSymbol> symbolCondition) {
        super(title, project2, OCSearchScope.getProjectSourcesScope(project2), OCSymbolHolderVirtualPsiElement.class, filter, null, initialClass, false, false);
        this.mySymbolCondition = symbolCondition;
    }

    @Override
    @Nullable
    protected OCSymbolHolderVirtualPsiElement getSelectedFromTreeUserObject(DefaultMutableTreeNode node) {
        Object userObject = node.getUserObject();
        if (!(userObject instanceof PsiFileNode)) {
            return null;
        }
        PsiFile psiFile = (PsiFile)((PsiFileNode)((Object)userObject)).getValue();
        OCSymbolDeclarator firstClass = psiFile instanceof OCFile ? ((OCFile)psiFile).findFirstClass() : null;
        OCSymbol symbol = firstClass != null ? (OCSymbol)firstClass.getSymbol() : null;
        return symbol != null && this.mySymbolCondition.value(symbol) ? new OCSymbolHolderVirtualPsiElement(symbol) : null;
    }

    @Override
    @NotNull
    protected List<OCSymbolHolderVirtualPsiElement> getClassesByName(String name, boolean checkBoxState, String pattern, GlobalSearchScope searchScope) {
        OCSymbol[] items = new OCGotoClassContributor().getSymbolsByName(name, this.getProject(), searchScope.isSearchInLibraries(), this.mySymbolCondition, true);
        ArrayList<OCSymbolHolderVirtualPsiElement> result2 = new ArrayList<OCSymbolHolderVirtualPsiElement>();
        for (OCSymbol item : items) {
            OCSymbol symbol = item;
            if (!searchScope.contains(symbol.getContainingFile())) continue;
            result2.add(new OCSymbolHolderVirtualPsiElement(symbol));
        }
        return result2;
    }
}

