/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.ui;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.ui.OCFieldAdapter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFieldAdapterForSymbolName
implements OCFieldAdapter<OCSymbol> {
    public static final OCFieldAdapterForSymbolName INSTANCE = new OCFieldAdapterForSymbolName();

    @Override
    @NotNull
    public String getName(@NotNull OCSymbol symbol) {
        return symbol.getName();
    }

    @Override
    public Icon getIcon(@NotNull OCSymbol item) {
        return item.getIcon();
    }

    @Override
    public String getTypeText(@NotNull OCSymbol item) {
        VirtualFile file2;
        if (item instanceof OCSymbolWithQualifiedName) {
            OCQualifiedName name;
            OCSymbolWithQualifiedName owner = ((OCSymbolWithQualifiedName)item).getResolvedOwner();
            if (item instanceof OCFunctionSymbol && owner != null) {
                owner = owner.getResolvedOwner();
            }
            if (owner != null && (name = owner.getResolvedQualifiedName()) != null) {
                return name.getCanonicalName(true).substring(2);
            }
        }
        return (file2 = item.getContainingFile()) != null ? file2.getName() : "";
    }

    @Override
    @NotNull
    public String getReadableName(@NotNull OCSymbol symbol) {
        return symbol.getPresentableName();
    }

    protected boolean isTopLevelOnly() {
        return true;
    }

    @Override
    @NotNull
    public Collection<OCSymbol> collectValuesFromProject(final @NotNull Project project2, final @Nullable Condition<OCSymbol> condition2) {
        if (project2.isDisposed()) {
            return Collections.emptyList();
        }
        List allValues = OCFieldAdapter.collectAllValues(project2, Collections.emptyList(), () -> {
            if (project2.isDisposed()) {
                return Collections.emptyList();
            }
            CommonProcessors.CollectProcessor allCollector = new CommonProcessors.CollectProcessor();
            OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project2, (Processor<OCSymbol>)allCollector, null, this.isTopLevelOnly());
            return allCollector.getResults();
        });
        return (Collection)OCFieldAdapter.computeWithWriteActionPriority(indicator -> {
            CommonProcessors.CollectProcessor<OCSymbol> collector = new CommonProcessors.CollectProcessor<OCSymbol>(){
                final Set uniquePresentationName = new HashSet();

                protected boolean accept(OCSymbol item) {
                    ProgressManager.checkCanceled();
                    Boolean res = null;
                    while (res == null) {
                        try {
                            res = (Boolean)ProgressManager.getInstance().runProcess(() -> (Boolean)ApplicationManager.getApplication().runReadAction(() -> {
                                if (project2.isDisposed()) {
                                    return false;
                                }
                                String mappedSymbolName = OCFieldAdapterForSymbolName.this.getReadableName(item);
                                if (!this.uniquePresentationName.contains(mappedSymbolName) && (condition2 == null || condition2.value((Object)item))) {
                                    this.uniquePresentationName.add(mappedSymbolName);
                                    return true;
                                }
                                return false;
                            }), indicator);
                        }
                        catch (ProcessCanceledException processCanceledException) {}
                    }
                    return res;
                }
            };
            ContainerUtil.process((Iterable)allValues, (Processor)collector);
            return collector.getResults();
        });
    }

    @Override
    @NotNull
    public PrefixMatcher createPrefixMatcher(@NotNull String prefix) {
        boolean caseSensitive = CodeInsightSettings.getInstance().COMPLETION_CASE_SENSITIVE != 3 && CodeInsightSettings.getInstance().COMPLETION_CASE_SENSITIVE != 2;
        return new CamelHumpMatcher(prefix, caseSensitive);
    }

    @Override
    public String getPrefix(@NotNull String text, int offset) {
        int i2 = text.lastIndexOf(32, offset - 1) + 1;
        int j = text.lastIndexOf(10, offset - 1) + 1;
        return text.substring(Math.max(i2, j), offset);
    }
}

