/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ReferenceEditorWithBrowseButton;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.ui.OCFileChooserDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFileReferenceEditor
extends ReferenceEditorWithBrowseButton {
    private OCFile myLastSelectedFile;

    public OCFileReferenceEditor(ActionListener browseActionListener, EditorTextField editorTextField, Function<String, Document> factory) {
        super(browseActionListener, editorTextField, factory);
    }

    public static OCFileReferenceEditor create(final Project project2) {
        final Ref result2 = Ref.create(null);
        ArrayList<OCFile> files = new ArrayList<OCFile>();
        ClassCompletionProvider completionProvider = new ClassCompletionProvider((Collection<OCFile>)files);
        TextFieldWithAutoCompletion<OCFile> textField = new TextFieldWithAutoCompletion<OCFile>(project2, completionProvider, false, null);
        Function documentFactory = s -> {
            textField.setText((String)s);
            return textField.getDocument();
        };
        result2.set((Object)new OCFileReferenceEditor(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OCFileChooserDialog dialog2 = new OCFileChooserDialog("Choose Containing Class", project2);
                dialog2.showDialog();
                if (dialog2.isOK()) {
                    OCFile selectedFile = (OCFile)dialog2.getSelected();
                    ((OCFileReferenceEditor)((Object)result2.get())).myLastSelectedFile = selectedFile;
                    ((OCFileReferenceEditor)((Object)result2.get())).setText(selectedFile.getName());
                }
            }
        }, textField, (Function<String, Document>)documentFactory));
        return (OCFileReferenceEditor)((Object)result2.get());
    }

    @Nullable
    public OCFile getFile(@NotNull Project project2) {
        return (OCFile)ContainerUtil.getFirstItem(OCSearchUtil.getProjectOCFilesByName(project2, this.getText()));
    }

    private static class ClassCompletionProvider
    extends TextFieldWithAutoCompletionListProvider<OCFile> {
        protected ClassCompletionProvider(@Nullable Collection<OCFile> variants) {
            super(variants);
        }

        @Override
        protected Icon getIcon(@NotNull OCFile file2) {
            return file2.getIcon(0);
        }

        @Override
        @NotNull
        protected String getLookupString(@NotNull OCFile file2) {
            return file2.getName();
        }

        @Override
        protected String getTailText(@NotNull OCFile file2) {
            VirtualFile virtualFile = file2.getVirtualFile();
            VirtualFile parent = virtualFile != null ? virtualFile.getParent() : null;
            return parent != null ? parent.getPath() : null;
        }

        @Override
        protected String getTypeText(@NotNull OCFile file2) {
            return null;
        }

        @Override
        public int compare(OCFile file1, OCFile file2) {
            return file1.getName().compareTo(file2.getName());
        }
    }
}

