/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.ui;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.ClickListener;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextListener;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCConfigurationOwner;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveLanguageAndConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCResolveContextPanel
extends EditorBasedWidget
implements StatusBarWidget.Multiframe,
CustomStatusBarWidget {
    public static final String ID = "ActiveOCBuildConfiguration";
    private final TextPanel myComponent;
    private volatile boolean myActionEnabled;
    private volatile boolean myHasList;
    private JLabel myArrowsIcon = new JLabel(AllIcons.Ide.Statusbar_arrows);
    private final AsyncProcessIcon myRepoActivityIcon = OCResolveContextPanel.createActivityIcon("Resolve Context Activity");
    private ProgressIndicator myCurrentProgress;
    @Nullable
    private volatile VirtualFile myCurrentFile;
    private volatile boolean isCalculatingContext;

    @NotNull
    private static AsyncProcessIcon createActivityIcon(@NotNull String name) {
        AsyncProcessIcon icon = new AsyncProcessIcon(name).setUseMask(false);
        icon.setPaintPassiveIcon(false);
        icon.setOpaque(false);
        icon.suspend();
        return icon;
    }

    public OCResolveContextPanel(@NotNull Project project2) {
        super(project2);
        this.myComponent = new TextPanel(){

            @Override
            public void doLayout() {
                super.doLayout();
                Rectangle r = this.getBounds();
                Insets insets = this.getInsets();
                Dimension aSize = OCResolveContextPanel.this.myRepoActivityIcon.getMinimumSize();
                int aWidth = (int)aSize.getWidth();
                int aHeight = (int)aSize.getHeight();
                OCResolveContextPanel.this.myRepoActivityIcon.setBounds(r.width - insets.right - aWidth, r.height / 2 - aHeight / 2, aWidth, aHeight);
                Icon icon = OCResolveContextPanel.this.myArrowsIcon.getIcon();
                int iconWidth = icon.getIconWidth();
                int iconHeight = icon.getIconHeight();
                OCResolveContextPanel.this.myArrowsIcon.setBounds(r.width - insets.right - iconWidth - 2, r.height / 2 - iconHeight / 2, iconWidth, iconHeight);
            }
        };
        this.myComponent.add(this.myArrowsIcon);
        this.myComponent.add((Component)this.myRepoActivityIcon);
        this.myComponent.setRightPadding((int)(this.myRepoActivityIcon.getMinimumSize().getWidth() + 6.0));
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (OCResolveContextPanel.this.myHasList) {
                    OCResolveContextPanel.this.showPopup(e);
                }
                return true;
            }
        }.installOn((Component)this.myComponent);
        this.myComponent.setBorder(StatusBarWidget.WidgetBorder.INSTANCE);
        class Listener
        implements DumbService.DumbModeListener,
        OCInclusionContextListener {
            volatile boolean isDumbMode;

            Listener() {
            }

            public void enteredDumbMode() {
                this.isDumbMode = true;
                OCResolveContextPanel.this.scheduleUpdate();
            }

            public void exitDumbMode() {
                this.isDumbMode = false;
                OCResolveContextPanel.this.scheduleUpdate();
            }

            @Override
            public void resolveRootAndActiveConfigurationChanged(@NotNull VirtualFile file2, @NotNull OCResolveRootAndConfiguration rootAndConfiguration) {
                if (!OCResolveContextPanel.this.isCalculatingContext && !this.isDumbMode && file2.equals(OCResolveContextPanel.this.myCurrentFile)) {
                    OCResolveContextPanel.this.scheduleUpdate();
                }
            }
        }
        Listener listener2 = new Listener();
        this.myConnection.subscribe(DumbService.DUMB_MODE, (Object)listener2);
        this.myConnection.subscribe(OCInclusionContextListener.TOPIC, (Object)listener2);
        this.scheduleUpdate();
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        this.scheduleUpdate();
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
        this.scheduleUpdate();
    }

    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
        this.scheduleUpdate();
    }

    public StatusBarWidget copy() {
        return new OCResolveContextPanel(this.myProject);
    }

    @NotNull
    public String ID() {
        return ID;
    }

    public TextPanel getComponent() {
        return this.myComponent;
    }

    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type2) {
        return null;
    }

    private void showPopup(MouseEvent e) {
        ListPopup popup = this.getPopupStep(DataManager.getInstance().getDataContext((Component)this.myStatusBar));
        if (popup == null) {
            return;
        }
        Dimension dimension = popup.getContent().getPreferredSize();
        Point at = new Point(0, -dimension.height);
        popup.show(new RelativePoint(e.getComponent(), at));
        Disposer.register((Disposable)this, (Disposable)popup);
    }

    public ListPopup getPopupStep(@NotNull DataContext context) {
        VirtualFile file2 = this.getSelectedFile();
        if (file2 == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file2);
        if (!OCResolveContextPanel.isAppropriateFile(psiFile)) {
            return null;
        }
        Pair<Collection<? extends OCResolveConfiguration>, Boolean> configurations = OCResolveContextPanel.getFileConfigurations(psiFile, true, null);
        DefaultActionGroup group = new DefaultActionGroup();
        if (!((Boolean)configurations.second).booleanValue()) {
            group.addSeparator("All project contexts are listed");
        }
        for (OCResolveConfiguration config : (Collection)configurations.first) {
            group.add((AnAction)new ConfigurationItem(psiFile, config));
        }
        OCResolveConfiguration selected = OCInclusionContextUtil.getOrCalculateParsedResolveLanguageAndConfiguration(psiFile).getConfiguration();
        ListPopup list = JBPopupFactory.getInstance().createActionGroupPopup("Available Resolve Contexts", (ActionGroup)group, context, false, false, false, null, 15, action -> ((ConfigurationItem)((Object)action)).getConfig() == selected);
        list.setAdText("File will be resolved in the selected context", 10);
        return list;
    }

    private static void scheduleReParse(PsiFile psiFile, OCResolveConfiguration config) {
        GuiUtils.invokeLaterIfNeeded(() -> OCInclusionContextUtil.setUserSelectedConfiguration(psiFile, config), (ModalityState)ModalityState.defaultModalityState());
    }

    public void scheduleUpdate() {
        UIUtil.invokeLaterIfNeeded(() -> {
            PsiFile psiFile;
            VirtualFile file2;
            if (this.myCurrentProgress != null) {
                this.myCurrentProgress.cancel();
            }
            if (this.isDisposed()) {
                return;
            }
            this.myCurrentFile = file2 = this.getSelectedFile();
            if (this.hasAccessToSymbols() && file2 != null && file2.isValid() && OCResolveContextPanel.isAppropriateFile(psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file2))) {
                this.myCurrentProgress = new EmptyProgressIndicator();
                this.updateUI(file2, null, false, false, null, true);
                this.scheduleReloadFileContexts(file2, psiFile, this.myCurrentProgress);
                return;
            }
            this.updateUI(null, null, false, false, null, false);
        });
    }

    private static boolean isAppropriateFile(PsiFile psiFile) {
        return psiFile instanceof OCConfigurationOwner;
    }

    private void scheduleReloadFileContexts(final @NotNull VirtualFile file2, final @NotNull PsiFile psiFile, final @NotNull ProgressIndicator globalProgress) {
        final SensitiveProgressWrapper progress = new SensitiveProgressWrapper(globalProgress);
        ReadTask task = new ReadTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void computeInReadAction(@NotNull ProgressIndicator indicator) {
                OCResolveLanguageAndConfiguration langAndConfig;
                if (OCResolveContextPanel.this.isDisposed() || OCResolveContextPanel.this.myProject.isDisposed()) {
                    return;
                }
                if (!psiFile.isValid() || !OCResolveContextPanel.this.hasAccessToSymbols()) {
                    OCResolveContextPanel.this.updateUI(file2, null, false, false, null, true);
                    return;
                }
                progress.checkCanceled();
                OCResolveContextPanel.this.isCalculatingContext = true;
                try {
                    langAndConfig = OCInclusionContextUtil.getOrCalculateParsedResolveLanguageAndConfiguration(psiFile);
                }
                finally {
                    OCResolveContextPanel.this.isCalculatingContext = false;
                }
                OCResolveConfiguration config = langAndConfig.getConfiguration();
                OCLanguageKind kind2 = langAndConfig.getLanguageKind();
                progress.checkCanceled();
                OCResolveContextPanel.this.updateUI(file2, config, false, false, kind2, true);
                Collection cs = (Collection)OCResolveContextPanel.getFileConfigurations((PsiFile)psiFile, (boolean)false, (ProgressIndicator)progress).first;
                progress.checkCanceled();
                if (cs.size() > 0 && !cs.contains(config)) {
                    OCResolveContextPanel.scheduleReParse(psiFile, (OCResolveConfiguration)ContainerUtil.getFirstItem((Collection)cs));
                } else {
                    OCResolveContextPanel.this.updateUI(file2, config, config != null, cs.size() > 1, kind2, false);
                }
            }

            @Override
            public void onCanceled(@NotNull ProgressIndicator indicator) {
                if (!globalProgress.isCanceled()) {
                    OCResolveContextPanel.this.scheduleReloadFileContexts(file2, psiFile, globalProgress);
                }
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().runReadAction(() -> task.computeInReadAction(globalProgress));
        } else {
            ProgressIndicatorUtils.scheduleWithWriteActionPriority(progress, task);
        }
    }

    private void updateUI(@Nullable VirtualFile file2, @Nullable OCResolveConfiguration config, boolean actionsEnabled, boolean hasMoreConfigs, @Nullable OCLanguageKind kind2, boolean isLoading) {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (file2 != null && !Comparing.equal((Object)this.getSelectedFile(), (Object)file2)) {
                return;
            }
            this.myActionEnabled = actionsEnabled;
            this.myHasList = actionsEnabled && hasMoreConfigs;
            Pair<String, String> titleWithDescription = OCResolveContextPanel.getTitleWithDescription(config, kind2, !this.hasAccessToSymbols(), isLoading);
            String title = (String)titleWithDescription.first;
            this.myComponent.setText(title);
            this.myComponent.setToolTipText((String)titleWithDescription.second);
            this.myComponent.setForeground(this.myActionEnabled ? UIUtil.getActiveTextColor() : UIUtil.getInactiveTextColor());
            if (this.myStatusBar != null) {
                this.myStatusBar.updateWidget(this.ID());
            }
            boolean haveTitle = title != null;
            this.myArrowsIcon.setVisible(haveTitle && !isLoading && this.myHasList);
            if (haveTitle && isLoading) {
                this.myRepoActivityIcon.resume();
            } else {
                this.myRepoActivityIcon.suspend();
            }
        });
    }

    private boolean hasAccessToSymbols() {
        return !DumbService.getInstance((Project)this.myProject).isDumb() && FileSymbolTablesCache.areSymbolsLoaded(this.myProject);
    }

    @NotNull
    private static Pair<String, String> getTitleWithDescription(@Nullable OCResolveConfiguration config, @Nullable OCLanguageKind kind2, boolean dumb, boolean isLoading) {
        String description;
        String title;
        if (dumb) {
            title = "Indexing...";
            description = ActionUtil.getUnavailableMessage((String)"Resolve context", (boolean)false);
        } else if (config == null) {
            if (isLoading) {
                title = "Loading...";
                description = "Loading resolve contexts...";
            } else {
                title = "<no context>";
                description = "No resolve context for current file";
            }
        } else {
            title = config.getDisplayName(true);
            description = "Current file is resolved in context of " + config.getDisplayName(false);
            if (kind2 != null) {
                description = description + " (" + kind2.getDisplayName() + ")";
            }
        }
        return Pair.create((Object)("Context: " + title), (Object)description);
    }

    @NotNull
    private static Pair<Collection<? extends OCResolveConfiguration>, Boolean> getFileConfigurations(@NotNull PsiFile psiFile, boolean sort, @Nullable ProgressIndicator progress) {
        boolean isDetermined = true;
        Collection<? extends OCResolveConfiguration> allConfigurations = OCInclusionContextUtil.getAllBuildConfigurationsForFile(psiFile, progress);
        if (allConfigurations.isEmpty()) {
            isDetermined = false;
            allConfigurations = OCWorkspaceManager.getWorkspace(psiFile.getProject()).getConfigurations();
        }
        if (!sort) {
            return new Pair(allConfigurations, (Object)isDetermined);
        }
        ArrayList<? extends OCResolveConfiguration> sorted = new ArrayList<OCResolveConfiguration>(allConfigurations);
        Collections.sort(sorted);
        return new Pair(sorted, (Object)isDetermined);
    }

    public static class ConfigurationItem
    extends AnAction {
        @NotNull
        private final PsiFile myFile;
        @NotNull
        private final OCResolveConfiguration myConfig;

        public ConfigurationItem(@NotNull PsiFile file2, @NotNull OCResolveConfiguration config) {
            super(config.getDisplayName(false));
            this.myFile = file2;
            this.myConfig = config;
        }

        public void actionPerformed(AnActionEvent e) {
            OCResolveContextPanel.scheduleReParse(this.myFile, this.myConfig);
        }

        @NotNull
        public OCResolveConfiguration getConfig() {
            return this.myConfig;
        }
    }
}

