/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.FilteredQuery;
import com.intellij.util.Query;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCTemplateParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.search.OCFunctionAncestorsQuery;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolAttribute;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCallableUtil {
    public static final String IMPLEMENTED_METHOD_TEMPLATE_NAME = "OC Implemented Method Body.m";
    public static final String OVERRIDDEN_METHOD_TEMPLATE_NAME = "OC Overridden Method Body.m";
    private static final String OVERRIDDEN_INIT_METHOD_TEMPLATE_NAME = "OC Overridden InitWith Method Body.m";
    private static final String OVERRIDDEN_IS_EQUAL_METHOD_TEMPLATE_NAME = "OC Overridden IsEqual Method Body.m";
    public static final String OVERRIDDEN_DESCRIPTION_TEMPLATE_NAME1 = "OC Overridden Description Body 1.m";
    public static final String OVERRIDDEN_DESCRIPTION_TEMPLATE_NAME2 = "OC Overridden Description Body 2.m";
    public static final String OVERRIDDEN_DESCRIPTION_TEMPLATE_NAME3 = "OC Overridden Description Body 3.m";
    public static final String OVERRIDDEN_COPY_TEMPLATE_NAME1 = "OC Overridden CopyWithZone Body 1.m";
    public static final String OVERRIDDEN_COPY_TEMPLATE_NAME2 = "OC Overridden CopyWithZone Body 2.m";
    public static final String OVERRIDDEN_COPY_TEMPLATE_NAME3 = "OC Overridden CopyWithZone Body 3.m";
    private static final String PROPERTY_GETTER_TEMPLATE_NAME = "OC Property Getter Body.m";
    private static final String PROPERTY_SETTER_TEMPLATE_NAME = "OC Property Setter Body.m";
    private static final String CPP_IMPLEMENTED_FUNCTION_TEMPLATE_NAME = "C++ Implemented Function Body.cc";
    private static final String CPP_OVERRIDDEN_FUNCTION_TEMPLATE_NAME = "C++ Overridden Function Body.cc";
    private static final String CONTAINING_CLASS_TEMPLATE_PROPERTY = "CONTAINING_CLASS";
    private static final String RETURN_TYPE_TEMPLATE_PROPERTY = "RETURN_TYPE";
    private static final String DEFAULT_RETURN_VALUE_TEMPLATE_PROPERTY = "DEFAULT_RETURN_VALUE";
    private static final String CALL_SUPER_TEMPLATE_PROPERTY = "CALL_SUPER";
    private static final String CUSTOM_CODE_TEMPLATE_PROPERTY = "CUSTOM_CODE";
    public static final String IVAR_IS_AVAILABLE_TEMPLATE_PROPERTY = "IVAR_IS_AVAILABLE";
    private static final String IVAR_TEMPLATE_PROPERTY = "IVAR";
    private static final String PARAM_TEMPLATE_PROPERTY = "PARAM";
    private static final String SETTER_SEMANTICS_TEMPLATE_PROPERTY = "SETTER_SEMANTICS";

    private OCCallableUtil() {
    }

    public static String methodText(@NotNull OCMethodSymbol baseMethod, String customCode, PsiElement context) {
        return OCCallableUtil.methodText(baseMethod, null, OCCallableUtil.methodSignature(baseMethod, context), customCode, context);
    }

    public static String methodFromTemplate(@NotNull OCMethodSymbol baseMethod, String customTemplate, PsiElement context, @Nullable Map<String, String> customProperties) {
        OCType returnType = baseMethod.getReturnType().resolve(baseMethod.getContainingOCFile());
        return OCCallableUtil.methodText(baseMethod, returnType, customTemplate, OCCallableUtil.methodSignature(baseMethod, context), "", context, customProperties);
    }

    public static String methodFromTemplate(@NotNull OCMethodSymbol baseMethod, String customTemplate, String customCode, PsiElement context) {
        return OCCallableUtil.methodText(baseMethod, customTemplate, OCCallableUtil.methodSignature(baseMethod, context), customCode, context);
    }

    public static String methodWithSignature(@NotNull OCType returnType, String signature, PsiElement context) {
        return OCCallableUtil.methodText(null, returnType, IMPLEMENTED_METHOD_TEMPLATE_NAME, signature, "", context, null);
    }

    public static String functionWithSignature(@NotNull OCType returnType, String signature, PsiElement context) {
        StringBuilder answer = new StringBuilder();
        answer.append(signature).append("{\n ");
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance(context.getProject());
        FileTemplate bodyTemplate = fileTemplateManager.getCodeTemplate(CPP_IMPLEMENTED_FUNCTION_TEMPLATE_NAME);
        if (bodyTemplate != null) {
            Properties templateProperties = new Properties(FileTemplateManager.getInstance(context.getProject()).getDefaultProperties());
            OCType resolved = returnType.resolve(new OCResolveContext(context));
            templateProperties.setProperty(RETURN_TYPE_TEMPLATE_PROPERTY, resolved.getBestNameInContext(context));
            templateProperties.setProperty(DEFAULT_RETURN_VALUE_TEMPLATE_PROPERTY, resolved.getDefaultValue(context));
            try {
                answer.append(bodyTemplate.getText(templateProperties));
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Unable to load template for file template '%s'!", fileTemplateManager.internalTemplateToSubject(CPP_IMPLEMENTED_FUNCTION_TEMPLATE_NAME)), e);
            }
        }
        answer.append("\n}\n");
        return answer.toString();
    }

    public static String methodWithSignature(@NotNull OCMethodSymbol baseMethod, String signature, String customCode, PsiElement context) {
        return OCCallableUtil.methodText(baseMethod, null, signature, customCode, context);
    }

    public static String methodText(@NotNull OCMethodSymbol baseMethod, String customTemplate, String signature, String customCode, PsiElement context) {
        OCType returnType = baseMethod.getReturnType().resolve(baseMethod.getContainingOCFile());
        return OCCallableUtil.methodText(baseMethod, returnType, customTemplate, signature, customCode, context, null);
    }

    public static String methodText(@NotNull String signature, @NotNull String body2, @NotNull PsiElement context) {
        StringBuilder answer = new StringBuilder();
        answer.append(signature);
        Project project2 = context.getProject();
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project2).getCustomSettings(OCCodeStyleSettings.class);
        if (settings != null && settings.SEMICOLON_AFTER_METHOD_SIGNATURE) {
            answer.append(";");
        }
        answer.append("{\n ");
        answer.append(body2);
        answer.append("\n}\n");
        return answer.toString();
    }

    private static String methodText(@Nullable OCMethodSymbol baseMethod, @NotNull OCType returnType, @Nullable String customTemplate, String signature, String customCode, @NotNull PsiElement context, @Nullable Map<String, String> customProperties) {
        StringBuilder answer = new StringBuilder();
        answer.append(signature);
        Project project2 = context.getProject();
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project2).getCustomSettings(OCCodeStyleSettings.class);
        if (settings != null && settings.SEMICOLON_AFTER_METHOD_SIGNATURE) {
            answer.append(";");
        }
        answer.append("{\n ");
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance(project2);
        OCPropertySymbol property = baseMethod != null ? baseMethod.getGeneratedFromProperty() : null;
        OCInstanceVariableSymbol ivar = property != null ? property.getAssociatedIvar() : null;
        OCClassDeclaration parentClass = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)context, OCClassDeclaration.class, (boolean)false);
        String templateName = property != null && ivar != null ? (baseMethod.isSetter() ? PROPERTY_SETTER_TEMPLATE_NAME : PROPERTY_GETTER_TEMPLATE_NAME) : (customTemplate != null && customTemplate != OVERRIDDEN_METHOD_TEMPLATE_NAME ? customTemplate : (baseMethod != null && OCElementUtil.startsWithWord(baseMethod.getName(), "init") ? OVERRIDDEN_INIT_METHOD_TEMPLATE_NAME : (baseMethod != null && baseMethod.getName().equals("isEqual:") ? OVERRIDDEN_IS_EQUAL_METHOD_TEMPLATE_NAME : (baseMethod != null && baseMethod.getName().equals("description") ? OVERRIDDEN_DESCRIPTION_TEMPLATE_NAME2 : (baseMethod != null && baseMethod.getName().equals("copyWithZone:") ? OVERRIDDEN_COPY_TEMPLATE_NAME2 : (customTemplate != null ? customTemplate : OVERRIDDEN_METHOD_TEMPLATE_NAME))))));
        FileTemplate bodyTemplate = fileTemplateManager.getCodeTemplate(templateName);
        if (bodyTemplate != null) {
            Properties templateProperties = new Properties(FileTemplateManager.getInstance(project2).getDefaultProperties());
            if (customProperties != null) {
                for (Map.Entry<String, String> entry : customProperties.entrySet()) {
                    templateProperties.setProperty(entry.getKey(), entry.getValue());
                }
            }
            templateProperties.setProperty(CONTAINING_CLASS_TEMPLATE_PROPERTY, parentClass != null ? parentClass.getName() : "");
            templateProperties.setProperty(RETURN_TYPE_TEMPLATE_PROPERTY, returnType.getBestNameInContext(context));
            templateProperties.setProperty(DEFAULT_RETURN_VALUE_TEMPLATE_PROPERTY, returnType.getDefaultValue(context));
            templateProperties.setProperty(CALL_SUPER_TEMPLATE_PROPERTY, OCCallableUtil.getCallSuperText(baseMethod, context));
            templateProperties.setProperty(CUSTOM_CODE_TEMPLATE_PROPERTY, customCode != null ? customCode : "");
            boolean arcEnabled = OCCompilerHelper.isArcEnabled(context.getContainingFile());
            if (property != null && ivar != null) {
                OCDeclaratorSymbol parameter;
                templateProperties.setProperty(IVAR_TEMPLATE_PROPERTY, ivar.getName());
                if (baseMethod.isSetter() && (parameter = baseMethod.getSelectors().get(0).getParameter()) != null) {
                    templateProperties.setProperty(PARAM_TEMPLATE_PROPERTY, OCNameSuggester.suggestUniqueName(parameter, context));
                }
                if (property.hasAttribute(OCPropertySymbol.PropertyAttribute.COPY)) {
                    templateProperties.setProperty(SETTER_SEMANTICS_TEMPLATE_PROPERTY, arcEnabled ? "copyArc" : "copy");
                } else if (property.hasAttribute(OCPropertySymbol.PropertyAttribute.RETAIN) && !arcEnabled) {
                    templateProperties.setProperty(SETTER_SEMANTICS_TEMPLATE_PROPERTY, "retain");
                } else {
                    templateProperties.setProperty(SETTER_SEMANTICS_TEMPLATE_PROPERTY, "assign");
                }
            }
            try {
                if (baseMethod == null || !baseMethod.getName().equals("dealloc") || !arcEnabled) {
                    answer.append(bodyTemplate.getText(templateProperties));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Unable to load template for file template '%s'!", fileTemplateManager.internalTemplateToSubject(templateName)), e);
            }
        }
        answer.append("\n}\n");
        return answer.toString();
    }

    @NotNull
    private static String fillFunctionBodyTemplate(@NotNull OCFunctionSymbol function, @Nullable OCFunctionSymbol overridingFunction, @NotNull PsiElement context) {
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance(function.getProject());
        String templateName = overridingFunction != null ? CPP_OVERRIDDEN_FUNCTION_TEMPLATE_NAME : CPP_IMPLEMENTED_FUNCTION_TEMPLATE_NAME;
        FileTemplate bodyTemplate = fileTemplateManager.getCodeTemplate(templateName);
        OCType returnType = function.getEffectiveResolvedType();
        if (function.isCppConstructor() || function.isCppDestructor()) {
            returnType = OCVoidType.instance();
        }
        if (bodyTemplate != null) {
            Properties templateProperties = new Properties(FileTemplateManager.getInstance(function.getProject()).getDefaultProperties());
            templateProperties.setProperty(RETURN_TYPE_TEMPLATE_PROPERTY, returnType.getBestNameInContext(context));
            templateProperties.setProperty(DEFAULT_RETURN_VALUE_TEMPLATE_PROPERTY, returnType.getDefaultValue(context));
            if (overridingFunction != null) {
                templateProperties.setProperty(CALL_SUPER_TEMPLATE_PROPERTY, overridingFunction.getVisibility() != OCVisibility.PRIVATE ? OCCallableUtil.getBaseCallText(function, overridingFunction) : "");
            }
            try {
                return bodyTemplate.getText(templateProperties);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Unable to load template for file template '%s'!", fileTemplateManager.internalTemplateToSubject(templateName)), e);
            }
        }
        return "";
    }

    private static String getAdHocParameterName(String methodName, boolean isFirstParameter) {
        if (methodName.startsWith("isEqual") && isFirstParameter) {
            return "other";
        }
        if (methodName.equals("encodeWithCoder:") || methodName.equals("initWithCoder:")) {
            return "coder";
        }
        return null;
    }

    private static String getCallSuperText(@Nullable OCMethodSymbol baseMethod, @NotNull PsiElement context) {
        if (baseMethod == null) {
            return "";
        }
        StringBuilder callSuper = new StringBuilder();
        callSuper.append("[super ");
        boolean first = true;
        for (OCMethodSymbol.SelectorPartSymbol part : baseMethod.getSelectors()) {
            if (!first) {
                callSuper.append(' ');
            }
            callSuper.append(part.getSelectorName()).append(' ');
            OCDeclaratorSymbol param = part.getParameter();
            if (param != null) {
                String parameterName = OCCallableUtil.getAdHocParameterName(baseMethod.getName(), first);
                if (parameterName != null) {
                    callSuper.append(parameterName);
                } else {
                    callSuper.append(OCNameSuggester.suggestUniqueName(param, context));
                }
            }
            first = false;
        }
        callSuper.append("]");
        return callSuper.toString();
    }

    @NotNull
    private static String getBaseCallText(@NotNull OCFunctionSymbol override, @NotNull OCFunctionSymbol baseToCall) {
        if (baseToCall.isCppConstructor() || baseToCall.isCppDestructor()) {
            return "";
        }
        return baseToCall.getParent().getName() + "::" + OCCallableUtil.getBaseCallExpression(override, baseToCall);
    }

    @NotNull
    private static String getBaseCallExpression(@NotNull OCFunctionSymbol override, @NotNull OCFunctionSymbol baseToCall) {
        OCDeclaratorSymbol param;
        OCType type2;
        StringBuilder callSuper = new StringBuilder();
        callSuper.append(baseToCall.getName()).append("(");
        boolean first = true;
        Iterator<OCDeclaratorSymbol> iterator = override.getParameterSymbols().iterator();
        while (iterator.hasNext() && !((type2 = (param = iterator.next()).getType()) instanceof OCEllipsisType) && !(type2 instanceof OCVoidType)) {
            if (!first) {
                callSuper.append(",");
            }
            callSuper.append(param.getName());
            first = false;
        }
        callSuper.append(")");
        return callSuper.toString();
    }

    @NotNull
    public static String methodSignature(OCMethodSymbol method2, PsiElement context) {
        StringBuilder answer = new StringBuilder();
        answer.append(method2.isStatic() ? (char)'+' : '-');
        answer.append('(');
        if (method2.getReturnType().isVoid() && method2.hasAttribute("ibaction")) {
            answer.append("IBAction");
        } else {
            answer.append(method2.getReturnType().getBestNameInContext(context, OCElementUtil.getReturnTypeText(method2)));
        }
        answer.append(')');
        boolean first = true;
        for (OCMethodSymbol.SelectorPartSymbol part : method2.getSelectors()) {
            if (!first) {
                answer.append(' ');
            }
            answer.append(part.getSelectorName());
            OCDeclaratorSymbol param = part.getParameter();
            if (param != null) {
                OCType type2 = param.getType();
                answer.append('(').append(type2.getBestNameInContext(context, OCElementUtil.getTypeTextWithModifiers(param))).append(')');
                String parameterName = OCCallableUtil.getAdHocParameterName(method2.getName(), first);
                if (parameterName != null) {
                    answer.append(parameterName);
                } else {
                    answer.append(OCNameSuggester.suggestUniqueName(param, context));
                }
            }
            first = false;
        }
        if (method2.isVararg()) {
            answer.append(",...");
        }
        return answer.toString();
    }

    @NotNull
    public static String functionSignature(@NotNull OCFunctionSymbol function, @NotNull String qualifier, @NotNull PsiElement context) {
        OCTypeElement trailingType;
        OCTemplateParameterList templateParameterList;
        StringBuilder answer = new StringBuilder();
        OCFunctionDeclaration funDefinition = function.locateFunctionDefinition();
        OCTemplateParameterList oCTemplateParameterList = templateParameterList = funDefinition != null ? funDefinition.getTemplateParameterList() : null;
        if (templateParameterList != null) {
            answer.append("template");
            answer.append(templateParameterList.getTextWithMacros());
            answer.append(' ');
        }
        if (function.isConstexpr()) {
            answer.append("constexpr ");
        }
        if (function.isVirtual()) {
            answer.append("virtual ");
        }
        if (function.isFriend()) {
            answer.append("friend ");
        }
        if (function.isStatic()) {
            answer.append("static ");
        }
        if (function.isExplicit()) {
            answer.append("explicit ");
        }
        if (!(function.isCppConstructor() || function.isCppDestructor() || function.isCppConversionOperator())) {
            answer.append(function.getEffectiveResolvedType().getBestNameInContext(context, OCElementUtil.getReturnTypeTextWithModifiers(function)));
            answer.append(' ');
        }
        answer.append(qualifier);
        answer.append(function.getName());
        answer.append('(');
        boolean isFirstParam = true;
        for (OCDeclaratorSymbol param : function.getParameterSymbols()) {
            if (!isFirstParam) {
                answer.append(", ");
            }
            answer.append(OCElementFactory.declarationText(param.getName(), param.getType(), OCElementUtil.getTypeTextWithModifiers(param), context));
            isFirstParam = false;
        }
        answer.append(')');
        function.getType().getCVQualifiers().appendCVQualifiers(answer);
        if (function.isOverride()) {
            answer.append(" override");
        }
        if (function.isFinal()) {
            answer.append(" final");
        }
        if (function.isPureVirtual()) {
            answer.append(" = 0");
        }
        if (function.isDefault()) {
            answer.append(" = default");
        }
        if (function.isDelete()) {
            answer.append(" = delete");
        }
        if (funDefinition != null && (trailingType = funDefinition.getTrailingReturnTypeElement()) != null) {
            answer.append(" -> ").append(trailingType.getType().resolve(context.getContainingFile()).getBestNameInContext(context, trailingType.getTextWithMacros()));
        }
        return answer.toString();
    }

    @NotNull
    public static String getFunctionParentQualifier(@NotNull OCFunctionSymbol function, @NotNull PsiElement context) {
        String parentName = "";
        OCSymbolWithQualifiedName functionParent = function.getParent();
        if (functionParent instanceof OCNamespaceSymbol) {
            boolean isCorrectScope = false;
            OCSymbolDeclarator parent = (OCSymbolDeclarator)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{OCStruct.class, OCCppNamespace.class});
            while (parent != null) {
                OCNamespaceSymbol parentSymbol = (OCNamespaceSymbol)parent.getSymbol();
                if (parentSymbol != null && (functionParent.isSameSymbol(parentSymbol) || parentSymbol instanceof OCStructSymbol && !((OCStructSymbol)parentSymbol).processAllBaseClasses((symbol, visibility) -> !functionParent.equals(symbol)))) {
                    isCorrectScope = true;
                }
                parent = (OCSymbolDeclarator)PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{OCStruct.class, OCCppNamespace.class});
            }
            if (!isCorrectScope) {
                if (functionParent instanceof OCStructSymbol) {
                    parentName = functionParent.getType().getBestNameInContext(context);
                    if (function.isFriend()) {
                        OCSymbolWithQualifiedName parentNamespace;
                        for (parentNamespace = functionParent.getParent(); parentNamespace != null && parentNamespace.getKind() != OCSymbolKind.NAMESPACE; parentNamespace = parentNamespace.getParent()) {
                        }
                        parentName = parentNamespace != null ? parentNamespace.getResolvedQualifiedName().getNameWithParent() : "";
                    }
                } else {
                    OCQualifiedName qualifiedName = functionParent.getResolvedQualifiedName();
                    parentName = qualifiedName != null ? qualifiedName.getCanonicalName(true) : functionParent.getName();
                }
            }
        }
        return parentName.isEmpty() ? parentName : parentName + "::";
    }

    @NotNull
    public static String defaultFunctionBody(@NotNull OCFunctionSymbol function, @Nullable OCFunctionSymbol baseToCall, @NotNull PsiElement context) {
        StringBuilder answer = new StringBuilder();
        if (function.isCppConstructor() && baseToCall != null) {
            answer.append(':');
            answer.append(OCCallableUtil.getBaseCallExpression(function, baseToCall));
        }
        answer.append("{\n");
        answer.append(OCCallableUtil.fillFunctionBodyTemplate(function, baseToCall, context));
        answer.append("\n}");
        return answer.toString();
    }

    public static String getOverridingFunctionName(OCFunctionSymbol member, OCSymbolWithQualifiedName parent) {
        String newName = parent != null && member.isCppConstructor() ? parent.getName() : (parent != null && member.isCppDestructor() ? "~" + parent.getName() : member.getName());
        return newName;
    }

    @NotNull
    public static OCFunctionSymbol createOverridingFunction(@NotNull OCFunctionSymbol base, @NotNull OCNamespaceSymbol newParent, @NotNull PsiElement context, @Nullable OCVisibility visibility, boolean insertOverride, boolean insertVirtual) {
        int newAttributes = base.getFunctionAttributes();
        int newProperties = base.getFunctionProperties();
        newProperties &= ~OCFunctionSymbol.Property.IS_PURE_VIRTUAL.getMask();
        newAttributes = insertVirtual && !base.isCppConstructor() ? (newAttributes |= OCSymbolAttribute.VIRTUAL.getMask()) : (newAttributes &= ~OCSymbolAttribute.VIRTUAL.getMask());
        newAttributes = insertOverride && !base.isCppConstructor() ? (newAttributes |= OCSymbolAttribute.OVERRIDE.getMask()) : (newAttributes &= ~OCSymbolAttribute.OVERRIDE.getMask());
        List<OCDeclaratorSymbol> oldParamSymbols = base.getParameterSymbols();
        ArrayList<OCDeclaratorSymbol> newParamSymbols = new ArrayList<OCDeclaratorSymbol>(oldParamSymbols.size());
        ArrayList<String> createdNames = new ArrayList<String>();
        for (OCDeclaratorSymbol param : oldParamSymbols) {
            Collection<String> suggestedNames;
            OCType type2 = param.getType();
            String paramName = param.isUnnamed() && !(type2 instanceof OCEllipsisType) && !(type2 instanceof OCVoidType) ? ((suggestedNames = OCNameSuggester.suggestForType(type2, context, createdNames)).isEmpty() ? "param" : suggestedNames.iterator().next()) : param.getName();
            createdNames.add(paramName);
            newParamSymbols.add(new OCDeclaratorSymbol(param, param.getSubstitution(), OCQualifiedName.with(param.getQualifier(), paramName), null, new OCResolveContext(context)));
        }
        return new OCFunctionSymbol(base.getProject(), null, 0x100000000L, newParent, OCQualifiedName.with(null, OCCallableUtil.getOverridingFunctionName(base, newParent)), base.getTemplateParameters(), base.getTemplateSpecialization(), newProperties, newAttributes, base.getAttributes(), base.getType(), newParamSymbols, base.getKind(), visibility);
    }

    @NotNull
    public static OCFunctionSymbol removeDeclarationSpecifiers(@NotNull OCFunctionSymbol base) {
        int newAttributes = base.getFunctionAttributes() & ~(OCSymbolAttribute.VIRTUAL.getMask() | OCSymbolAttribute.FRIEND.getMask() | OCSymbolAttribute.STATIC.getMask() | OCSymbolAttribute.EXPLICIT.getMask() | OCSymbolAttribute.FINAL.getMask() | OCSymbolAttribute.OVERRIDE.getMask() | OCSymbolAttribute.DEFAULT.getMask() | OCSymbolAttribute.DELETE.getMask());
        int newProperties = base.getFunctionProperties() & ~OCFunctionSymbol.Property.IS_PURE_VIRTUAL.getMask();
        return new OCFunctionSymbol(base.getProject(), base.getContainingFile(), base.getOffset(), base.getParent(), base.getQualifiedName(), base.getTemplateParameters(), base.getTemplateSpecialization(), newProperties, newAttributes, base.getAttributes(), base.getType(), base.getParameterSymbols(), base.getKind(), base.getVisibility());
    }

    @Nullable
    public static OCFunctionSymbol getDefaultBaseToCall(OCFunctionSymbol function) {
        return function.isCppDestructor() || function.isCppConstructor() && function.getType().hasNoParameters() ? null : (OCFunctionSymbol)new FilteredQuery((Query)new OCFunctionAncestorsQuery(function, false, false, true), symbol -> !symbol.isPureVirtual()).findFirst();
    }

    @NotNull
    public static PsiElement getCorrectContextToCalculateNames(@NotNull PsiElement container) {
        PsiElement psi;
        ASTNode lbraceNode;
        if ((container instanceof OCCppNamespace || container instanceof OCStructLike) && (lbraceNode = container.getNode().findChildByType((IElementType)OCTokenTypes.LBRACE)) != null && (psi = lbraceNode.getPsi()) != null) {
            return psi;
        }
        return container;
    }

    public static boolean isParameterNameEmpty(@NotNull String paramName) {
        return paramName.isEmpty() || paramName.equals("<unnamed>");
    }
}

