/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.ide.util.EditorHelper;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.documentation.doxygen.api.DoxygenFacade;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCatchSection;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCClassDeclarationBase;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCConstructorInitializationList;
import com.jetbrains.cidr.lang.psi.OCCppNewExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCLambdaIntroducer;
import com.jetbrains.cidr.lang.psi.OCLocalScopeable;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCNoexceptSpecifier;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCPostfixExpression;
import com.jetbrains.cidr.lang.psi.OCPrefixExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStatementExpression;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCTemplateParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCArgumentDepLookupAccumulator;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCLValueUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCodeInsightUtil {
    private static Map<OCElementType, OCElementType> oppositeOperators = ContainerUtil.newHashMap((Pair)new Pair((Object)OCTokenTypes.EQEQ, (Object)OCTokenTypes.EXCLEQ), (Pair[])new Pair[]{new Pair((Object)OCTokenTypes.EXCLEQ, (Object)OCTokenTypes.EQEQ), new Pair((Object)OCTokenTypes.LT, (Object)OCTokenTypes.GTEQ), new Pair((Object)OCTokenTypes.LTEQ, (Object)OCTokenTypes.GT), new Pair((Object)OCTokenTypes.GT, (Object)OCTokenTypes.LTEQ), new Pair((Object)OCTokenTypes.GTEQ, (Object)OCTokenTypes.LT)});
    private static Map<OCElementType, OCElementType> flippedOperators = ContainerUtil.newHashMap((Pair)new Pair((Object)OCTokenTypes.ANDAND, (Object)OCTokenTypes.ANDAND), (Pair[])new Pair[]{new Pair((Object)OCTokenTypes.OROR, (Object)OCTokenTypes.OROR), new Pair((Object)OCTokenTypes.EQEQ, (Object)OCTokenTypes.EQEQ), new Pair((Object)OCTokenTypes.EXCLEQ, (Object)OCTokenTypes.EXCLEQ), new Pair((Object)OCTokenTypes.GTEQ, (Object)OCTokenTypes.LTEQ), new Pair((Object)OCTokenTypes.LTEQ, (Object)OCTokenTypes.GTEQ), new Pair((Object)OCTokenTypes.GT, (Object)OCTokenTypes.LT), new Pair((Object)OCTokenTypes.LT, (Object)OCTokenTypes.GT)});

    private OCCodeInsightUtil() {
    }

    public static boolean isInPlainOldC(@Nullable PsiElement element) {
        if (element != null && element.isValid() && element.getContainingFile() instanceof OCFile) {
            return !((OCFile)element.getContainingFile()).isCpp();
        }
        return false;
    }

    public static boolean isInObjC(@Nullable PsiElement element) {
        if (element != null && element.isValid() && element.getContainingFile() instanceof OCFile) {
            return ((OCFile)element.getContainingFile()).getKind().isObjC();
        }
        return false;
    }

    public static boolean isInPlainOldC(@Nullable PsiFile file2, @Nullable OCInclusionContext context) {
        if (context != null) {
            return !context.getLanguageKind().isCpp();
        }
        if (file2 != null) {
            return OCCodeInsightUtil.isInPlainOldC((PsiElement)file2);
        }
        return true;
    }

    @Contract(value="null->false")
    public static boolean isValid(@Nullable PsiElement element) {
        if (!OCSearchScope.isInProjectSources(element)) {
            return false;
        }
        OCMacroRange rangeInMacroCall = OCElementUtil.getRangeInMacroCall(element);
        if (rangeInMacroCall == null) {
            return true;
        }
        PsiElement prevLeaf = PsiTreeUtil.prevLeaf((PsiElement)element);
        PsiElement nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)element);
        PsiElement firstChild = PsiTreeUtil.firstChild((PsiElement)element);
        if (!(firstChild instanceof OCMacroForeignLeafElement)) {
            return false;
        }
        String macroName = ((OCMacroForeignLeafElement)firstChild).getMacroName();
        if (prevLeaf instanceof PsiErrorElement || nextLeaf instanceof PsiErrorElement) {
            return false;
        }
        if (prevLeaf instanceof OCMacroForeignLeafElement && Comparing.equal((String)((OCMacroForeignLeafElement)prevLeaf).getMacroName(), (String)macroName)) {
            return false;
        }
        return !(nextLeaf instanceof OCMacroForeignLeafElement) || !Comparing.equal((String)((OCMacroForeignLeafElement)nextLeaf).getMacroName(), (String)macroName);
    }

    @Nullable
    public static OCClassSymbol getClassInFile(OCFile file2) {
        final String fileName = FileUtil.getNameWithoutExtension((String)file2.getName());
        final OCClassSymbol[] result2 = new OCClassSymbol[]{null};
        file2.accept(new OCRecursiveVisitor(){

            @Override
            public void visitClassDeclaration(OCClassDeclaration dcl) {
                if (result2[0] == null || Comparing.equal((String)dcl.getName(), (String)fileName) && (!Comparing.equal((String)result2[0].getName(), (String)fileName) || dcl.getCategory() == null)) {
                    result2[0] = dcl.getSymbol();
                }
            }
        });
        return result2[0];
    }

    @Nullable
    public static OCExpression findExpressionAtRange(PsiFile file2, int startOffset, int endOffset) {
        return OCCodeInsightUtil.findElementAtRange(file2, startOffset, endOffset, OCExpression.class, true);
    }

    @Nullable
    public static <E extends PsiElement> E findElementAtRange(PsiFile file2, TextRange range, Class<E> elementClass, boolean requireExactRange) {
        return OCCodeInsightUtil.findElementAtRange(file2, range.getStartOffset(), range.getEndOffset(), elementClass, requireExactRange);
    }

    @Nullable
    public static <E extends PsiElement> E findElementAtRange(PsiFile file2, int startOffset, int endOffset, Class<E> elementClass, boolean requireExactRange) {
        PsiElement nameIdentifier;
        TextRange nodeRange;
        PsiElement parent;
        PsiElement node = file2.findElementAt(startOffset);
        while (node != null) {
            TextRange range = node.getTextRange();
            if (range == null) {
                return null;
            }
            if (range.containsRange(startOffset, endOffset)) break;
            if (node instanceof OCMacroCall) {
                if ((node = ((OCMacroCall)node).getExpansionExpression()) == null || range.getStartOffset() != startOffset) continue;
                startOffset = node.getTextRange().getStartOffset();
                continue;
            }
            node = node.getParent();
        }
        if ((parent = PsiTreeUtil.getNonStrictParentOfType((PsiElement)node, (Class[])new Class[]{elementClass, OCMacroCall.class})) != null) {
            node = parent;
        }
        TextRange textRange = nodeRange = node != null ? node.getTextRange() : null;
        if (node instanceof OCMacroCall) {
            node = ((OCMacroCall)node).getExpansionExpression();
        }
        if (node instanceof OCMacroCallArgument && node.getChildren().length >= 1) {
            node = node.getChildren()[0];
        }
        if (elementClass.equals(OCExpression.class) && node instanceof OCExpressionStatement) {
            node = ((OCExpressionStatement)node).getExpression();
            nodeRange = node.getTextRange();
        }
        if (elementClass.equals(OCDeclarator.class) && node instanceof OCDeclarator && (nameIdentifier = ((OCDeclarator)node).getNameIdentifier()) != null && nameIdentifier.getTextRange().equalsToRange(startOffset, endOffset)) {
            requireExactRange = false;
        }
        if (requireExactRange && nodeRange != null && !nodeRange.equalsToRange(startOffset, endOffset)) {
            return null;
        }
        return (E)(elementClass.isInstance(node) ? node : null);
    }

    @Nullable
    public static PsiElement[] findStatementsAtRange(PsiFile file2, int startOffset, int endOffset, boolean requireExactRange) {
        PsiElement nextSibling;
        PsiElement lastItem;
        PsiElement element1 = file2.findElementAt(startOffset);
        PsiElement element2 = file2.findElementAt(endOffset - 1);
        if (element1 instanceof PsiWhiteSpace) {
            startOffset = element1.getTextRange().getEndOffset();
            element1 = file2.findElementAt(startOffset);
        }
        if (element2 instanceof PsiWhiteSpace) {
            endOffset = element2.getTextRange().getStartOffset();
            element2 = file2.findElementAt(endOffset - 1);
        }
        if (OCElementUtil.getElementType(element2) == OCTokenTypes.EOL_COMMENT && element1 != element2) {
            element2 = element2.getNextSibling();
            endOffset = element2.getTextRange().getEndOffset();
        }
        if (element1 == null || element2 == null) {
            return null;
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        if (parent == null) {
            return null;
        }
        while (!(parent instanceof OCBlockStatement) && !(parent instanceof OCCodeFragment)) {
            if (parent instanceof OCStatement) {
                parent = parent.getParent();
                break;
            }
            if (parent == null || parent instanceof OCFile) {
                return null;
            }
            parent = parent.getParent();
        }
        if (!parent.equals(element1)) {
            while (!parent.equals(element1.getParent())) {
                element1 = element1.getParent();
            }
        }
        if (requireExactRange && startOffset != element1.getTextRange().getStartOffset()) {
            return null;
        }
        if (!parent.equals(element2)) {
            while (!parent.equals(element2.getParent())) {
                element2 = element2.getParent();
            }
        }
        if (requireExactRange && endOffset != element2.getTextRange().getEndOffset() && (endOffset + 1 != element2.getTextRange().getEndOffset() || file2.getText().charAt(endOffset) != ';')) {
            return null;
        }
        if (parent instanceof OCBlockStatement && (requireExactRange ? parent.getFirstChild() == element1 && parent.getLastChild() == element2 : parent.getFirstChild() == element1 || parent.getLastChild() == element2)) {
            PsiElement[] psiElementArray;
            if (parent.getParent() instanceof OCCallable) {
                psiElementArray = null;
            } else {
                PsiElement[] psiElementArray2 = new PsiElement[1];
                psiElementArray = psiElementArray2;
                psiElementArray2[0] = parent;
            }
            return psiElementArray;
        }
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        if (element2 instanceof OCMacroCall) {
            PsiElement nextSibling2 = element2.getNextSibling();
            element2 = nextSibling2 != null ? nextSibling2 : element2;
        }
        boolean flag = false;
        for (PsiElement child : OCElementUtil.getAllChildren(parent)) {
            if (child.equals(element1)) {
                flag = true;
            }
            if (flag && !(child instanceof OCMacroCall)) {
                array.add(child);
            }
            if (!child.equals(element2)) continue;
            break;
        }
        if ((lastItem = (PsiElement)ContainerUtil.getLastItem(array)) instanceof OCDirective && (nextSibling = lastItem.getNextSibling()) != null && OCElementUtil.isWhitespace(nextSibling)) {
            array.add(nextSibling);
        }
        for (PsiElement element : array) {
            if (element instanceof OCStatement || !OCElementUtil.isElementSignificant(element)) continue;
            return null;
        }
        return PsiUtilCore.toPsiElementArray(array);
    }

    public static <E extends PsiElement> List<E> findElementOccurrences(@Nullable PsiElement scope, @NotNull E element) {
        ArrayList<E> answer = new ArrayList<E>();
        if (scope == null || !PsiTreeUtil.isAncestor((PsiElement)scope, element, (boolean)false)) {
            answer.add(element);
        }
        if (element instanceof OCExpression && OCElementUtil.getRangeInMacroCall(element) == null) {
            element = OCParenthesesUtils.diveIntoParentheses((OCExpression)element);
        }
        if (scope != null) {
            OCCodeInsightUtil.addOccurrencesIn(element, OCElementUtil.getElementType(element), scope, answer);
        }
        return answer;
    }

    private static <E extends PsiElement> void addOccurrencesIn(E element, IElementType elementType, PsiElement scope, List<E> answer) {
        if (OCElementUtil.getElementType(scope) == elementType && OCElementUtil.areElementsEquivalent(element, scope, false)) {
            if (scope instanceof OCExpression) {
                scope = OCParenthesesUtils.topmostParenthesized((OCExpression)scope);
            }
            answer.add(scope);
        } else {
            for (PsiElement c : scope.getChildren()) {
                OCCodeInsightUtil.addOccurrencesIn(element, elementType, c, answer);
            }
        }
    }

    public static boolean isLValue(OCExpression expr) {
        return OCLValueUtil.isLValue(expr);
    }

    public static boolean isAssignmentLHS(OCExpression expr) {
        return OCLValueUtil.isAssignmentLHS(expr);
    }

    public static boolean hasSideEffects(@NotNull OCElement element) {
        final Ref result2 = Ref.create((Object)false);
        element.accept(new OCRecursiveVisitor(){

            @Override
            public void visitPrefixExpression(OCPrefixExpression expression2) {
                if (expression2.getOperationSign() == OCTokenTypes.PLUSPLUS || expression2.getOperationSign() == OCTokenTypes.MINUSMINUS) {
                    result2.set((Object)true);
                } else {
                    super.visitPrefixExpression(expression2);
                }
            }

            @Override
            public void visitPostfixExpression(OCPostfixExpression expression2) {
                if (expression2.getOperationSign() == OCTokenTypes.PLUSPLUS || expression2.getOperationSign() == OCTokenTypes.MINUSMINUS) {
                    result2.set((Object)true);
                } else {
                    super.visitPostfixExpression(expression2);
                }
            }

            @Override
            public void visitAssignmentExpression(OCAssignmentExpression expression2) {
                result2.set((Object)true);
            }

            @Override
            public void visitCallExpression(OCCallExpression expression2) {
                result2.set((Object)true);
            }

            @Override
            public void visitSendMessageExpression(OCSendMessageExpression expression2) {
                result2.set((Object)true);
            }

            @Override
            public void visitBlockExpression(OCBlockExpression blockExpression) {
                result2.set((Object)true);
            }

            @Override
            public void visitLambdaExpression(OCLambdaExpression lambdaExpression) {
                result2.set((Object)true);
            }

            @Override
            public void visitStatementExpression(OCStatementExpression statementExpression) {
                result2.set((Object)true);
            }

            @Override
            public void visitCppNewExpression(OCCppNewExpression expression2) {
                result2.set((Object)true);
            }
        });
        return (Boolean)result2.get();
    }

    public static <E extends PsiElement> void collectElements(PsiFile file2, Editor editor, int offset, Class<E> elementClass, List<? super E> elements) {
        Document document = editor.getDocument();
        CharSequence text = document.getCharsSequence();
        int correctedOffset = offset;
        int textLength = document.getTextLength();
        if (offset >= textLength) {
            correctedOffset = textLength - 1;
        } else if (!Character.isJavaIdentifierPart(text.charAt(offset))) {
            --correctedOffset;
        }
        if (correctedOffset < 0) {
            correctedOffset = offset;
        } else if (!Character.isJavaIdentifierPart(text.charAt(correctedOffset))) {
            if (text.charAt(correctedOffset) == ';') {
                --correctedOffset;
            }
            if (text.charAt(correctedOffset) != ')') {
                correctedOffset = offset;
            }
        }
        PsiElement elementAtCaret = file2.findElementAt(correctedOffset);
        PsiElement context = OCCodeInsightUtil.getElementOrMacroCall(elementAtCaret, elementClass);
        while (context != null) {
            PsiElement element;
            if (!elementClass.isInstance(context)) {
                if (!(context instanceof OCMacroCall)) break;
                if (elementClass.equals(OCExpression.class) && (element = ((OCMacroCall)context).getExpansionExpression()) != null) {
                    elements.add(element);
                }
                context = OCCodeInsightUtil.getElementOrMacroCall(context, elementClass);
                continue;
            }
            element = context;
            if (!(elements.contains(element) || element instanceof OCParenthesizedExpression || element instanceof OCAssignmentExpression || element instanceof OCExpression && ((OCExpression)element).getResolvedType().isVoid() || element instanceof OCReferenceExpression && ((OCReferenceExpression)element).getResolvedType() instanceof OCObjectType)) {
                elements.add(element);
            }
            context = OCCodeInsightUtil.getElementOrMacroCall(context, elementClass);
        }
    }

    @Nullable
    private static <E extends PsiElement> PsiElement getElementOrMacroCall(PsiElement context, Class<E> elementClass) {
        return PsiTreeUtil.getContextOfType((PsiElement)context, (Class[])new Class[]{elementClass, OCMacroCall.class});
    }

    public static boolean isUniqueInScope(@Nullable OCSymbolKind symbolKind, String name, @Nullable PsiElement scope, @NotNull Project project2) {
        return OCCodeInsightUtil.resolveNameInScope(symbolKind, name, null, scope, project2) == null;
    }

    public static OCSymbol resolveNameInScope(final @Nullable OCSymbolKind symbolKind, final String name, final @Nullable String categoryName, @Nullable PsiElement scope, @NotNull Project project2) {
        CommonProcessors.FindFirstProcessor<OCSymbol> processor2 = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                if (symbol.isSynthetic()) {
                    return false;
                }
                if (categoryName != null && symbol instanceof OCClassSymbol && !categoryName.equals(((OCClassSymbol)symbol).getCategoryName())) {
                    return false;
                }
                return symbolKind == null || OCResolveUtil.isDuplicate(symbolKind, symbol.getKind());
            }
        };
        if (scope == null) {
            OCGlobalProjectSymbolsCache.processTopLevelSymbols(project2, (Processor<OCSymbol>)processor2, name);
        } else {
            OCResolveUtil.processSymbols(name, scope, (Processor<OCSymbol>)processor2);
        }
        if (processor2.isFound()) {
            return (OCSymbol)processor2.getFoundValue();
        }
        OCBlockStatement block = (OCBlockStatement)PsiTreeUtil.getParentOfType((PsiElement)scope, OCBlockStatement.class, (boolean)false, (Class[])new Class[]{OCBlockExpression.class, OCLambdaExpression.class});
        if (block == null) {
            return null;
        }
        try {
            block.accept(new OCVisitor(){

                @Override
                public void visitOCElement(OCElement elem) {
                    elem.acceptChildren(this);
                }

                @Override
                public void visitDeclarator(OCDeclarator declarator) {
                    if (name.equals(declarator.getName())) {
                        throw new CancelException(declarator);
                    }
                }
            });
        }
        catch (CancelException e) {
            return e.getDeclarator().getSymbol();
        }
        return null;
    }

    public static boolean showCallableInEditorAndSelectBody(final @NotNull PsiFile file2, @NotNull Segment segment, final @NotNull Condition<OCBlockStatement> condition2) {
        class MyVisitor
        extends OCRecursiveVisitor {
            public boolean found;
            private final TextRange myRange;

            public MyVisitor(TextRange range) {
                super(range);
                this.found = false;
                this.myRange = range;
            }

            @Override
            public void visitElement(PsiElement element) {
                if (!this.found) {
                    OCBlockStatement body2;
                    if (!this.myRange.intersectsStrict(element.getTextRange())) {
                        return;
                    }
                    OCCallable callable = (OCCallable)PsiTreeUtil.getContextOfType((PsiElement)element, (boolean)false, (Class[])new Class[]{OCCallable.class});
                    if (callable != null && (body2 = callable.getBody()) != null && condition2.value((Object)body2)) {
                        this.found = true;
                        Editor editor = EditorHelper.openInEditor((PsiElement)file2);
                        if (editor != null) {
                            OCCodeInsightUtil.selectBody(editor, body2);
                        }
                    }
                }
                super.visitElement(element);
            }
        }
        MyVisitor visitor = new MyVisitor(TextRange.create((Segment)segment));
        file2.accept((PsiElementVisitor)visitor);
        return visitor.found;
    }

    public static void selectBody(Editor editor, OCBlockStatement body2) {
        if (body2 == null) {
            return;
        }
        ASTNode firstNode = body2.getNode().getFirstChildNode().getTreeNext();
        ASTNode lastNode = body2.getNode().getLastChildNode().getTreePrev();
        while (OCTokenTypes.WHITESPACES.contains(firstNode.getElementType())) {
            firstNode = firstNode.getTreeNext();
        }
        while (OCTokenTypes.WHITESPACES.contains(lastNode.getElementType())) {
            lastNode = lastNode.getTreePrev();
        }
        if (firstNode != body2.getNode().getLastChildNode()) {
            OCCodeInsightUtil.selectRange(editor, firstNode.getStartOffset(), lastNode.getTextRange().getEndOffset());
        } else {
            OCCodeInsightUtil.selectRange(editor, body2.getTextOffset() + 1, body2.getTextOffset() + 1);
        }
    }

    public static void selectElement(PsiElement element) {
        if (element == null) {
            return;
        }
        Editor editor = EditorHelper.openInEditor(element);
        if (editor != null) {
            OCCodeInsightUtil.selectRange(editor, element.getTextRange().getStartOffset(), element.getTextRange().getEndOffset());
        }
    }

    public static void selectRange(Editor editor, int startOffset, int endOffset) {
        editor.getCaretModel().moveToOffset(startOffset);
        editor.getSelectionModel().setSelection(startOffset, endOffset);
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
    }

    public static String getClassNameWithCategory(String className, String categoryName) {
        if (categoryName == null) {
            return className;
        }
        StringBuilder builder = new StringBuilder(className.length() + categoryName.length() + 3);
        builder.append(className).append(" + ").append(categoryName.isEmpty() ? "()" : categoryName);
        return builder.toString();
    }

    @Nullable
    public static OCClassDeclaration getPrivateCategory(OCClassDeclarationBase declaration2) {
        for (PsiElement child : declaration2.getContainingFile().getChildren()) {
            if (!(child instanceof OCClassDeclaration)) continue;
            OCClassDeclaration category = (OCClassDeclaration)child;
            if (!declaration2.getName().equals(category.getName()) || !"".equals(category.getCategory())) continue;
            return category;
        }
        return null;
    }

    @NotNull
    public static Pair<MemberBeginEndSearchResult, OCType> getReturnTypeOfBeginEndPair(OCExpression expr, @NotNull OCStructType structType, @NotNull OCFile file2) {
        OCResolveContext context = new OCResolveContext(file2);
        CVQualifiers cvQualifiers = OCCodeInsightUtil.getCVQualifiers(expr, structType);
        OCType leftType = structType.cloneWithAddedCVQualifiers(cvQualifiers, file2.getProject());
        Collection<OCSymbol> beginSymbols = structType.collectMethods("begin", context);
        OCSymbol beginSymbol = OCResolveOverloadsUtil.resolveOverloads(beginSymbols, new OCArgumentsList(Collections.emptyList(), null), leftType, null, null, true, true, true, true, false, context);
        Collection<OCSymbol> endSymbols = structType.collectMethods("end", context);
        OCSymbol endSymbol = OCResolveOverloadsUtil.resolveOverloads(endSymbols, new OCArgumentsList(Collections.emptyList(), null), leftType, null, null, true, true, true, true, false, context);
        if (beginSymbol == null && endSymbol == null) {
            return Pair.create((Object)((Object)MemberBeginEndSearchResult.NONE), null);
        }
        if (beginSymbol == null || endSymbol == null) {
            return Pair.create((Object)((Object)MemberBeginEndSearchResult.INVALID), null);
        }
        assert (beginSymbol instanceof OCFunctionSymbol);
        OCType beginReturnType = beginSymbol.getEffectiveType().resolve(file2);
        assert (endSymbol instanceof OCFunctionSymbol);
        OCType endReturnType = beginSymbol.getEffectiveType().resolve(file2);
        if (endReturnType.equals((Object)beginReturnType, file2)) {
            return Pair.create((Object)((Object)MemberBeginEndSearchResult.OK), (Object)beginReturnType);
        }
        return Pair.create((Object)((Object)MemberBeginEndSearchResult.NONE), null);
    }

    public static boolean isCodeInsightAvailable(long fileLength) {
        return fileLength >= 0L && fileLength <= (long)OCCodeInsightUtil.getMaxFileLength();
    }

    public static int getMaxFileLength() {
        return OCCodeInsightUtil.getMaxFileLengthRegistryKey().asInteger();
    }

    public static void setMaxFileLength(int newValue) {
        if (newValue > 0) {
            OCCodeInsightUtil.getMaxFileLengthRegistryKey().setValue(newValue);
        }
    }

    public static void resetMaxFileLength() {
        OCCodeInsightUtil.getMaxFileLengthRegistryKey().resetToDefault();
    }

    @NotNull
    private static RegistryValue getMaxFileLengthRegistryKey() {
        return Registry.get((String)"cidr.max.intellisense.file.length");
    }

    public static Pair<List<PsiElement>, OCSymbolKind> getScopeAndKind(PsiElement element) {
        OCElement scopeElement;
        OCSymbolKind kind2 = null;
        List<Object> scope = null;
        if (element.getParent().getParent() instanceof OCTemplateParameterList) {
            kind2 = OCSymbolKind.TEMPLATE_VALUE_PARAMETER;
            scopeElement = null;
        } else {
            scopeElement = (OCElement)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCLocalScopeable.class, OCEnum.class, OCTemplateParameterList.class, OCLambdaIntroducer.class});
            if (scopeElement instanceof OCEnum && !((OCEnum)scopeElement).isEnumClass()) {
                kind2 = OCSymbolKind.ENUM_CONST;
                scopeElement = (OCElement)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCLocalScopeable.class});
            } else if (scopeElement instanceof OCStructLike) {
                kind2 = element instanceof OCFunctionDefinition ? (((OCFunctionDefinition)element).getBody() != null ? OCSymbolKind.FUNCTION_DECLARATION : OCSymbolKind.FUNCTION_PREDECLARATION) : OCSymbolKind.STRUCT_FIELD;
            } else if (scopeElement instanceof OCTemplateParameterList) {
                kind2 = OCSymbolKind.TEMPLATE_TYPE_PARAMETER;
                scopeElement = (OCElement)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCDeclaration.class});
                if (scopeElement != null) {
                    scope = new ArrayList();
                    scope.add(scopeElement);
                    scope.addAll(DoxygenFacade.getCommentScope(scopeElement));
                }
            } else if (scopeElement instanceof OCParameterList) {
                PsiElement parent = scopeElement.getContext();
                if (parent instanceof OCCatchSection) {
                    kind2 = OCSymbolKind.CATCH_EXCEPTION_VARIABLE;
                    scopeElement = ((OCCatchSection)parent).getBody();
                } else {
                    kind2 = OCSymbolKind.PARAMETER;
                    PsiElement callable = PsiTreeUtil.getContextOfType((PsiElement)scopeElement, (Class[])new Class[]{OCCallable.class, OCParameterList.class, OCMethodSelectorPart.class, OCDeclarator.class, OCTypeElement.class});
                    if (callable instanceof OCDeclarator && callable.getParent() instanceof OCCallable) {
                        callable = callable.getParent();
                    }
                    if (callable instanceof OCCallable) {
                        scope = new ArrayList();
                        if (callable instanceof OCFunctionDefinition && (PsiTreeUtil.getChildOfType((PsiElement)((OCFunctionDefinition)callable).getDeclarator(), OCConstructorInitializationList.class) != null || PsiTreeUtil.getChildOfType((PsiElement)callable, OCCatchSection.class) != null)) {
                            scope.add(callable);
                        } else {
                            OCBlockStatement body2 = ((OCCallable)callable).getBody();
                            OCNoexceptSpecifier noexceptSpecifier = ((OCCallable)callable).getNoexceptSpecifier();
                            OCTypeElement typeElement = callable instanceof OCFunctionDeclaration ? ((OCFunctionDeclaration)callable).getTrailingReturnTypeElement() : ((OCCallable)callable).getReturnTypeElement();
                            scope.add(body2 != null ? body2 : scopeElement);
                            if (noexceptSpecifier != null) {
                                scope.add(noexceptSpecifier);
                            }
                            if (typeElement != null) {
                                scope.add(typeElement);
                            }
                        }
                        List<PsiComment> comments = DoxygenFacade.getCommentScope(callable);
                        scope.addAll(comments);
                    }
                }
            } else if (scopeElement instanceof OCMethod) {
                scope = new ArrayList();
                kind2 = OCSymbolKind.PARAMETER;
                OCBlockStatement blockStatement = ((OCMethod)scopeElement).getBody();
                if (blockStatement != null) {
                    scope.add(blockStatement);
                }
                List<PsiComment> comments = DoxygenFacade.getCommentScope(scopeElement);
                scope.addAll(comments);
            } else if (scopeElement instanceof OCLambdaIntroducer) {
                scopeElement = ((OCLambdaExpression)scopeElement.getParent()).getBody();
            }
        }
        if (scope == null) {
            scope = scopeElement != null ? Collections.singletonList(scopeElement) : Collections.emptyList();
        }
        return Pair.create(scope, (Object)((Object)kind2));
    }

    public static boolean isNonStaticFieldAccess(@NotNull OCDeclaratorSymbol symbol, @NotNull OCStructSymbol parent, OCExpression expression2) {
        return !symbol.isFriendOrStatic() && !symbol.isMutable() && OCCodeInsightUtil.isMemberAccess(symbol, parent, expression2);
    }

    public static boolean isMemberAccess(@NotNull OCSymbolWithQualifiedName symbol, @NotNull OCStructSymbol parent, OCExpression expression2) {
        if (!(symbol instanceof OCFunctionSymbol) && symbol.getKind() != OCSymbolKind.STRUCT_FIELD) {
            return false;
        }
        OCSymbolWithQualifiedName memberParent = symbol.getResolvedOwner();
        if (!(memberParent instanceof OCStructSymbol) || !((OCStructSymbol)memberParent).isAncestor(parent)) {
            return false;
        }
        return expression2 instanceof OCReferenceExpression || expression2 instanceof OCQualifiedExpression && ((OCQualifiedExpression)expression2).getQualifier() instanceof OCReferenceExpression && ((OCReferenceExpression)((OCQualifiedExpression)expression2).getQualifier()).isCppThis();
    }

    @Nullable
    public static CVQualifiers getOuterFunctionCVQualifiers(@NotNull OCDeclaratorSymbol symbol, OCExpression expression2, @Nullable Ref<OCFunctionSymbol> functionSymbolRef) {
        OCSymbolWithQualifiedName parent;
        OCFunctionSymbol functionSymbol;
        OCFunctionDefinition function = (OCFunctionDefinition)PsiTreeUtil.getParentOfType((PsiElement)expression2, OCFunctionDefinition.class);
        OCFunctionSymbol oCFunctionSymbol = functionSymbol = function != null ? function.getSymbol() : null;
        if (functionSymbolRef != null) {
            functionSymbolRef.set((Object)functionSymbol);
        }
        if (functionSymbol != null && (parent = functionSymbol.getResolvedOwner()) instanceof OCStructSymbol && OCCodeInsightUtil.isNonStaticFieldAccess(symbol, (OCStructSymbol)parent, expression2)) {
            return functionSymbol.getType().getCVQualifiers();
        }
        return null;
    }

    @NotNull
    public static CVQualifiers getCVQualifiers(OCExpression expression2, OCType type2) {
        boolean considerOuterFunction = type2 instanceof OCStructType;
        CVQualifiers modifiers = type2.getTerminalType().getCVQualifiers();
        if (considerOuterFunction && expression2 instanceof OCReferenceExpression) {
            CVQualifiers functionCVQualifiers;
            OCSymbol symbol = ((OCReferenceExpression)expression2).resolveToSymbol();
            CVQualifiers cVQualifiers = functionCVQualifiers = symbol instanceof OCDeclaratorSymbol ? OCCodeInsightUtil.getOuterFunctionCVQualifiers((OCDeclaratorSymbol)symbol, expression2, null) : null;
            if (functionCVQualifiers != null) {
                modifiers = modifiers.or(functionCVQualifiers);
            }
        }
        return modifiers;
    }

    public static String getPrettyNameFromClassName(Class clazz) {
        String className = clazz.getSimpleName();
        if (clazz.isAnonymousClass()) {
            className = clazz.getSuperclass().getSimpleName();
        }
        StringBuilder result2 = new StringBuilder();
        className = StringUtil.trimStart((String)className, (String)"OC");
        className = StringUtil.trimEnd((String)className, (String)"Inspection");
        className = StringUtil.trimEnd((String)className, (String)"IntentionAction");
        for (String word : StringUtil.findMatches((String)className, (Pattern)Pattern.compile("([A-Z][a-z]*)"))) {
            if (result2.length() > 0) {
                result2.append(' ').append(StringUtil.decapitalize((String)word));
                continue;
            }
            result2.append(word);
        }
        return result2.toString();
    }

    public static boolean isLikeNull(@Nullable String literal) {
        return literal != null && ("nil".equals(literal) || "NULL".equals(literal) || "nullptr".equals(literal));
    }

    public static boolean isInitializerListType(OCType type2, @Nullable PsiFile file2) {
        if (OCCompilerHelper.supportsInitializerLists(file2) && type2 instanceof OCStructType) {
            OCQualifiedName name = ((OCStructType)type2).getSymbol().getResolvedQualifiedName(false);
            return name != null && name.toString().equals("::std::initializer_list");
        }
        return false;
    }

    public static boolean isSimpleDeclaration(String declarationText, String name) {
        return "<unnamed>".equals(name) || declarationText.endsWith(name);
    }

    @Nullable
    public static OCType getCollectionElementType(@NotNull OCExpression expr, OCType type2) {
        OCFile file2 = expr.getContainingOCFile();
        OCResolveContext context = new OCResolveContext(file2);
        if (type2 instanceof OCCppReferenceType) {
            type2 = ((OCCppReferenceType)type2).getRefType();
        }
        OCType iteratorType = null;
        if (type2 instanceof OCArrayType) {
            iteratorType = type2;
        } else {
            Pair<MemberBeginEndSearchResult, OCType> result2 = type2 instanceof OCStructType ? OCCodeInsightUtil.getReturnTypeOfBeginEndPair(expr, (OCStructType)type2, file2) : Pair.create((Object)((Object)MemberBeginEndSearchResult.NONE), null);
            switch ((MemberBeginEndSearchResult)((Object)result2.getFirst())) {
                case NONE: {
                    OCSymbol begin = OCCodeInsightUtil.getGlobalBeginOrEnd("begin", type2, expr, file2, context);
                    OCSymbol end = OCCodeInsightUtil.getGlobalBeginOrEnd("end", type2, expr, file2, context);
                    if (begin != null && end != null) {
                        OCType endReturnType;
                        assert (begin instanceof OCFunctionSymbol);
                        assert (end instanceof OCFunctionSymbol);
                        OCType beginReturnType = begin.getEffectiveType().resolve(file2);
                        if (beginReturnType.equals((Object)(endReturnType = end.getEffectiveType().resolve(file2)), file2)) {
                            iteratorType = beginReturnType;
                        }
                    }
                }
                case INVALID: {
                    break;
                }
                case OK: {
                    iteratorType = (OCType)result2.getSecond();
                }
            }
        }
        return OCCodeInsightUtil.getDereferencedType(expr, iteratorType);
    }

    @Nullable
    private static OCSymbol getGlobalBeginOrEnd(@NotNull String methodName, @NotNull OCType type2, @NotNull OCExpression expr, @NotNull OCFile file2, @NotNull OCResolveContext context) {
        OCQualifiedName beginName = OCQualifiedName.interned(methodName);
        List<OCSymbol<Object>> symbols = new ArrayList<OCSymbol>(OCSymbolReference.getGlobalReference(beginName).resolveToSymbols(file2));
        symbols = ContainerUtil.filter(symbols, symbol -> symbol instanceof OCFunctionSymbol);
        List<OCType> argTypes = Collections.singletonList(type2);
        List<OCExpression> argExprs = Collections.singletonList(expr);
        Collection<OCSymbol> symbolsWithADL = OCArgumentDepLookupAccumulator.doArgDepLookup(symbols, argTypes, argExprs, beginName, context);
        OCArgumentsList<OCExpression> arguments = new OCArgumentsList<OCExpression>(argTypes, argExprs);
        return OCResolveOverloadsUtil.resolveOverloads(symbolsWithADL, arguments, null, null, null, true, true, true, true, false, context);
    }

    @Nullable
    public static OCType getDereferencedType(@NotNull OCExpression expr, @Nullable OCType iteratorType) {
        OCFile file2 = expr.getContainingOCFile();
        if (iteratorType instanceof OCPointerType) {
            return ((OCPointerType)iteratorType).getRefType();
        }
        if (iteratorType instanceof OCStructType) {
            OCFunctionSymbol operator2 = OCOperatorReference.resolveOperator("*", OCOperatorReference.OperatorPlacement.PREFIX, expr, (OCStructType)iteratorType);
            return operator2 != null ? operator2.getEffectiveType().resolve(file2) : null;
        }
        if (iteratorType instanceof OCMagicType) {
            return new OCMagicType();
        }
        return null;
    }

    public static boolean isUnnamed(OCDeclaratorSymbol field) {
        OCType fieldType = field.getType();
        return fieldType instanceof OCStructType && ((OCStructType)fieldType).isUnnamed();
    }

    @Nullable
    public static OCElementType getOppositeOperator(@NotNull OCElementType operator2) {
        return oppositeOperators.getOrDefault((Object)operator2, null);
    }

    @Nullable
    public static OCElementType getFlippedOperator(@NotNull OCElementType operator2) {
        return flippedOperators.getOrDefault((Object)operator2, null);
    }

    static class CancelException
    extends RuntimeException {
        private final OCDeclarator myDeclarator;

        public CancelException(OCDeclarator declarator) {
            this.myDeclarator = declarator;
        }

        public OCDeclarator getDeclarator() {
            return this.myDeclarator;
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    public static enum MemberBeginEndSearchResult {
        NONE,
        INVALID,
        OK;

    }
}

