/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.openapi.util.Condition;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;

public class OCCommonProcessors {

    public static class IsAssignableCondition<T>
    implements Condition<T> {
        private Class<? extends T> clazz;

        public IsAssignableCondition(Class<? extends T> clazz) {
            this.clazz = clazz;
        }

        public boolean value(T t) {
            return this.clazz.isAssignableFrom(t.getClass());
        }
    }

    public static class OrderedProcessor<T>
    implements Processor<T> {
        private Condition<T>[] myOrder;
        private Processor<? super T> myProcessor;
        private MultiMap<Condition<T>, T> myMap = new MultiMap();
        private boolean myStopAfterNonemptyCondition;
        private boolean myCancelled;
        private boolean myEmpty = true;

        @SafeVarargs
        public OrderedProcessor(Processor<? super T> processor2, Condition<T> ... order) {
            this.myOrder = order;
            this.myProcessor = processor2;
        }

        @SafeVarargs
        public OrderedProcessor(Processor<T> processor2, boolean stopAfterNonemptyCondition, Condition<T> ... order) {
            this.myOrder = order;
            this.myProcessor = processor2;
            this.myStopAfterNonemptyCondition = stopAfterNonemptyCondition;
        }

        public boolean process(T t) {
            if (this.myCancelled) {
                return false;
            }
            for (int i2 = 0; i2 < this.myOrder.length; ++i2) {
                Condition<T> condition2 = this.myOrder[i2];
                if (!condition2.value(t)) continue;
                this.myMap.putValue(condition2, t);
                if (i2 == 0) {
                    this.myEmpty = false;
                    if (!this.myProcessor.process(t)) {
                        this.myCancelled = true;
                        return false;
                    }
                }
                return true;
            }
            return true;
        }

        public boolean finish() {
            if (this.myCancelled) {
                return false;
            }
            for (int i2 = 1; i2 < this.myOrder.length; ++i2) {
                if (this.myStopAfterNonemptyCondition && !this.myEmpty) {
                    return true;
                }
                for (T t : this.sort(this.myMap.get(this.myOrder[i2]))) {
                    this.myEmpty = false;
                    if (this.myProcessor.process(t)) continue;
                    return false;
                }
            }
            return true;
        }

        public Collection<T> sort(Collection<T> collection) {
            return collection;
        }

        public boolean isEmpty() {
            return this.myMap.isEmpty();
        }
    }

    public static class TypeFilteredProcessor<T, S extends T>
    implements Processor<T> {
        private final Processor<S> myAdaptee;
        private final Class<? extends S> myClass;

        public TypeFilteredProcessor(Processor<S> adaptee, Class<? extends S> aClass) {
            this.myAdaptee = adaptee;
            this.myClass = aClass;
        }

        public boolean process(T t) {
            if (this.myClass.isAssignableFrom(t.getClass())) {
                return this.myAdaptee.process(t);
            }
            return true;
        }
    }

    public static class SelfAdapterProcessor<S, T extends S>
    implements Processor<T> {
        private final Processor<S> myAdaptee;

        public SelfAdapterProcessor(Processor<S> adaptee) {
            this.myAdaptee = adaptee;
        }

        public boolean process(T t) {
            return this.myAdaptee.process(t);
        }
    }
}

