/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class OCComparisonUtils {
    private static final Map<OCElementType, String> NEGATED_COMPARISONS = new HashMap<OCElementType, String>(6);
    private static final Map<OCElementType, String> INVERSED_OPERATORS = new HashMap<OCElementType, String>(2);

    private OCComparisonUtils() {
    }

    public static boolean isComparison(@Nullable OCExpression expression2) {
        if (expression2 instanceof OCBinaryExpression) {
            return OCTokenTypes.COMPARISON_OPERATIONS.contains((IElementType)((OCBinaryExpression)expression2).getOperationSign());
        }
        return false;
    }

    public static String getNegatedComparison(OCElementType sign) {
        return NEGATED_COMPARISONS.get((Object)sign);
    }

    public static String getInversedOperator(OCElementType sign) {
        return INVERSED_OPERATORS.get((Object)sign);
    }

    static {
        NEGATED_COMPARISONS.put(OCTokenTypes.EQEQ, "!=");
        NEGATED_COMPARISONS.put(OCTokenTypes.EXCLEQ, "==");
        NEGATED_COMPARISONS.put(OCTokenTypes.GT, "<=");
        NEGATED_COMPARISONS.put(OCTokenTypes.LT, ">=");
        NEGATED_COMPARISONS.put(OCTokenTypes.GTEQ, "<");
        NEGATED_COMPARISONS.put(OCTokenTypes.LTEQ, ">");
        INVERSED_OPERATORS.put(OCTokenTypes.ANDAND, "||");
        INVERSED_OPERATORS.put(OCTokenTypes.OROR, "&&");
        INVERSED_OPERATORS.put(OCTokenTypes.AND, "|");
        INVERSED_OPERATORS.put(OCTokenTypes.OR, "&");
    }
}

