/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolAttribute;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.visitors.OCTypeParameterResolveVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDocUtil {
    private static EnumSet<OCSymbolAttribute> POST_FUNC_ATTRIBUTES = EnumSet.of(OCSymbolAttribute.CONST, OCSymbolAttribute.FINAL, OCSymbolAttribute.OVERRIDE, OCSymbolAttribute.DELETE, OCSymbolAttribute.DEFAULT);
    private static EnumSet<OCSymbolAttribute> SKIP_DECL_ATTRIBUTES = EnumSet.of(OCSymbolAttribute.CONST, OCSymbolAttribute.CONSTEXPR);
    private static final Function<OCSymbolWithQualifiedName, String> TO_NAME = symbol -> StringUtil.escapeXml((String)symbol.getPresentableName());

    @NotNull
    public static String parameterSignature(@NotNull String type2, @Nullable String param) {
        return OCDocUtil.parameterSignature(type2, param, null);
    }

    @NotNull
    public static String parameterSignature(@NotNull String type2, @Nullable String param, @Nullable String defValue) {
        StringBuilder sb = new StringBuilder();
        boolean hasName = param != null && !"<unnamed>".equals(param);
        sb.append(type2);
        if (hasName) {
            sb.append(OCDocUtil.delimiter(type2));
        }
        sb.append(hasName ? param : "");
        if (defValue != null) {
            sb.append(" = ").append(defValue);
        }
        return sb.toString();
    }

    public static String delimiter(String type2) {
        return OCDocUtil.delimiter(type2, " ");
    }

    public static String delimiter(String type2, String del) {
        if (!(type2.endsWith("*") || type2.endsWith("&") || type2.endsWith("&amp;"))) {
            return del;
        }
        return "";
    }

    public static void extractModifiers(@NotNull OCDeclaratorSymbol symbol, @NotNull StringBuilder sb) {
        for (OCSymbolAttribute attr : OCSymbolAttribute.values()) {
            if (!symbol.hasAttribute(attr) || SKIP_DECL_ATTRIBUTES.contains((Object)attr)) continue;
            sb.append((Object)attr).append(" ");
        }
    }

    public static void extractModifiers(@NotNull OCFunctionSymbol symbol, @NotNull StringBuilder sb) {
        for (OCSymbolAttribute attr : OCSymbolAttribute.values()) {
            if (POST_FUNC_ATTRIBUTES.contains((Object)attr) || !symbol.hasAttribute(attr)) continue;
            sb.append((Object)attr).append(" ");
        }
    }

    public static void extractModifiers(@NotNull OCStructSymbol symbol, @NotNull StringBuilder sb) {
        for (OCSymbolAttribute attr : OCSymbolAttribute.values()) {
            if (!symbol.hasAttribute(attr)) continue;
            sb.append((Object)attr).append(" ");
        }
        if (symbol.isTemplateSymbol()) {
            sb.append(OCTokenTypes.TEMPLATE_CPP_KEYWORD.getName()).append(" ");
        }
    }

    public static void extractFuncPostModifiers(@NotNull OCFunctionSymbol symbol, @NotNull StringBuilder sb) {
        if (symbol.isConst()) {
            sb.append(" ").append(OCTokenTypes.CONST_KEYWORD.getName());
        }
        for (OCSymbolAttribute attr : POST_FUNC_ATTRIBUTES) {
            if (!symbol.hasAttribute(attr)) continue;
            if (attr == OCSymbolAttribute.DELETE || attr == OCSymbolAttribute.DEFAULT) {
                sb.append(" =");
            }
            sb.append(" ").append((Object)attr);
        }
    }

    @NotNull
    public static String getParametersSignature(OCFunctionSymbol symbol, boolean useSubstitution) {
        StringBuilder answer = new StringBuilder("(");
        List<OCSymbolWithQualifiedName> contextNamespace = OCDocUtil.getParents(symbol, OCSymbolKind.NAMESPACE);
        OCFile containingFile = symbol.getContainingOCFile();
        boolean isFirst = true;
        for (OCDeclaratorSymbol param : symbol.getParameterSymbols()) {
            String typeText;
            if (!isFirst) {
                answer.append(", ");
            }
            if (useSubstitution) {
                OCType type2 = param.getType().accept(new OCTypeParameterResolveVisitor(param.getContainingOCFile()));
                typeText = OCDocUtil.getCanonicalName(type2, contextNamespace, containingFile);
            } else {
                typeText = param.getType().getCanonicalName();
            }
            answer.append(OCDocUtil.parameterSignature(typeText, param.getName()));
            if (param.hasInitializer()) {
                answer.append(" = ").append(param.getInitializer().getSignature());
            }
            isFirst = false;
        }
        return answer.append(')').toString();
    }

    @NotNull
    public static String getCanonicalName(@NotNull OCType type2, @NotNull List<OCSymbolWithQualifiedName> contextNamespace, @Nullable OCFile containingFile) {
        OCType terminalType = type2.getTerminalType();
        OCType resolvedType = terminalType.resolve(containingFile);
        if (resolvedType instanceof OCStructType) {
            CVQualifiers qualifiers;
            OCStructSymbol struct = ((OCStructType)resolvedType).getSymbol();
            List<OCSymbolWithQualifiedName> symbols = OCDocUtil.getQualifiedSymbolChain(struct, OCSymbolKind.NAMESPACE, OCSymbolKind.STRUCT, OCSymbolKind.ENUM, OCSymbolKind.UNION);
            if (!symbols.isEmpty()) {
                for (OCSymbolWithQualifiedName ns : contextNamespace) {
                    OCSymbolWithQualifiedName element = symbols.get(0);
                    if (!element.equals(ns)) continue;
                    symbols.remove(0);
                }
            }
            StringBuilder res = new StringBuilder();
            CVQualifiers cVQualifiers = qualifiers = type2 instanceof OCCppReferenceType || type2 instanceof OCPointerType ? type2.getTerminalType().getCVQualifiers() : type2.getCVQualifiers();
            if (qualifiers.isConst()) {
                res.append(OCTokenTypes.CONST_KEYWORD.getName()).append(" ");
            }
            if (qualifiers.isVolatile()) {
                res.append(OCTokenTypes.VOLATILE_KEYWORD.getName()).append(" ");
            }
            res.append(StringUtil.join(symbols, symbol -> OCDocUtil.wrapSymbolName(symbol), (String)"::"));
            List<OCTypeArgument> templateArguments = Collections.emptyList();
            if (terminalType instanceof OCReferenceType) {
                OCQualifiedName name = ((OCReferenceType)terminalType).getReference(containingFile).getQualifiedName();
                if (name instanceof OCQualifiedNameWithArguments) {
                    templateArguments = ((OCQualifiedNameWithArguments)name).getArguments();
                }
            } else {
                templateArguments = struct.getTemplateArguments(new OCResolveContext());
            }
            OCDocUtil.wrapTemplateArgs(templateArguments, contextNamespace, containingFile, res);
            if (type2 instanceof OCCppReferenceType) {
                res.append(" &amp;");
            }
            if (type2 instanceof OCPointerType) {
                res.append(" *");
            }
            return res.toString();
        }
        return StringUtil.escapeXml((String)type2.getCanonicalName());
    }

    @NotNull
    public static String getNamespace(@NotNull OCSymbolWithQualifiedName<?> symbol) {
        return StringUtil.join(OCDocUtil.getParents(symbol, OCSymbolKind.NAMESPACE), TO_NAME, (String)"::");
    }

    @NotNull
    public static String getCanonicalPrefix(@NotNull OCSymbolWithQualifiedName<?> symbol) {
        List<OCSymbolWithQualifiedName> chain = OCDocUtil.getQualifiedSymbolChain(symbol);
        List structParents = chain.stream().filter(s -> s.getKind().isStructLike()).collect(Collectors.toList());
        List<OCSymbolWithQualifiedName> namespace = chain.stream().filter(s -> s.getKind() == OCSymbolKind.NAMESPACE).collect(Collectors.toList());
        if (!structParents.isEmpty()) {
            OCFile containingOCFile = symbol.getContainingOCFile();
            OCSymbolWithQualifiedName parent = (OCSymbolWithQualifiedName)structParents.get(structParents.size() - 1);
            String prefix = OCDocUtil.getCanonicalName(parent.getType(), namespace, containingOCFile);
            return OCDocUtil.replaceAnonymous(prefix);
        }
        return "";
    }

    @NotNull
    public static String replaceAnonymous(@NotNull String canonicalName) {
        return canonicalName.replace("anonymous ", "<i>(anonymous)</i>");
    }

    @NotNull
    public static List<OCSymbolWithQualifiedName> getParents(@NotNull OCSymbolWithQualifiedName<?> symbol, OCSymbolKind ... filter) {
        List<OCSymbolWithQualifiedName> chain = OCDocUtil.getQualifiedSymbolChain(symbol, filter);
        chain.remove(symbol);
        return chain;
    }

    @NotNull
    private static List<OCSymbolWithQualifiedName> getQualifiedSymbolChain(@NotNull OCSymbolWithQualifiedName<?> symbol, OCSymbolKind ... filter) {
        ArrayList<OCSymbolWithQualifiedName> parents = new ArrayList<OCSymbolWithQualifiedName>();
        symbol.getResolvedQualifiedName(true, (Consumer<OCSymbolWithQualifiedName>)((Consumer)parent -> {
            for (OCSymbolKind kind2 : filter) {
                if (parent.getKind() != kind2) continue;
                parents.add((OCSymbolWithQualifiedName)parent);
            }
        }));
        return parents;
    }

    @NotNull
    private static List<OCSymbolWithQualifiedName> getQualifiedSymbolChain(@NotNull OCSymbolWithQualifiedName<?> symbol) {
        ArrayList<OCSymbolWithQualifiedName> parents = new ArrayList<OCSymbolWithQualifiedName>();
        symbol.getResolvedQualifiedName(true, (Consumer<OCSymbolWithQualifiedName>)((Consumer)parent -> parents.add((OCSymbolWithQualifiedName)parent)));
        parents.remove(symbol);
        return parents;
    }

    @NotNull
    private static String wrapSymbolName(@NotNull OCSymbol symbol) {
        if (!(symbol instanceof OCStructSymbol)) {
            return StringUtil.escapeXml((String)symbol.getPresentableName());
        }
        StringBuilder sb = new StringBuilder();
        OCDocUtil.wrapStruct((OCStructSymbol)symbol, sb);
        return sb.toString();
    }

    private static void wrapStruct(@NotNull OCStructSymbol symbol, @NotNull StringBuilder sb) {
        String name = symbol.getName();
        boolean hasName = !"<unnamed>".equals(name);
        String link = OCDocUtil.buildLinkSymbol(symbol);
        if (hasName && link != null) {
            sb.append("<a href=\"").append(link).append("\">").append(StringUtil.escapeXml((String)name)).append("</a>");
        } else {
            sb.append(StringUtil.escapeXml((String)symbol.getPresentableName()));
        }
    }

    public static String getLink(@NotNull OCSymbol symbol) {
        String name = symbol.getPresentableName();
        boolean hasName = !"<unnamed>".equals(name);
        String link = OCDocUtil.buildLinkSymbol(symbol);
        if (hasName && link != null) {
            return "<a href=\"" + link + "\">" + StringUtil.escapeXml((String)name) + "</a>";
        }
        return StringUtil.escapeXml((String)symbol.getPresentableName());
    }

    public static void wrapTemplateArgs(@NotNull List<OCTypeArgument> templateArguments, @NotNull List<OCSymbolWithQualifiedName> contextNamespace, @Nullable OCFile containingFile, @NotNull StringBuilder answer) {
        String templateArgumentsStr = StringUtil.join(templateArguments, templateArgument -> {
            if (templateArgument instanceof OCType) {
                return OCDocUtil.getCanonicalName((OCType)templateArgument, contextNamespace, containingFile);
            }
            if (templateArgument instanceof OCExpressionTypeArgument) {
                return ((OCExpressionTypeArgument)templateArgument).getSymbol().getName();
            }
            return "";
        }, (String)", ");
        if (!templateArgumentsStr.isEmpty()) {
            answer.append(StringUtil.escapeXml((String)"<")).append(templateArgumentsStr).append(StringUtil.escapeXml((String)">"));
        }
    }

    public static void wrapTemplateParams(@NotNull List<OCTypeParameterSymbol> templateParams, @NotNull List<OCSymbolWithQualifiedName> contextNamespace, @Nullable OCFile containingFile, @NotNull StringBuilder answer) {
        String templateParamsStr = StringUtil.join(templateParams, param -> {
            StringBuilder sb = new StringBuilder();
            if (param instanceof OCTypeParameterValueSymbol) {
                String type2 = ((OCTypeParameterValueSymbol)param).getType().getName();
                sb.append(type2).append(OCDocUtil.delimiter(type2));
            }
            if (param.isVariadic()) {
                sb.append("...");
            }
            sb.append(param.getName());
            Object value2 = param.getDefaultValue();
            if (value2 != null) {
                sb.append(" = ");
                if (value2 instanceof OCType) {
                    sb.append(OCDocUtil.getCanonicalName((OCType)value2, contextNamespace, containingFile));
                } else if (value2 instanceof OCExpressionTypeArgument) {
                    sb.append(((OCExpressionTypeArgument)value2).getSymbol().getName());
                }
            }
            return sb.toString();
        }, (String)", ");
        answer.append(StringUtil.escapeXml((String)"template<")).append(templateParamsStr).append(StringUtil.escapeXml((String)">"));
    }

    @Nullable
    private static String buildLinkSymbol(@NotNull OCSymbol symbol) {
        StringBuilder sb = new StringBuilder("psi_element://");
        VirtualFile file2 = symbol.getContainingFile();
        if (file2 != null) {
            sb.append(file2.getPath()).append('#').append(symbol.getOffset());
            return sb.toString();
        }
        return null;
    }

    @NotNull
    public static List<OCSymbolWithParent> getSuperSymbols(@NotNull PsiElement element) {
        Object symbol;
        ArrayList<OCSymbolWithParent> supers = new ArrayList<OCSymbolWithParent>();
        if (element instanceof OCSymbolDeclarator && (symbol = ((OCSymbolDeclarator)element).getSymbol()) instanceof OCSymbolWithParent) {
            OCSearchUtil.processMemberAncestors((OCSymbolWithParent)symbol, (Processor<? super OCSymbolWithParent>)((Processor)s -> {
                supers.add((OCSymbolWithParent)s);
                return true;
            }), true);
        }
        return supers;
    }
}

