/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Producer;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.daemon.OCGetSymbolVisitor;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSizeofExpression;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCCallExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLambdaExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLiteralExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCReferenceExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCSizeofExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCExpansionPackType;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCReferenceTypeBuilder;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCNumber;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCExpressionEvaluator {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.lang.editor.OCConstantIntegerExpressionEvaluator");

    private OCExpressionEvaluator() {
    }

    @Nullable
    public static Number evaluate(@Nullable OCExpression psi) {
        return psi != null ? (Number)OCExpressionEvaluator.getNumber(OCExpressionEvaluator.evaluate((OCTypeOwner)psi, new ValueEvaluator(psi))) : (Number)null;
    }

    private static Long getBooleanValue(boolean value2) {
        return value2 ? 1L : 0L;
    }

    protected static Number getNumber(Object o) {
        if (o instanceof Number) {
            return (Number)o;
        }
        if (o instanceof Boolean) {
            return OCExpressionEvaluator.getBooleanValue((Boolean)o);
        }
        return null;
    }

    @Nullable
    public static Object evaluateToIntOrBoolean(@Nullable OCExpression psi) {
        return psi != null ? OCExpressionEvaluator.evaluate((OCTypeOwner)psi, new ValueEvaluator(psi)) : null;
    }

    public static boolean isPositive(@Nullable OCTypeOwner expression2, @NotNull OCResolveContext context) {
        Pair<Boolean, Number> result2 = OCExpressionEvaluator.evaluate(expression2, new PositiveEvaluator(context));
        return result2 != null ? (Boolean)result2.getFirst() : false;
    }

    @Nullable
    public static OCType getPointerType(@Nullable OCTypeOwner expression2, @NotNull OCResolveContext context) {
        return OCExpressionEvaluator.evaluate(expression2, new PointerTypeEvaluator(context));
    }

    public static boolean isLikeNil(@Nullable OCTypeOwner expression2, @NotNull OCResolveContext context) {
        return OCExpressionEvaluator.getPointerType(expression2, context) instanceof OCUnknownType;
    }

    @Nullable
    public static Number evaluate(@Nullable OCExpression expression2, @NotNull OCType targetType) {
        return OCExpressionEvaluator.getNumber(OCExpressionEvaluator.evaluate(expression2, targetType, new ValueEvaluator(expression2)));
    }

    @Nullable
    private static <T> T evaluate(@Nullable OCExpression expression2, @NotNull OCType targetType, CachingEvaluator<T> evaluator) {
        T value2 = OCExpressionEvaluator.evaluate((OCTypeOwner)expression2, evaluator);
        if (!(value2 instanceof Number)) {
            return value2;
        }
        if (OCIntType.isBool(targetType, expression2)) {
            value2 = evaluator.evalBool(OCExpressionEvaluator.singAsInC(value2) != 0);
        } else if (targetType instanceof OCIntType) {
            value2 = evaluator.evalInteger(OCNumber.convert(OCNumber.valueOf(value2), targetType.getSizeInBytes(expression2.getContainingFile(), null), ((OCIntType)targetType).isSigned()));
        }
        return value2;
    }

    @Nullable
    public static <T> T evaluate(@Nullable OCTypeOwner expression2, CachingEvaluator<T> evaluator) {
        if (expression2 == null) {
            return null;
        }
        if (expression2 instanceof OCExpression) {
            EvaluationVisitor<T> visitor = new EvaluationVisitor<T>(evaluator);
            ((OCExpression)expression2).accept(visitor);
            return (T)((EvaluationVisitor)visitor).getResult();
        }
        if (expression2 instanceof OCExpressionSymbol) {
            return ((OCExpressionSymbol)expression2).evaluate(evaluator);
        }
        return null;
    }

    @Nullable
    public static Number evaluate(@Nullable OCTypeOwner expression2, @NotNull OCResolveContext context) {
        if (expression2 instanceof OCExpression) {
            return OCExpressionEvaluator.evaluate((OCExpression)expression2);
        }
        if (expression2 instanceof OCExpressionSymbol) {
            return OCExpressionEvaluator.evaluate((OCExpressionSymbol)expression2, context);
        }
        return null;
    }

    @Nullable
    public static Object evaluate(@Nullable OCSymbol symbol, @NotNull OCResolveContext context) {
        return OCExpressionEvaluator.evaluate(symbol, context.getEvaluator());
    }

    @Nullable
    public static Number evaluate(@NotNull OCExpressionSymbol symbol, @NotNull OCResolveContext context) {
        return OCExpressionEvaluator.getNumber(symbol.evaluate(context.getEvaluator()));
    }

    @Nullable
    public static Object evaluate(@NotNull OCExpression psi, @NotNull OCResolveContext context) {
        return OCExpressionEvaluator.evaluate((OCTypeOwner)psi, context.getEvaluator());
    }

    @Nullable
    public static <T> T evaluate(@Nullable OCSymbol symbol, @NotNull CachingEvaluator<T> evaluator) {
        if (!(symbol instanceof OCDeclaratorSymbol)) {
            return null;
        }
        if (evaluator.contains(symbol)) {
            return evaluator.get(symbol);
        }
        evaluator.cache(symbol, null);
        T result2 = null;
        if (symbol.getKind() == OCSymbolKind.ENUM_CONST) {
            Integer value2 = OCExpressionEvaluator.evaluateEnumConst(symbol, evaluator);
            if (value2 != null) {
                result2 = evaluator.evalInteger(value2);
            }
        } else if (symbol instanceof OCTypeParameterValueSymbol) {
            OCTypeArgument type2 = ((OCDeclaratorSymbol)symbol).getSubstitution().getSubstitutionFor((OCTypeParameterSymbol)((Object)symbol));
            if (type2 == null) {
                type2 = evaluator.getContext().getSubstitution().getSubstitutionFor((OCTypeParameterValueSymbol)symbol);
            }
            if (type2 == null) {
                evaluator.getContext().addTypeDependency((OCTypeParameterSymbol)((Object)symbol));
            }
            if (type2 instanceof OCExpressionTypeArgument) {
                result2 = ((OCExpressionTypeArgument)type2).getSymbol().evaluate(evaluator);
            }
        } else {
            result2 = OCExpressionEvaluator.evaluateConstDeclarator((OCDeclaratorSymbol)symbol, evaluator);
        }
        if (symbol instanceof OCTypeParameterValueSymbol) {
            evaluator.remove(symbol);
        } else {
            evaluator.cache(symbol, result2);
        }
        return result2;
    }

    @Nullable
    private static <T> T evaluateConstDeclarator(@NotNull OCDeclaratorSymbol symbol, @NotNull CachingEvaluator<T> evaluator) {
        OCExpressionSymbol initializer;
        if (symbol.isConst() && symbol.getKind() != OCSymbolKind.PARAMETER && (symbol.getKind() != OCSymbolKind.STRUCT_FIELD || symbol.isFriendOrStatic()) && (initializer = symbol.getInitializer()) != null) {
            OCResolveContext oldContext = evaluator.myContext;
            evaluator.myContext = oldContext.substituteFirst(symbol.getSubstitution());
            T result2 = initializer.evaluate(evaluator);
            evaluator.myContext = oldContext;
            return result2;
        }
        return null;
    }

    @Nullable
    public static Integer evaluateEnumConst(@Nullable OCSymbol symbol, @NotNull PsiFile file2) {
        return OCExpressionEvaluator.evaluateEnumConst(symbol, new ValueEvaluator(new OCResolveContext((PsiElement)file2)));
    }

    @Nullable
    private static <T> Integer evaluateEnumConst(@Nullable OCSymbol symbol, @NotNull CachingEvaluator<T> evaluator) {
        if (symbol == null || symbol.getKind() != OCSymbolKind.ENUM_CONST || !(symbol instanceof OCDeclaratorSymbol)) {
            return null;
        }
        OCType type2 = symbol.getType();
        OCDeclaratorSymbol declarator = (OCDeclaratorSymbol)symbol;
        if (type2 instanceof OCStructType) {
            OCStructType structType = (OCStructType)type2;
            List<OCDeclaratorSymbol> fields = structType.getFields();
            int index = fields.indexOf(declarator);
            int base = 0;
            int baseIndex = 0;
            assert (index != -1);
            for (int i2 = index; i2 >= 0; --i2) {
                OCDeclaratorSymbol field = fields.get(i2);
                Number initializer = OCExpressionEvaluator.getNumber(OCExpressionEvaluator.evaluateConstDeclarator(field, evaluator));
                if (initializer == null) continue;
                base = initializer.intValue();
                baseIndex = i2;
                break;
            }
            return base + index - baseIndex;
        }
        return null;
    }

    @Nullable
    public static OCSymbol findMatchingEnumConst(OCStructType enumType, int value2, @NotNull OCResolveContext context) {
        OCStructSymbol enumSymbol = enumType.getSymbol();
        if (enumSymbol.getKind() != OCSymbolKind.ENUM) {
            return null;
        }
        int curValue = -1;
        for (OCDeclaratorSymbol field : enumType.getFields()) {
            Object initializer = OCExpressionEvaluator.evaluateConstDeclarator(field, context.getEvaluator());
            curValue = initializer instanceof Number ? ((Number)initializer).intValue() : ++curValue;
            if (curValue != value2) continue;
            return field;
        }
        return null;
    }

    @Nullable
    private static Object evalConstexprFunction(OCSymbol callee, OCResolveContext context, List<Object> arguments) {
        if (callee instanceof OCFunctionSymbol && ((OCFunctionSymbol)callee).isConstexpr()) {
            List returnExpressions;
            OCType returnType = ((OCFunctionType)callee.getType()).getReturnType();
            OCExpressionSymbol lambda2 = returnType instanceof OCAutoType ? ((OCAutoType)returnType).getExpressionSymbol() : null;
            List<Object> list = returnExpressions = lambda2 instanceof OCLambdaExpressionSymbol ? ((OCLambdaExpressionSymbol)lambda2).getReturnExpressions() : Collections.emptyList();
            if (returnExpressions.size() == 1) {
                List<OCDeclaratorSymbol> parameters2 = ((OCLambdaExpressionSymbol)lambda2).getParameters();
                if (context.getNestingDepth() > 256) {
                    return null;
                }
                if (parameters2.size() == arguments.size()) {
                    HashMap<OCTypeParameterSymbol, OCTypeArgument> substitutionMap = new HashMap<OCTypeParameterSymbol, OCTypeArgument>();
                    HashMap<OCDeclaratorSymbol, OCTypeParameterValueSymbol> parametersMap = new HashMap<OCDeclaratorSymbol, OCTypeParameterValueSymbol>();
                    for (int i2 = 0; i2 < parameters2.size(); ++i2) {
                        Object argumentValue = arguments.get(i2);
                        if (argumentValue == null) continue;
                        OCDeclaratorSymbol parameter = parameters2.get(i2);
                        OCTypeParameterValueSymbol paramSymbol = new OCTypeParameterValueSymbol(null, null, 0L, null, parameter.getQualifiedName(), null, Collections.emptyList(), parameter.getType(), OCSymbolKind.TEMPLATE_VALUE_PARAMETER, new int[0], Collections.emptyList(), null, 0, 0, null, null);
                        substitutionMap.put(paramSymbol, new OCExpressionTypeArgument(new OCLiteralExpressionSymbol(null, argumentValue, null, null)));
                        parametersMap.put(parameter, paramSymbol);
                    }
                    context = context.substitute(OCSimpleTypeSubstitution.create(substitutionMap), true, true);
                    context.setAutoParamsValueMapping(parametersMap);
                }
                return OCExpressionEvaluator.evaluate((OCExpressionSymbol)returnExpressions.get(0), context);
            }
        }
        return null;
    }

    @Nullable
    public static Boolean evaluateGNUBuiltInTrait(OCCallExpression expression2, @NotNull OCResolveContext context) {
        OCExpression function = expression2.getFunctionReferenceExpression();
        List<OCExpression> arguments = expression2.getArguments();
        if (!(function instanceof OCReferenceExpression) || arguments.size() != 1 || !(arguments.get(0) instanceof OCReferenceExpression)) {
            return null;
        }
        OCReferenceElement funElement = ((OCReferenceExpression)function).getReferenceElement();
        OCReferenceElement argElement = ((OCReferenceExpression)arguments.get(0)).getReferenceElement();
        String funName = funElement != null ? funElement.getName() : null;
        String argName = argElement != null ? argElement.getName() : null;
        OCSymbolReference argRef = new OCReferenceTypeBuilder(OCQualifiedName.interned(argName), context.getElement()).build().getReference(context.getFile());
        return OCExpressionEvaluator.evaluateGNUBuiltInTrait(context, funName, argRef);
    }

    @Nullable
    public static Boolean evaluateGNUBuiltInTrait(@NotNull OCResolveContext context, String funName, OCSymbolReference argRef) {
        if (funName == null || argRef == null || !funName.startsWith("__")) {
            return null;
        }
        OCReferenceType referenceType = new OCReferenceTypeBuilder(argRef).setSubstitution(context.getSubstitution()).build();
        OCType type2 = referenceType.resolve(context);
        if (funName.equals("__is_class")) {
            return type2 instanceof OCStructType && type2.isCppStructType();
        }
        if (funName.equals("__is_enum")) {
            return type2 instanceof OCStructType && ((OCStructType)type2).getKind() == OCSymbolKind.ENUM;
        }
        if (funName.equals("__is_union")) {
            return type2 instanceof OCStructType && ((OCStructType)type2).getKind() == OCSymbolKind.UNION;
        }
        if (funName.equals("__is_pod")) {
            return type2 instanceof OCStructType && ((OCStructType)type2).isPOD(false);
        }
        if (funName.equals("__is_abstract")) {
            return type2 instanceof OCStructType && ((OCStructType)type2).isAbstract(context);
        }
        return null;
    }

    public static int singAsInC(@NotNull Object o) {
        if (o instanceof Boolean) {
            return ((Boolean)o).compareTo(Boolean.FALSE);
        }
        if (o instanceof OCNumber) {
            return ((OCNumber)o).compareTo(BigInteger.ZERO);
        }
        if (o instanceof Long) {
            return ((Long)o).compareTo(0L);
        }
        if (o instanceof Integer) {
            return ((Integer)o).compareTo(0);
        }
        if (o instanceof Float) {
            return ((Float)o).compareTo(Float.valueOf(0.0f));
        }
        if (o instanceof Double) {
            return ((Double)o).compareTo(0.0);
        }
        OCLog.LOG.warn("Unknown type in evaluation:" + o.getClass());
        return 0;
    }

    @Contract(value="null -> false")
    public static boolean isIntValue(@Nullable Object o) {
        return o instanceof OCNumber || o instanceof BigInteger || o instanceof Long || o instanceof Integer || o instanceof Short || o instanceof Byte;
    }

    @Contract(value="null -> false")
    public static boolean isNullCompatible(@Nullable Object o) {
        return OCExpressionEvaluator.isIntValue(o) && OCExpressionEvaluator.singAsInC(o) == 0;
    }

    public static class PointerTypeEvaluator
    extends CachingEvaluator<OCType> {
        protected PointerTypeEvaluator(@NotNull OCResolveContext context) {
            super(context);
        }

        @Override
        public OCType evalDefault(OCExpression psi) {
            OCType type2 = psi.getResolvedType(this.myContext);
            return type2 instanceof OCPointerType ? type2 : null;
        }

        @Override
        @Nullable
        public OCType evalInteger(Number value2) {
            return OCExpressionEvaluator.isNullCompatible(value2) ? OCUnknownType.INSTANCE : null;
        }

        @Override
        public OCType evalBool(Boolean value2) {
            return value2 == false ? OCUnknownType.INSTANCE : null;
        }

        @Override
        public OCType evalBinary(OCElementType t, OCType l, OCType r) {
            return null;
        }

        @Override
        public OCType evalUnary(OCElementType t, OCType arg) {
            return null;
        }

        @Override
        public OCType evalConditional(OCType condition2, Producer<OCType> l, Producer<OCType> r) {
            if (l == OCUnknownType.INSTANCE) {
                return (OCType)r.produce();
            }
            if (r == OCUnknownType.INSTANCE) {
                return (OCType)l.produce();
            }
            return null;
        }

        @Override
        @Nullable
        public OCType evalCast(OCType type2, OCType operand2) {
            return null;
        }

        @Override
        @Nullable
        public OCType evalCall(OCCallExpressionSymbol symbol) {
            return null;
        }

        @Override
        @Nullable
        public OCType evalReference(OCReferenceExpressionSymbol symbol) {
            return null;
        }

        @Override
        @Nullable
        public OCType evalSizeof(OCSizeofExpressionSymbol symbol) {
            return null;
        }
    }

    public static class PositiveEvaluator
    extends CachingEvaluator<Pair<Boolean, Number>> {
        private ValueEvaluator valueEvaluator;

        public PositiveEvaluator(@NotNull OCResolveContext context) {
            super(context);
            this.valueEvaluator = new ValueEvaluator(context);
        }

        @Override
        @Nullable
        public Pair<Boolean, Number> evalDefault(@NotNull OCExpression psi) {
            OCType type2 = psi.getResolvedType(this.valueEvaluator.getContext());
            if (type2 instanceof OCIntType && !((OCIntType)type2).isSigned()) {
                return new Pair((Object)true, null);
            }
            return null;
        }

        @Override
        @NotNull
        public Pair<Boolean, Number> evalInteger(@NotNull Number value2) {
            return new Pair((Object)(OCExpressionEvaluator.singAsInC(value2) >= 0 ? 1 : 0), (Object)value2);
        }

        @Override
        public Pair<Boolean, Number> evalBool(Boolean value2) {
            return null;
        }

        @Override
        @Nullable
        public Pair<Boolean, Number> evalUnary(OCElementType t, Pair<Boolean, Number> arg) {
            if (arg == null) {
                return null;
            }
            Object value2 = this.valueEvaluator.evalUnary(t, arg.getSecond());
            return new Pair((Object)(value2 instanceof Number && ((Number)value2).longValue() >= 0L ? 1 : 0), (Object)(value2 instanceof Number ? (Number)((Number)value2) : (Number)null));
        }

        @Override
        @Nullable
        public Pair<Boolean, Number> evalBinary(OCElementType t, Pair<Boolean, Number> l, Pair<Boolean, Number> r) {
            if (l == null || r == null) {
                return null;
            }
            Object value2 = this.valueEvaluator.evalBinary(t, l.getSecond(), r.getSecond());
            boolean isPositive = value2 instanceof Number && OCExpressionEvaluator.singAsInC(value2) >= 0 || t == OCTokenTypes.PLUS && (Boolean)l.getFirst() != false && (Boolean)r.getFirst() != false;
            return new Pair((Object)isPositive, (Object)(value2 instanceof Number ? (Number)((Number)value2) : (Number)null));
        }

        @Override
        @Nullable
        public Pair<Boolean, Number> evalConditional(Pair<Boolean, Number> condition2, Producer<Pair<Boolean, Number>> l, Producer<Pair<Boolean, Number>> r) {
            Pair right;
            Pair left = l != null ? (Pair)l.produce() : null;
            Pair pair = right = r != null ? (Pair)r.produce() : null;
            return left != null && right != null ? new Pair((Object)((Boolean)left.getFirst() != false && (Boolean)right.getFirst() != false ? 1 : 0), null) : null;
        }

        @Override
        @Nullable
        public Pair<Boolean, Number> evalCast(OCType type2, Pair<Boolean, Number> operand2) {
            return null;
        }

        @Override
        @Nullable
        public Pair<Boolean, Number> evalCall(OCCallExpressionSymbol symbol) {
            return null;
        }

        @Override
        @Nullable
        public Pair<Boolean, Number> evalReference(OCReferenceExpressionSymbol symbol) {
            return null;
        }

        @Override
        @Nullable
        public Pair<Boolean, Number> evalSizeof(OCSizeofExpressionSymbol symbol) {
            return null;
        }
    }

    public static class ValueEvaluator
    extends CachingEvaluator<Object> {
        public ValueEvaluator(PsiElement element) {
            super(new OCResolveContext(element));
        }

        public ValueEvaluator(@NotNull OCResolveContext context) {
            super(context);
        }

        public ValueEvaluator(@NotNull ValueEvaluator clone, OCResolveContext context) {
            super(clone, context);
        }

        @Override
        public Number evalDefault(OCExpression psi) {
            return null;
        }

        @Override
        public Object evalConditional(Object condition2, Producer<Object> l, Producer<Object> r) {
            if (condition2 instanceof Number || condition2 instanceof Boolean) {
                return OCExpressionEvaluator.singAsInC(condition2) == 0 ? r.produce() : l.produce();
            }
            return null;
        }

        @Override
        public Object evalInteger(Number value2) {
            return value2;
        }

        @Override
        public Object evalBool(Boolean value2) {
            return value2;
        }

        @Override
        @Nullable
        public Object evalBinary(OCElementType t, Object l, Object r) {
            Number rInt;
            Number lInt;
            if (t == OCTokenTypes.OROR && l != null && OCExpressionEvaluator.singAsInC(l) != 0 || t == OCTokenTypes.ANDAND && l != null && OCExpressionEvaluator.singAsInC(l) == 0) {
                return OCExpressionEvaluator.singAsInC(l) != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            if (t == OCTokenTypes.OROR && r != null && OCExpressionEvaluator.singAsInC(r) != 0 || t == OCTokenTypes.ANDAND && r != null && OCExpressionEvaluator.singAsInC(r) == 0) {
                return OCExpressionEvaluator.singAsInC(r) != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            if (l == null || r == null) {
                return null;
            }
            if (l instanceof Boolean && r instanceof Boolean) {
                Boolean lBool = (Boolean)l;
                Boolean rBool = (Boolean)r;
                if (t == OCTokenTypes.OR) {
                    return lBool | rBool;
                }
                if (t == OCTokenTypes.XOR) {
                    return lBool ^ rBool;
                }
                if (t == OCTokenTypes.AND) {
                    return lBool & rBool;
                }
                if (t == OCTokenTypes.OROR) {
                    return lBool != false || rBool != false;
                }
                if (t == OCTokenTypes.ANDAND) {
                    return lBool != false && rBool != false;
                }
            }
            if (l instanceof Boolean) {
                l = OCExpressionEvaluator.getBooleanValue((Boolean)l);
            }
            if (r instanceof Boolean) {
                r = OCExpressionEvaluator.getBooleanValue((Boolean)r);
            }
            if (l instanceof Integer) {
                l = ((Number)l).longValue();
            }
            if (r instanceof Integer) {
                r = ((Number)r).longValue();
            }
            if (l instanceof Long && r instanceof Long) {
                lInt = (Long)l;
                rInt = (Long)r;
                if (t == OCTokenTypes.PLUS) {
                    return (Long)lInt + (Long)rInt;
                }
                if (t == OCTokenTypes.MINUS) {
                    return (Long)lInt - (Long)rInt;
                }
                if (t == OCTokenTypes.MUL) {
                    return (Long)lInt * (Long)rInt;
                }
                if (t == OCTokenTypes.DIV) {
                    return (Long)rInt != 0L ? Long.valueOf((Long)lInt / (Long)rInt) : null;
                }
                if (t == OCTokenTypes.PERC) {
                    return (Long)rInt != 0L ? Long.valueOf((Long)lInt % (Long)rInt) : null;
                }
                if (t == OCTokenTypes.OR) {
                    return (Long)lInt | (Long)rInt;
                }
                if (t == OCTokenTypes.XOR) {
                    return (Long)lInt ^ (Long)rInt;
                }
                if (t == OCTokenTypes.AND) {
                    return (Long)lInt & (Long)rInt;
                }
                if (t == OCTokenTypes.LTLT) {
                    return (Long)lInt << (int)((Long)rInt).longValue();
                }
                if (t == OCTokenTypes.GTGT) {
                    return (Long)lInt >> (int)((Long)rInt).longValue();
                }
                if (t == OCTokenTypes.OROR) {
                    return (Long)lInt != 0L || (Long)rInt != 0L ? Boolean.TRUE : Boolean.FALSE;
                }
                if (t == OCTokenTypes.ANDAND) {
                    return (Long)lInt != 0L && (Long)rInt != 0L ? Boolean.TRUE : Boolean.FALSE;
                }
                if (t == OCTokenTypes.LT) {
                    return (Long)lInt < (Long)rInt;
                }
                if (t == OCTokenTypes.LTEQ) {
                    return (Long)lInt <= (Long)rInt;
                }
                if (t == OCTokenTypes.GT) {
                    return (Long)lInt > (Long)rInt;
                }
                if (t == OCTokenTypes.GTEQ) {
                    return (Long)lInt >= (Long)rInt;
                }
                if (t == OCTokenTypes.EQEQ) {
                    return ((Long)lInt).longValue() == ((Long)rInt).longValue();
                }
                if (t == OCTokenTypes.EXCLEQ) {
                    return ((Long)lInt).longValue() != ((Long)rInt).longValue();
                }
            }
            if (l instanceof Long) {
                l = OCNumber.valueOf(((Number)l).longValue());
            }
            if (r instanceof Long) {
                r = OCNumber.valueOf(((Number)r).longValue());
            }
            if (l instanceof OCNumber && r instanceof OCNumber) {
                lInt = (OCNumber)l;
                rInt = (OCNumber)r;
                if (t == OCTokenTypes.PLUS) {
                    return ((OCNumber)lInt).add((BigInteger)rInt);
                }
                if (t == OCTokenTypes.MINUS) {
                    return ((OCNumber)lInt).subtract((BigInteger)rInt);
                }
                if (t == OCTokenTypes.MUL) {
                    return ((OCNumber)lInt).multiply((BigInteger)rInt);
                }
                if (t == OCTokenTypes.DIV) {
                    return ((BigInteger)rInt).equals(BigInteger.ZERO) ? null : ((OCNumber)lInt).divide((BigInteger)rInt);
                }
                if (t == OCTokenTypes.PERC) {
                    if (((BigInteger)rInt).equals(BigInteger.ZERO)) {
                        return null;
                    }
                    boolean positiveSign = ((OCNumber)lInt).compareTo(BigInteger.ZERO) >= 0;
                    BigInteger mod = ((BigInteger)lInt).abs().mod(((BigInteger)rInt).abs());
                    return positiveSign ? mod : mod.negate();
                }
                if (t == OCTokenTypes.OR) {
                    return ((OCNumber)lInt).or((BigInteger)rInt);
                }
                if (t == OCTokenTypes.XOR) {
                    return ((OCNumber)lInt).xor((BigInteger)rInt);
                }
                if (t == OCTokenTypes.AND) {
                    return ((OCNumber)lInt).and((BigInteger)rInt);
                }
                if (t == OCTokenTypes.LTLT) {
                    return ((OCNumber)lInt).shiftLeft((BigInteger)rInt);
                }
                if (t == OCTokenTypes.GTGT) {
                    return ((OCNumber)lInt).shiftRight((BigInteger)rInt);
                }
                if (t == OCTokenTypes.OROR) {
                    return !((BigInteger)lInt).equals(BigInteger.ZERO) || !((BigInteger)rInt).equals(BigInteger.ZERO) ? Boolean.TRUE : Boolean.FALSE;
                }
                if (t == OCTokenTypes.ANDAND) {
                    return !((BigInteger)lInt).equals(BigInteger.ZERO) && !((BigInteger)rInt).equals(BigInteger.ZERO) ? Boolean.TRUE : Boolean.FALSE;
                }
                if (t == OCTokenTypes.LT) {
                    return ((OCNumber)lInt).compareTo((BigInteger)rInt) < 0;
                }
                if (t == OCTokenTypes.LTEQ) {
                    return ((OCNumber)lInt).compareTo((BigInteger)rInt) <= 0;
                }
                if (t == OCTokenTypes.GT) {
                    return ((OCNumber)lInt).compareTo((BigInteger)rInt) > 0;
                }
                if (t == OCTokenTypes.GTEQ) {
                    return ((OCNumber)lInt).compareTo((BigInteger)rInt) >= 0;
                }
                if (t == OCTokenTypes.EQEQ) {
                    return ((OCNumber)lInt).compareTo((BigInteger)rInt) == 0;
                }
                if (t == OCTokenTypes.EXCLEQ) {
                    return ((OCNumber)lInt).compareTo((BigInteger)rInt) != 0;
                }
            }
            if (l instanceof Number && r instanceof Number) {
                return null;
            }
            LOG.error("Unexpected binary operation: " + (Object)((Object)t));
            return null;
        }

        @Override
        @Nullable
        public Object evalUnary(OCElementType t, Object arg) {
            if (arg == null) {
                return null;
            }
            if (arg instanceof Integer) {
                arg = ((Integer)arg).longValue();
            }
            if (t == OCTokenTypes.EXCL && (arg instanceof Number || arg instanceof Boolean)) {
                return OCExpressionEvaluator.getBooleanValue(OCExpressionEvaluator.singAsInC(arg) == 0);
            }
            if (t == OCTokenTypes.PLUS && arg instanceof Number) {
                return arg;
            }
            if (t == OCTokenTypes.MINUS) {
                if (arg instanceof Long) {
                    return -((Long)arg).longValue();
                }
                if (arg instanceof OCNumber) {
                    return ((OCNumber)arg).negate();
                }
            }
            if (t == OCTokenTypes.TILDE) {
                if (arg instanceof Long) {
                    return (Long)arg ^ 0xFFFFFFFFFFFFFFFFL;
                }
                if (arg instanceof OCNumber) {
                    return ((OCNumber)arg).inverse();
                }
            }
            return null;
        }

        @Override
        @Nullable
        public Object evalCast(@NotNull OCType type2, @Nullable Object operand2) {
            if (OCIntType.isBool(type2.resolve(this.getContext()), this.getContext().getElement()) && operand2 instanceof Number) {
                return this.evalBool(OCExpressionEvaluator.singAsInC(operand2) != 0);
            }
            return operand2;
        }

        @Override
        @Nullable
        public Object evalCall(@NotNull OCCallExpressionSymbol symbol) {
            OCExpressionSymbol calleeSymbol = symbol.getCalleeSymbol();
            List<OCExpressionSymbol> arguments = symbol.getArguments();
            if (calleeSymbol instanceof OCReferenceExpressionSymbol) {
                List argValues;
                Object result2;
                OCSymbol callee = ((OCReferenceExpressionSymbol)calleeSymbol).resolveToSymbol(this.myContext);
                if (arguments.size() == 1) {
                    if (callee != null && (callee.getKind() == OCSymbolKind.TYPEDEF || callee.getKind() == OCSymbolKind.USING_SYMBOL_ALIAS)) {
                        return this.evalCast(callee.getType(), arguments.get(0).evaluate(this));
                    }
                    if (arguments.get(0) instanceof OCReferenceExpressionSymbol) {
                        return OCExpressionEvaluator.evaluateGNUBuiltInTrait(this.myContext, calleeSymbol.getName(), ((OCReferenceExpressionSymbol)arguments.get(0)).getReference());
                    }
                }
                if ((result2 = OCExpressionEvaluator.evalConstexprFunction(callee, this.myContext, argValues = arguments.stream().map(e -> e.evaluate(this)).collect(Collectors.toList()))) != null) {
                    return result2;
                }
            }
            return null;
        }

        @Override
        @Nullable
        public Object evalReference(@NotNull OCReferenceExpressionSymbol symbol) {
            OCTypeParameterValueSymbol mapping;
            if (OCResolveUtil.isDependentCode(symbol.getReference().getQualifiedName(), this.myContext)) {
                return null;
            }
            OCSymbol target = symbol.resolveToSymbol(this.myContext);
            if (target != null && target.getKind() == OCSymbolKind.PARAMETER && (mapping = this.myContext.getAutoParamValueMapping((OCDeclaratorSymbol)target)) != null) {
                target = mapping;
            }
            return target != null ? OCExpressionEvaluator.evaluate(target, this) : null;
        }

        @Override
        @Nullable
        public Object evalSizeof(@NotNull OCSizeofExpressionSymbol symbol) {
            OCType type2;
            OCExpressionSymbol expression2 = symbol.getExpressionOperand();
            OCType oCType = type2 = expression2 != null ? expression2.getResolvedType(this.myContext) : symbol.getTypeOperand().resolve(this.myContext);
            if (symbol.isVariadic()) {
                OCTypeArgument argument;
                OCSymbol exprSymbol;
                if (type2 instanceof OCExpansionPackType) {
                    return ((OCExpansionPackType)type2).getExpansions().size();
                }
                if (expression2 instanceof OCReferenceExpressionSymbol && (exprSymbol = ((OCReferenceExpressionSymbol)expression2).resolveToSymbol(this.myContext)) instanceof OCTypeParameterValueSymbol && (argument = this.myContext.getSubstitution().getSubstitutionFor((OCTypeParameterValueSymbol)exprSymbol)) instanceof OCExpansionPackType) {
                    return ((OCExpansionPackType)argument).getExpansions().size();
                }
                return null;
            }
            int bytes = type2 != null ? type2.getSizeInBytes(this.myContext.getFile(), null) : -1;
            return bytes != -1 ? this.evalInteger(bytes) : null;
        }
    }

    private static class EvaluationVisitor<T>
    extends OCVisitor {
        private T myResult;
        private CachingEvaluator<T> myEvaluator;

        public EvaluationVisitor(CachingEvaluator<T> evaluator) {
            this.myEvaluator = evaluator;
        }

        @Nullable
        private T getResult() {
            return this.myResult;
        }

        @Override
        public void visitLiteralExpression(OCLiteralExpression expression2) {
            PsiElement argument = expression2.getFirstChild();
            if (argument == null) {
                return;
            }
            ASTNode leaf = argument.getNode();
            IElementType type2 = leaf.getElementType();
            Object value2 = OCElementUtil.getConstValue(type2, leaf.getText(), leaf.getPsi(), null);
            if (value2 instanceof Number) {
                this.myResult = this.myEvaluator.evalInteger((Number)value2);
            } else if (value2 instanceof Boolean) {
                this.myResult = this.myEvaluator.evalBool((Boolean)value2);
            }
        }

        @Override
        public void visitReferenceExpression(OCReferenceExpression expression2) {
            OCReferenceElement referenceElement = expression2.getReferenceElement();
            OCResolveContext context = this.myEvaluator.getContext();
            OCSymbol symbol = null;
            if (referenceElement != null) {
                symbol = referenceElement.resolveToSymbol(null, context, false, false, false);
            }
            if (!OCResolveUtil.isDependentCode(expression2, context)) {
                this.myResult = OCExpressionEvaluator.evaluate(symbol, this.myEvaluator);
            }
            if (this.myResult == null) {
                this.myResult = this.myEvaluator.evalDefault(expression2);
            }
        }

        @Override
        public void visitCastExpression(OCCastExpression expression2) {
            this.myResult = OCExpressionEvaluator.evaluate(expression2.getOperand(), expression2.getResolvedType(), this.myEvaluator);
        }

        @Override
        public void visitSizeofExpression(OCSizeofExpression expression2) {
            OCType type2;
            OCExpression operand2 = expression2.getOperand();
            OCTypeElement typeElement = expression2.getTypeElement();
            if (expression2.isVariadic()) {
                return;
            }
            if (operand2 != null) {
                type2 = operand2.getResolvedType(this.myEvaluator.getContext());
            } else if (typeElement != null) {
                type2 = typeElement.getType();
                OCResolveContext context = this.myEvaluator.getContext();
                type2 = type2.resolve(context);
            } else {
                return;
            }
            int bytes = type2.getSizeInBytes(expression2.getContainingFile(), null);
            if (bytes != -1) {
                this.myResult = this.myEvaluator.evalInteger(bytes);
            }
        }

        @Override
        public void visitParenthesizedExpression(OCParenthesizedExpression expression2) {
            this.myResult = OCExpressionEvaluator.evaluate((OCTypeOwner)expression2.getOperand(), this.myEvaluator);
        }

        @Override
        public void visitBinaryExpression(OCBinaryExpression expression2) {
            OCExpression left = expression2.getLeft();
            OCExpression right = expression2.getRight();
            OCElementType operator2 = expression2.getOperationSign();
            this.myResult = this.myEvaluator.evalBinary(operator2, OCExpressionEvaluator.evaluate((OCTypeOwner)left, this.myEvaluator), OCExpressionEvaluator.evaluate((OCTypeOwner)right, this.myEvaluator));
            if (this.myResult != null || left == null || right == null || OCCodeInsightUtil.hasSideEffects(left) || OCCodeInsightUtil.hasSideEffects(right)) {
                return;
            }
            OCType leftType = OCTypeUtils.getResolvedCppReferencedType(left, this.myEvaluator.getContext());
            OCType rightType = OCTypeUtils.getResolvedCppReferencedType(right, this.myEvaluator.getContext());
            if (OCTypeUtils.isInstanceOfType(leftType, OCMagicType.class, OCStructType.class) || OCTypeUtils.isInstanceOfType(rightType, OCMagicType.class, OCStructType.class)) {
                return;
            }
            if (OCParenthesesUtils.areExpressionsEquivalent(left, right, true, this.myEvaluator.getContext())) {
                if (leftType instanceof OCRealType || rightType instanceof OCRealType) {
                    return;
                }
                if (operator2 == OCTokenTypes.XOR || operator2 == OCTokenTypes.EXCLEQ) {
                    this.myResult = this.myEvaluator.evalBool(false);
                } else if (operator2 == OCTokenTypes.EQEQ) {
                    this.myResult = this.myEvaluator.evalBool(true);
                }
            } else if (OCParenthesesUtils.areExpressionsOpposite(left, right, true, this.myEvaluator.getContext())) {
                if (operator2 == OCTokenTypes.OROR || operator2 == OCTokenTypes.XOR || operator2 == OCTokenTypes.EXCLEQ) {
                    this.myResult = this.myEvaluator.evalBool(true);
                } else if (operator2 == OCTokenTypes.ANDAND || operator2 == OCTokenTypes.EQEQ) {
                    this.myResult = this.myEvaluator.evalBool(false);
                }
            }
        }

        @Override
        public void visitUnaryExpression(OCUnaryExpression expression2) {
            this.myResult = this.myEvaluator.evalUnary(expression2.getOperationSign(), OCExpressionEvaluator.evaluate((OCTypeOwner)expression2.getOperand(), this.myEvaluator));
        }

        @Override
        public void visitConditionalExpression(OCConditionalExpression expression2) {
            this.myResult = this.myEvaluator.evalConditional(OCExpressionEvaluator.evaluate((OCTypeOwner)expression2.getCondition(), this.myEvaluator), () -> OCExpressionEvaluator.evaluate((OCTypeOwner)expression2.getPositiveExpression(true), this.myEvaluator), () -> OCExpressionEvaluator.evaluate((OCTypeOwner)expression2.getNegativeExpression(), this.myEvaluator));
        }

        @Override
        public void visitCompoundInitializer(OCCompoundInitializer initializer) {
            List<OCExpression> expressions2 = initializer.getInitializerExpressions();
            if (expressions2.size() == 1) {
                this.myResult = OCExpressionEvaluator.evaluate((OCTypeOwner)expressions2.get(0), this.myEvaluator);
            }
        }

        @Override
        public void visitCallExpression(OCCallExpression expression2) {
            Boolean result2 = OCExpressionEvaluator.evaluateGNUBuiltInTrait(expression2, this.myEvaluator.getContext());
            if (result2 != null) {
                this.myResult = this.myEvaluator.evalBool(result2);
                return;
            }
            OCSymbol callee = OCGetSymbolVisitor.getSymbol(expression2.getFunctionReferenceExpression());
            List argValues = expression2.getArguments().stream().map(e -> OCExpressionEvaluator.evaluate((OCTypeOwner)e, this.myEvaluator)).collect(Collectors.toList());
            Number number = OCExpressionEvaluator.getNumber(OCExpressionEvaluator.evalConstexprFunction(callee, this.myEvaluator.getContext(), argValues));
            this.myResult = number != null ? this.myEvaluator.evalInteger(number) : this.myEvaluator.evalDefault(expression2);
        }

        @Override
        public void visitExpression(OCExpression expr) {
            this.myResult = this.myEvaluator.evalDefault(expr);
        }
    }

    public static abstract class CachingEvaluator<T>
    implements Evaluator<T> {
        private static final int MAX_SUBSTITUTIONS_PER_SYMBOL = 450;
        private Map<Pair<OCSymbol, OCTypeSubstitution>, T> mySymbolsWithSubstitutions = new THashMap((TObjectHashingStrategy)new TObjectHashingStrategy<Pair<OCSymbol, OCTypeSubstitution>>(this){
            final /* synthetic */ CachingEvaluator this$0;
            {
                this.this$0 = this$0;
            }

            public int computeHashCode(Pair<OCSymbol, OCTypeSubstitution> object) {
                return object.hashCode();
            }

            public boolean equals(Pair<OCSymbol, OCTypeSubstitution> o1, Pair<OCSymbol, OCTypeSubstitution> o2) {
                return DeepEqual.equalObjects(o1, o2);
            }
        });
        private MostlySingularMultiMap<OCSymbol, OCTypeSubstitution> mySubstitutions = new MostlySingularMultiMap();
        @NotNull
        protected OCResolveContext myContext;

        protected CachingEvaluator(@NotNull OCResolveContext context) {
            this.myContext = context;
        }

        public CachingEvaluator(@NotNull CachingEvaluator<T> clone, @NotNull OCResolveContext context) {
            this.mySymbolsWithSubstitutions = clone.mySymbolsWithSubstitutions;
            this.mySubstitutions = clone.mySubstitutions;
            this.myContext = context;
        }

        private OCTypeSubstitution getSubstitution(OCSymbol symbol) {
            return this.myContext.useFor(symbol).getSubstitution();
        }

        protected void cache(@Nullable OCSymbol symbol, @Nullable T value2) {
            OCTypeSubstitution substitution = this.getSubstitution(symbol);
            this.mySymbolsWithSubstitutions.put((Pair<OCSymbol, OCTypeSubstitution>)Pair.create((Object)symbol, (Object)substitution), value2);
            if (symbol != null) {
                this.mySubstitutions.add((Object)symbol, (Object)substitution);
            }
        }

        protected void remove(@Nullable OCSymbol symbol) {
            OCTypeSubstitution substitution = this.getSubstitution(symbol);
            this.mySymbolsWithSubstitutions.remove(Pair.create((Object)symbol, (Object)substitution));
            if (symbol != null) {
                this.mySubstitutions.removeAllValues((Object)symbol);
            }
        }

        protected boolean contains(@Nullable OCSymbol symbol) {
            OCTypeSubstitution substitution = this.getSubstitution(symbol);
            return this.mySymbolsWithSubstitutions.containsKey(Pair.create((Object)symbol, (Object)substitution)) || symbol != null && ((List)this.mySubstitutions.get((Object)symbol)).size() >= 450;
        }

        @Nullable
        protected T get(@Nullable OCSymbol symbol) {
            return this.mySymbolsWithSubstitutions.get(Pair.create((Object)symbol, (Object)this.getSubstitution(symbol)));
        }

        @NotNull
        public OCResolveContext getContext() {
            return this.myContext;
        }
    }

    public static interface Evaluator<T> {
        @Nullable
        public T evalInteger(Number var1);

        @Nullable
        public T evalBool(Boolean var1);

        @Nullable
        public T evalDefault(OCExpression var1);

        @Nullable
        public T evalBinary(OCElementType var1, @Nullable T var2, @Nullable T var3);

        @Nullable
        public T evalUnary(OCElementType var1, @Nullable T var2);

        @Nullable
        public T evalConditional(T var1, Producer<T> var2, Producer<T> var3);

        @Nullable
        public T evalCast(OCType var1, T var2);

        @Nullable
        public T evalCall(OCCallExpressionSymbol var1);

        @Nullable
        public T evalReference(OCReferenceExpressionSymbol var1);

        @Nullable
        public T evalSizeof(OCSizeofExpressionSymbol var1);
    }
}

