/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.editor.colors.OCHighlightingKeys;
import com.jetbrains.cidr.lang.lexer.OCHighlightingLexer;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCTollFreeBridges;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeMapper;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFormatSpecifiersUtil {
    public static final String POINTER_TYPE_REQUIRED = "<pointer type required>";
    private static final Pattern FORMAT_ATTRIBUTE_PATTERN = Pattern.compile("_{0,2}format_{0,2}#_{0,2}([^_\\s]*)_{0,2}\\s*,\\s*(\\d+)\\s*,\\s*(\\d+)");
    private static final Map<String, FormatSpecifiersInfo> PREDEFINED_FORMAT_FUNCTIONS = ContainerUtil.newHashMap((Pair)Pair.pair((Object)"printf", (Object)new FormatSpecifiersInfo(FormatType.PRINTF, 0, 1)), (Pair[])new Pair[]{Pair.pair((Object)"wprintf", (Object)new FormatSpecifiersInfo(FormatType.PRINTF, 0, 1)), Pair.pair((Object)"fprintf", (Object)new FormatSpecifiersInfo(FormatType.PRINTF, 1, 2)), Pair.pair((Object)"fwprintf", (Object)new FormatSpecifiersInfo(FormatType.PRINTF, 1, 2)), Pair.pair((Object)"sprintf", (Object)new FormatSpecifiersInfo(FormatType.PRINTF, 1, 2)), Pair.pair((Object)"swprintf", (Object)new FormatSpecifiersInfo(FormatType.PRINTF, 1, 2)), Pair.pair((Object)"snprintf", (Object)new FormatSpecifiersInfo(FormatType.PRINTF, 2, 3)), Pair.pair((Object)"asprintf", (Object)new FormatSpecifiersInfo(FormatType.PRINTF, 1, 2)), Pair.pair((Object)"scanf", (Object)new FormatSpecifiersInfo(FormatType.SCANF, 0, 1)), Pair.pair((Object)"fscanf", (Object)new FormatSpecifiersInfo(FormatType.SCANF, 1, 2)), Pair.pair((Object)"sscanf", (Object)new FormatSpecifiersInfo(FormatType.SCANF, 1, 2)), Pair.pair((Object)"strftime", (Object)new FormatSpecifiersInfo(FormatType.STRFTIME, 2, 3)), Pair.pair((Object)"wcsftime", (Object)new FormatSpecifiersInfo(FormatType.STRFTIME, 2, 3)), Pair.pair((Object)"put_time", (Object)new FormatSpecifiersInfo(FormatType.STRFTIME, 1, 0))});

    @NotNull
    private static Pair<OCTypeWrapper, Set<String>> p2s(@NotNull OCType type2, String ... spec) {
        return Pair.pair((Object)new OCTypeWrapper(type2), (Object)ContainerUtil.newHashSet((Object[])spec));
    }

    @NotNull
    private static Pair<OCTypeWrapper, Set<String>> p2s(@NotNull String typeName, boolean typeIsPointer, String ... spec) {
        return Pair.pair((Object)new OCTypeWrapper(typeName, typeIsPointer), (Object)ContainerUtil.newHashSet((Object[])spec));
    }

    @Nullable
    public static Pair<FormatSpecifiersInfo, List<SpecifierUsage>> getFormatSpecifiersInfo(@NotNull OCSymbol<?> callable, @NotNull List<OCExpression> arguments) {
        FormatSpecifiersInfo info = null;
        for (String attribute : callable.getAttributes()) {
            Matcher matcher = FORMAT_ATTRIBUTE_PATTERN.matcher(attribute);
            if (!matcher.matches()) continue;
            FormatType formatType = FormatType.getFormatTypeFromName(matcher.group(1));
            if (formatType == null) {
                return null;
            }
            info = new FormatSpecifiersInfo(formatType, Integer.parseInt(matcher.group(2)) - 1, Integer.parseInt(matcher.group(3)) - 1);
        }
        if (info == null) {
            info = PREDEFINED_FORMAT_FUNCTIONS.get(callable.getName());
        }
        if (info == null) {
            return null;
        }
        if (info.formatStringIndex < 0 || info.formatStringIndex >= info.argumentsIndex || info.formatStringIndex >= arguments.size()) {
            return null;
        }
        OCExpression formatStringArg = arguments.get(info.formatStringIndex);
        List<SpecifierUsage> specifiers = info.formatType.collectFormatSpecifiers(formatStringArg);
        if (specifiers == null) {
            return null;
        }
        return Pair.create((Object)info, specifiers);
    }

    @Nullable
    public static OCType getFormatArgumentType(@NotNull OCSymbol callable, int argumentIndex, @NotNull List<OCExpression> arguments) {
        Pair<FormatSpecifiersInfo, List<SpecifierUsage>> formatInfo = OCFormatSpecifiersUtil.getFormatSpecifiersInfo(callable, arguments);
        if (formatInfo == null || ((FormatSpecifiersInfo)formatInfo.first).argumentsIndex < 0 || argumentIndex < ((FormatSpecifiersInfo)formatInfo.first).argumentsIndex || argumentIndex >= arguments.size() || argumentIndex >= ((FormatSpecifiersInfo)formatInfo.first).argumentsIndex + ((List)formatInfo.second).size()) {
            return null;
        }
        int checkFormatSpecIndex = argumentIndex - ((FormatSpecifiersInfo)formatInfo.first).argumentsIndex;
        int currentFormatSpecIndex = 0;
        for (SpecifierUsage specifier : (List)formatInfo.second) {
            if (specifier.getType() == OCHighlightingKeys.OC_VALID_STRING_ESCAPE) continue;
            if (currentFormatSpecIndex == checkFormatSpecIndex) {
                return ((FormatSpecifiersInfo)formatInfo.first).formatType.resolveType(specifier.getName(), arguments.get(argumentIndex));
            }
            ++currentFormatSpecIndex;
        }
        return null;
    }

    static /* synthetic */ Pair access$000(OCType x0, String[] x1) {
        return OCFormatSpecifiersUtil.p2s(x0, x1);
    }

    static /* synthetic */ Pair access$100(String x0, boolean x1, String[] x2) {
        return OCFormatSpecifiersUtil.p2s(x0, x1, x2);
    }

    private static class StrFragmentIterator {
        public static final char END_MARKER = '\u0000';
        private ASTNode child;
        private int pos = -1;
        private int endPos = -1;
        private boolean BOF = true;
        private boolean hasStringLiteral = false;
        private char cur = '\u0000';
        private char prev = '\u0000';
        private char prevPrev = '\u0000';
        private final OCHighlightingLexer lexer = new OCHighlightingLexer(OCLanguageKind.OBJ_CPP, false);

        public StrFragmentIterator(@NotNull OCExpression expression2) {
            this.child = expression2.getNode().getFirstChildNode();
        }

        public boolean wasEmpty() {
            return !this.hasStringLiteral;
        }

        private boolean childAdvance() {
            if (this.child != null) {
                if (this.BOF) {
                    this.BOF = false;
                } else {
                    this.child = this.child.getTreeNext();
                }
                while (this.child != null && !OCTokenTypes.ALL_STRINGS.contains(OCElementUtil.getElementType(this.child))) {
                    this.child = this.child.getTreeNext();
                }
                this.hasStringLiteral |= this.child != null;
            }
            return this.child != null;
        }

        private void insideAdvance() {
            this.lexer.start(this.child.getText());
            if (OCTokenTypes.RAW_STRING_LITERALS.contains(OCElementUtil.getElementType(this.child))) {
                this.lexer.advance();
                this.lexer.advance();
                this.lexer.advance();
                this.pos = this.lexer.getTokenStart();
                this.endPos = this.lexer.getTokenEnd();
            } else {
                if (OCHighlightingLexer.PREFIX_TYPE == this.lexer.getTokenType()) {
                    this.lexer.advance();
                }
                this.pos = this.lexer.getTokenStart() + 1;
                this.endPos = this.lexer.getBufferEnd() - 1;
            }
        }

        public int getPos() {
            return this.child == null || this.child instanceof OCMacroForeignLeafElement ? -1 : this.child.getStartOffset() + this.pos;
        }

        public char getPrevChar() {
            return this.prev;
        }

        public char getPrevPrevChar() {
            return this.prevPrev;
        }

        public char getNextChar() {
            this.prevPrev = this.prev;
            this.prev = this.cur;
            if (this.pos == -1 || this.pos + 1 >= this.endPos) {
                while (this.childAdvance()) {
                    this.insideAdvance();
                    if (this.pos >= this.endPos) continue;
                    this.cur = this.lexer.getBufferSequence().charAt(this.pos);
                    return this.cur;
                }
                return '\u0000';
            }
            this.cur = this.lexer.getBufferSequence().charAt(++this.pos);
            return this.cur;
        }
    }

    private static class OCTypeWrapper {
        final String myTypeName;
        final boolean myTypeNameIsPointer;
        final OCType myType;

        public OCTypeWrapper(@NotNull OCType type2) {
            this.myType = type2;
            this.myTypeName = null;
            this.myTypeNameIsPointer = false;
        }

        public OCTypeWrapper(@NotNull String typeName, boolean typeNameIsPointer) {
            this.myType = null;
            this.myTypeName = typeName;
            this.myTypeNameIsPointer = typeNameIsPointer;
        }

        public OCType getTypeFromContext(@Nullable PsiElement context) {
            if (this.myType != null) {
                return this.myType;
            }
            OCType type2 = OCReferenceType.resolvedFromText(this.myTypeName, context == null ? null : context.getContainingFile());
            return this.myTypeNameIsPointer ? OCPointerType.to(type2) : type2;
        }
    }

    public static class SpecifierUsage {
        @NotNull
        private String name;
        private int lengthWithFormat;
        private int offset;
        @NotNull
        private TextAttributesKey specType;

        public SpecifierUsage(@NotNull String name, int offset, int lengthWithFormat, @NotNull TextAttributesKey specType) {
            this.name = name;
            this.lengthWithFormat = lengthWithFormat;
            this.offset = offset;
            this.specType = specType;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public TextAttributesKey getType() {
            return this.specType;
        }

        @Nullable
        public TextRange getRange() {
            return this.offset < 0 ? null : new TextRange(this.offset, this.offset + this.lengthWithFormat);
        }
    }

    public static class FormatSpecifiersInfo {
        public FormatType formatType;
        public int formatStringIndex;
        public int argumentsIndex;

        public FormatSpecifiersInfo(@NotNull FormatType formatType, int formatStringIndex, int argumentsIndex) {
            this.formatType = formatType;
            this.formatStringIndex = formatStringIndex < 0 ? -1 : formatStringIndex;
            this.argumentsIndex = argumentsIndex < 0 ? -1 : argumentsIndex;
        }
    }

    public static enum FormatType {
        PRINTF(Arrays.asList(OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.CHAR), new String[]{"%s", "%hhn"}), OCFormatSpecifiersUtil.access$000(OCIntType.CHAR, new String[]{"%hhd", "%hhi"}), OCFormatSpecifiersUtil.access$000(OCIntType.UCHAR, new String[]{"%c", "%hhu", "%hho", "%hhx", "%hhX"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.WCHAR), new String[]{"%ls"}), OCFormatSpecifiersUtil.access$000(OCIntType.WCHAR, new String[]{"%lc"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.SHORT), new String[]{"%hn"}), OCFormatSpecifiersUtil.access$000(OCIntType.SHORT, new String[]{"%hd", "%hi"}), OCFormatSpecifiersUtil.access$000(OCIntType.USHORT, new String[]{"%hu", "%ho", "%hx", "%hX"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.INT), new String[]{"%n"}), OCFormatSpecifiersUtil.access$000(OCIntType.INT, new String[]{"*", "%d", "%i"}), OCFormatSpecifiersUtil.access$000(OCIntType.UINT, new String[]{"%u", "%o", "%x", "%X"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.LONG), new String[]{"%ln"}), OCFormatSpecifiersUtil.access$000(OCIntType.LONG, new String[]{"%ld", "%li"}), OCFormatSpecifiersUtil.access$000(OCIntType.ULONG, new String[]{"%lu", "%lo", "%lx", "%lX"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.LONGLONG), new String[]{"%lln"}), OCFormatSpecifiersUtil.access$000(OCIntType.LONGLONG, new String[]{"%lld", "%lli"}), OCFormatSpecifiersUtil.access$000(OCIntType.ULONGLONG, new String[]{"%llu", "%llo", "%llx", "%llX"}), OCFormatSpecifiersUtil.access$000(OCRealType.DOUBLE, new String[]{"%a", "%A", "%e", "%E", "%f", "%F", "%g", "%G", "%la", "%lA", "%le", "%lE", "%lf", "%lF", "%lg", "%lG"}), OCFormatSpecifiersUtil.access$000(OCRealType.LONG_DOUBLE, new String[]{"%La", "%LA", "%Le", "%LE", "%Lf", "%LF", "%Lg", "%LG"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCVoidType.instance()), new String[]{"%p"}), OCFormatSpecifiersUtil.access$100("intmax_t", true, new String[]{"%jn"}), OCFormatSpecifiersUtil.access$100("intmax_t", false, new String[]{"%jd", "%ji", "%ju", "%jo", "%jx", "%jX"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.SIZE_T), new String[]{"%zn"}), OCFormatSpecifiersUtil.access$000(OCIntType.SSIZE_T, new String[]{"%zd", "%zi"}), OCFormatSpecifiersUtil.access$000(OCIntType.SIZE_T, new String[]{"%zu", "%zo", "%zx", "%zX"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.PTRDIFF_T), new String[]{"%tn"}), OCFormatSpecifiersUtil.access$000(OCIntType.PTRDIFF_T, new String[]{"%td", "%ti", "%tu", "%to", "%tx", "%tX"}), OCFormatSpecifiersUtil.access$100("<errno message, no arg>", false, new String[]{"%m"})), true, "printf"),
        NSSTRING(Arrays.asList(OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.CHAR), new String[]{"%s", "%hhn"}), OCFormatSpecifiersUtil.access$000(OCIntType.CHAR, new String[]{"%hhd", "%hhD", "%hhi"}), OCFormatSpecifiersUtil.access$000(OCIntType.UCHAR, new String[]{"%c", "%hhu", "%hhU", "%hho", "%hhO", "%hhx", "%hhX"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.WCHAR), new String[]{"%ls", "%S"}), OCFormatSpecifiersUtil.access$000(OCIntType.WCHAR, new String[]{"%lc", "%C"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.SHORT), new String[]{"%hn"}), OCFormatSpecifiersUtil.access$000(OCIntType.SHORT, new String[]{"%hd", "%hD", "%hi"}), OCFormatSpecifiersUtil.access$000(OCIntType.USHORT, new String[]{"%hu", "%hU", "%ho", "%hO", "%hx", "%hX"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.INT), new String[]{"%n"}), OCFormatSpecifiersUtil.access$000(OCIntType.INT, new String[]{"*", "%d", "%D", "%i"}), OCFormatSpecifiersUtil.access$000(OCIntType.UINT, new String[]{"%u", "%U", "%o", "%O", "%x", "%X"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.LONG), new String[]{"%ln"}), OCFormatSpecifiersUtil.access$000(OCIntType.LONG, new String[]{"%ld", "%lD", "%li"}), OCFormatSpecifiersUtil.access$000(OCIntType.ULONG, new String[]{"%lu", "%lU", "%lo", "%lO", "%lx", "%lX"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.LONGLONG), new String[]{"%lln", "%qn"}), OCFormatSpecifiersUtil.access$000(OCIntType.LONGLONG, new String[]{"%lld", "%llD", "%lli", "%qd", "%qD", "%qi"}), OCFormatSpecifiersUtil.access$000(OCIntType.ULONGLONG, new String[]{"%llu", "%llU", "%llo", "%llO", "%llx", "%llX", "%qu", "%qU", "%qo", "%qO", "%qx", "%qX"}), OCFormatSpecifiersUtil.access$000(OCRealType.DOUBLE, new String[]{"%a", "%A", "%e", "%E", "%f", "%F", "%g", "%G", "%la", "%lA", "%le", "%lE", "%lf", "%lF", "%lg", "%lG"}), OCFormatSpecifiersUtil.access$000(OCRealType.LONG_DOUBLE, new String[]{"%La", "%LA", "%Le", "%LE", "%Lf", "%LF", "%Lg", "%LG"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCVoidType.instance()), new String[]{"%p"}), OCFormatSpecifiersUtil.access$100("intmax_t", true, new String[]{"%jn"}), OCFormatSpecifiersUtil.access$100("intmax_t", false, new String[]{"%jd", "%jD", "%ji", "%ju", "%jU", "%jo", "%jO", "%jx", "%jX"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.SIZE_T), new String[]{"%zn"}), OCFormatSpecifiersUtil.access$000(OCIntType.SSIZE_T, new String[]{"%zd", "%zD", "%zi"}), OCFormatSpecifiersUtil.access$000(OCIntType.SIZE_T, new String[]{"%zu", "%zU", "%zo", "%zO", "%zx", "%zX"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.PTRDIFF_T), new String[]{"%tn"}), OCFormatSpecifiersUtil.access$000(OCIntType.PTRDIFF_T, new String[]{"%td", "%tD", "%ti", "%tu", "%tU", "%to", "%tO", "%tx", "%tX"}), OCFormatSpecifiersUtil.access$100("<errno message, no arg>", false, new String[]{"%m"}), OCFormatSpecifiersUtil.access$100("NSObject", true, new String[]{"%@"})), true, "NSString"),
        SCANF(Arrays.asList(OCFormatSpecifiersUtil.access$100("<skip input>", false, new String[]{"*"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.CHAR), new String[]{"%c", "%hhd", "%hhi", "%hhu", "%hho", "%hhx", "%hhX", "%hhn", "%s", "%["}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.WCHAR), new String[]{"%lc", "%ls", "%l["}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.SHORT), new String[]{"%hd", "%hi", "%hu", "%ho", "%hx", "%hX", "%hn"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.INT), new String[]{"%d", "%i", "%u", "%o", "%x", "%X", "%n"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.LONG), new String[]{"%ld", "%li", "%lu", "%lo", "%lx", "%lX", "%ln"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.LONGLONG), new String[]{"%lld", "%lli", "%llu", "%llo", "%llx", "%llX", "%lln"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.SIZE_T), new String[]{"%zd", "%zi", "%zu", "%zU", "%zo", "%zO", "%zx", "%zX", "%zn"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.PTRDIFF_T), new String[]{"%td", "%ti", "%tu", "%tU", "%to", "%tO", "%tx", "%tX", "%tn"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCRealType.FLOAT), new String[]{"%a", "%A", "%e", "%E", "%f", "%F", "%g", "%G"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCRealType.DOUBLE), new String[]{"%la", "%lA", "%le", "%lE", "%lf", "%lF", "%lg", "%lG"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCRealType.LONG_DOUBLE), new String[]{"%La", "%LA", "%Le", "%LE", "%Lf", "%LF", "%Lg", "%LG"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCPointerType.to(OCVoidType.instance())), new String[]{"%p"}), OCFormatSpecifiersUtil.access$100("intmax_t", true, new String[]{"%jd", "%ji", "%ju", "%jU", "%jo", "%jO", "%jx", "%jX", "%jn"})), true, "scanf"),
        STRFTIME(Arrays.asList(OCFormatSpecifiersUtil.access$100("tm", true, new String[]{"%n", "%t", "%Y", "%y", "%C", "%G", "%g", "%b", "%h", "%B", "%m", "%U", "%W", "%V", "%j", "%d", "%e", "%a", "%A", "%w", "%u", "%H", "%I", "%M", "%S", "%c", "%x", "%X", "%D", "%F", "%r", "%R", "%T", "%p", "%Z", "%z"})), false, "strftime");

        @Nullable
        private Collection<Pair<OCTypeWrapper, Set<String>>> myType2spec;
        @NotNull
        private String[] mySuffixes;
        private boolean myNeedArgumentCheck;

        private FormatType(@NotNull Collection<Pair<OCTypeWrapper, Set<String>>> type2spec, boolean check, String ... suffixes) {
            this.myType2spec = type2spec;
            this.myNeedArgumentCheck = check;
            this.mySuffixes = suffixes;
        }

        @Nullable
        @Contract(value="null->null")
        static FormatType getFormatTypeFromName(@Nullable String functionOrAttributeName) {
            if (functionOrAttributeName == null) {
                return null;
            }
            for (FormatType type2 : FormatType.values()) {
                for (String suffix : type2.mySuffixes) {
                    if (!functionOrAttributeName.endsWith(suffix)) continue;
                    return type2;
                }
            }
            return null;
        }

        @Nullable
        public OCType resolveType(@NotNull String spec, @Nullable PsiElement context) {
            if (this.myType2spec == null) {
                return null;
            }
            for (Pair<OCTypeWrapper, Set<String>> rec : this.myType2spec) {
                if (!((Set)rec.second).contains(spec)) continue;
                return ((OCTypeWrapper)rec.first).getTypeFromContext(context);
            }
            return null;
        }

        @Nullable
        public String getSpecifierForType(@NotNull OCType type2, @Nullable PsiElement context) {
            if (!(this != SCANF || type2.isCString() || type2 instanceof OCPointerType && ((OCPointerType)type2).getRefType().isCString())) {
                return type2 instanceof OCPointerType ? PRINTF.getSpecifierForType(((OCPointerType)type2).getRefType(), context) : OCFormatSpecifiersUtil.POINTER_TYPE_REQUIRED;
            }
            if (FormatType.equalsByAlias(OCIntType.SSIZE_T, type2, context)) {
                return OCIntType.SSIZE_T.getFormatString();
            }
            if (FormatType.equalsByAlias(OCIntType.SIZE_T, type2, context)) {
                return OCIntType.SIZE_T.getFormatString();
            }
            if (FormatType.equalsByAlias(OCIntType.PTRDIFF_T, type2, context)) {
                return OCIntType.PTRDIFF_T.getFormatString();
            }
            return type2.getFormatString();
        }

        private static boolean equalsByAlias(@NotNull OCIntType compilerType, @NotNull OCType type2, @Nullable PsiElement context) {
            String aliasName = type2.getAliasName();
            return aliasName != null && type2 instanceof OCIntType && (aliasName.equals(compilerType.getAliasName()) || aliasName.equals(compilerType.getText())) && ((OCIntType)type2).isSigned() == compilerType.isSigned() && ((OCIntType)type2).getBits(context, null) == compilerType.getBits(context, null);
        }

        @Contract(pure=true)
        public boolean needArgumentsCheck() {
            return this.myNeedArgumentCheck;
        }

        private boolean isSpecifierModifier(char cur, char prev) {
            switch (this) {
                case NSSTRING: 
                case SCANF: 
                case PRINTF: {
                    return (prev == '%' || FormatType.isFlag(prev)) && FormatType.isFlag(cur) && cur != prev || "0123456789.*".indexOf(cur) >= 0;
                }
                case STRFTIME: {
                    return "OE".indexOf(cur) >= 0;
                }
            }
            return false;
        }

        @Contract(pure=true)
        private static boolean isFlag(char cur) {
            return " +-#0".indexOf(cur) >= 0;
        }

        private boolean isSpecifierPart(char cur) {
            if (Character.isLetter(cur)) {
                return true;
            }
            switch (this) {
                case NSSTRING: {
                    return cur == '@';
                }
                case SCANF: {
                    return cur == '[';
                }
            }
            return false;
        }

        @Nullable
        public List<SpecifierUsage> collectFormatSpecifiers(@Nullable OCExpression expression2) {
            if (!((expression2 = OCParenthesesUtils.diveIntoParenthesesAndCasts(expression2)) instanceof OCLiteralExpression)) {
                return null;
            }
            ArrayList<SpecifierUsage> result2 = new ArrayList<SpecifierUsage>();
            StrFragmentIterator iter = new StrFragmentIterator(expression2);
            boolean skipNext = false;
            char cur = '\u0000';
            while (true) {
                if (skipNext) {
                    skipNext = false;
                } else {
                    cur = iter.getNextChar();
                }
                if (cur == '\u0000') break;
                if (cur != '%') continue;
                StringBuilder specifier = new StringBuilder();
                boolean wasNonPercent = false;
                boolean wasNonFormat = false;
                boolean wasCrossLiteralJump = false;
                int numOfPercents = 0;
                int lengthWithFormat = 0;
                int offset = iter.getPos();
                int prevPos = offset - 1;
                while (cur == '%' || this.isSpecifierPart(cur) || this.isSpecifierModifier(cur, iter.getPrevChar())) {
                    if (cur == '%') {
                        if (wasNonPercent || ++numOfPercents == 2) {
                            break;
                        }
                    } else {
                        wasNonPercent = true;
                    }
                    if (wasNonFormat || !this.isSpecifierModifier(cur, iter.getPrevChar())) {
                        wasCrossLiteralJump = prevPos + 1 != iter.getPos();
                        specifier.append(cur);
                        if (cur != '%') {
                            wasNonFormat = true;
                        }
                    } else if (cur == '*') {
                        result2.add(new SpecifierUsage("*", iter.getPos(), 1, OCHighlightingKeys.OC_FORMAT_STRING_TOKEN));
                    }
                    ++lengthWithFormat;
                    prevPos = iter.getPos();
                    cur = iter.getNextChar();
                    if (cur != '\u0000') continue;
                }
                if (numOfPercents >= 2) {
                    result2.add(new SpecifierUsage(specifier.toString(), wasCrossLiteralJump ? -1 : offset, numOfPercents, OCHighlightingKeys.OC_VALID_STRING_ESCAPE));
                    cur = iter.getNextChar();
                    if (cur == '\u0000') {
                        break;
                    }
                } else if (specifier.length() > 0) {
                    String specifierName;
                    int length = specifier.length();
                    int lengthWithFormatFull = lengthWithFormat;
                    boolean isValidSpec = false;
                    while (length > 1) {
                        boolean bl = isValidSpec = this.resolveType(specifier.substring(0, length), expression2) != null;
                        if (isValidSpec) break;
                        --length;
                        --lengthWithFormat;
                    }
                    if ((specifierName = specifier.substring(0, length)).endsWith("[")) {
                        while (cur != '\u0000') {
                            boolean bl = isValidSpec = cur == ']';
                            if (isValidSpec) break;
                            ++lengthWithFormatFull;
                            prevPos = iter.getPos();
                            cur = iter.getNextChar();
                            wasCrossLiteralJump = prevPos + 1 != iter.getPos();
                        }
                        if (cur != '\u0000') {
                            lengthWithFormat = ++lengthWithFormatFull;
                        }
                    }
                    result2.add(new SpecifierUsage(specifierName, wasCrossLiteralJump ? -1 : offset, lengthWithFormat, isValidSpec ? OCHighlightingKeys.OC_FORMAT_STRING_TOKEN : OCHighlightingKeys.OC_INVALID_STRING_ESCAPE));
                }
                skipNext = true;
            }
            return iter.wasEmpty() ? null : result2;
        }

        public boolean isCompatible(@NotNull OCType requiredType, @NotNull OCType actualType, @NotNull String requiredSpecifierName, @NotNull String actualSpecifierName, @Nullable PsiElement context) {
            if (requiredSpecifierName.equals(actualSpecifierName) || requiredType.equals((Object)actualType, context)) {
                return true;
            }
            if (this == PRINTF || this == NSSTRING) {
                OCType actualSpecType;
                if (requiredSpecifierName.equals("%@") && actualType.isPointer() && OCTollFreeBridges.getNSCounterpart(actualType.getName()) != null) {
                    return true;
                }
                if (requiredSpecifierName.endsWith("n") && actualType.isPointer()) {
                    actualSpecType = ((OCPointerType)actualType).getRefType();
                    if (actualSpecType.isConst()) {
                        return false;
                    }
                    requiredType = ((OCPointerType)requiredType).getRefType();
                } else {
                    actualSpecType = actualType instanceof OCIntType ? actualType : this.resolveType(actualSpecifierName, context);
                }
                if (actualSpecType != null) {
                    if (requiredType instanceof OCIntType && actualSpecType instanceof OCIntType) {
                        int requiredRank = FormatType.getRank(((OCIntType)requiredType).getCTypeId());
                        int actualRank = FormatType.getRank(((OCIntType)actualSpecType).getCTypeId());
                        if (requiredRank > 0 && actualRank > 0) {
                            return requiredRank == actualRank;
                        }
                        return ((OCIntType)requiredType).getBits(context, null) == ((OCIntType)actualSpecType).getBits(context, null);
                    }
                    if (requiredType instanceof OCRealType && actualSpecType instanceof OCRealType) {
                        OCTypeMapper.CTypeId typeId1 = ((OCRealType)requiredType).getCTypeId();
                        OCTypeMapper.CTypeId typeId2 = ((OCRealType)actualSpecType).getCTypeId();
                        return OCTypeMapper.CTypeId.LONG_DOUBLE.equals((Object)typeId1) == OCTypeMapper.CTypeId.LONG_DOUBLE.equals((Object)typeId2);
                    }
                    return requiredType.equals((Object)actualSpecType, context);
                }
            } else if (this == SCANF && requiredType instanceof OCPointerType && actualType instanceof OCPointerType) {
                OCType actualTypeBase = ((OCPointerType)actualType).getRefType();
                if (actualTypeBase.isConst()) {
                    return false;
                }
                OCType requiredTypeBase = ((OCPointerType)requiredType).getRefType();
                if (requiredTypeBase instanceof OCNumericType && actualTypeBase instanceof OCNumericType) {
                    return ((OCNumericType)requiredTypeBase).getCTypeId() == ((OCNumericType)actualTypeBase).getCTypeId();
                }
            }
            return false;
        }

        private static int getRank(OCTypeMapper.CTypeId typeId) {
            switch (typeId) {
                case BOOL: 
                case SIGNED_CHAR: 
                case CHAR: 
                case CHAR16_T: 
                case CHAR32_T: 
                case WCHAR_T: 
                case SHORT: 
                case INT: {
                    return 1;
                }
                case LONG: {
                    return 2;
                }
                case LONG_LONG: {
                    return 3;
                }
            }
            return 0;
        }
    }
}

