/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKindProvider;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculatorHelper;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveRootAndConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLanguageKindCalculator {
    public static final Key<Boolean> FORCE_FILE_TYPE_IN_TESTS = Key.create((String)"FORCE_FILE_TYPE_IN_TESTS");

    @NotNull
    public static OCLanguageKind calculateLanguageKindFast(@NotNull PsiFile file2) {
        Project project2 = file2.getProject();
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(file2);
        if (virtualFile != null) {
            OCFile associated;
            OCLanguageKind result2 = OCLanguageKindCalculator.tryFileTypeAndExtension(project2, virtualFile);
            if (result2 != null) {
                return result2;
            }
            if (file2 instanceof OCFile && OCInclusionContextUtil.isNeedToFindRoot(file2) && (associated = ((OCFile)file2).getAssociatedFileWithSameName()) != null && !OCInclusionContextUtil.isNeedToFindRoot(associated)) {
                return OCLanguageKindCalculator.calculateLanguageKindFast(associated);
            }
        } else {
            String name = file2.getName();
            OCLanguageKind result3 = OCLanguageKindCalculator.tryFileExtension(project2, name);
            if (result3 != null) {
                return result3;
            }
        }
        return CLanguageKind.maxLanguage(project2);
    }

    @Nullable
    public static OCLanguageKind tryFileTypeAndExtension(@Nullable Project project2, @Nullable VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        OCLanguageKind result2 = OCLanguageKindCalculator.trySpecifiedFileType(project2, file2);
        if (result2 != null) {
            return result2;
        }
        result2 = OCLanguageKindCalculator.tryFileExtension(project2, file2.getName());
        if (result2 != null) {
            return result2;
        }
        if (file2.getUserData(FORCE_FILE_TYPE_IN_TESTS) == Boolean.TRUE) {
            String ext = file2.getExtension();
            for (OCLanguageKind kind2 : OCLanguageKindProvider.getAllLanguageKinds()) {
                if (!kind2.getDefaultSourceExtension().equalsIgnoreCase(ext)) continue;
                return kind2;
            }
        }
        return null;
    }

    @Nullable
    private static OCLanguageKind trySpecifiedFileType(@Nullable Project project2, @Nullable VirtualFile file2) {
        if (project2 == null || file2 == null) {
            return null;
        }
        for (OCLanguageKindCalculatorHelper each : OCLanguageKindCalculator.getHelpers()) {
            OCLanguageKind result2 = each.getSpecifiedLanguage(project2, file2);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Nullable
    public static OCLanguageKind tryFileExtension(@Nullable Project project2, @Nullable String name) {
        if (project2 == null || name == null) {
            return null;
        }
        for (OCLanguageKindCalculatorHelper each : OCLanguageKindCalculator.getHelpers()) {
            OCLanguageKind result2 = each.getLanguageByExtension(project2, name);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @NotNull
    private static OCLanguageKindCalculatorHelper[] getHelpers() {
        return (OCLanguageKindCalculatorHelper[])Extensions.getExtensions(OCLanguageKindCalculatorHelper.EP_NAME);
    }

    @NotNull
    public static OCLanguageKind calculateLanguageKind(@NotNull OCFile file2) {
        PsiFile containingFile;
        PsiElement context;
        if (file2 instanceof OCCodeFragment && (context = file2.getContext()) != null && (containingFile = context.getContainingFile()) instanceof OCFile) {
            return OCLanguageKindCalculator.calculateLanguageKind((OCFile)containingFile);
        }
        Project project2 = file2.getProject();
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(file2);
        if (virtualFile == null) {
            String name = file2.getName();
            OCLanguageKind result2 = OCLanguageKindCalculator.tryFileExtension(project2, name);
            if (result2 != null) {
                return result2;
            }
            return CLanguageKind.maxLanguage(project2);
        }
        return OCLanguageKindCalculator.calculateLanguageKind(OCInclusionContextUtil.getActiveConfiguration(file2), virtualFile, project2);
    }

    @NotNull
    private static OCLanguageKind calculateLanguageKind(@Nullable OCResolveConfiguration activeConfig, @NotNull VirtualFile file2, @NotNull Project project2) {
        OCLanguageKind result2;
        if (activeConfig != null && (result2 = activeConfig.getDeclaredLanguageKind(file2)) != null) {
            return result2;
        }
        result2 = OCLanguageKindCalculator.tryFileTypeAndExtension(project2, file2);
        if (result2 != null) {
            return result2;
        }
        if (OCInclusionContextUtil.isNeedToFindRoot(file2, project2)) {
            OCResolveRootAndConfiguration rootAndConfiguration = OCInclusionContextUtil.getResolveRootAndActiveConfiguration(file2, project2);
            VirtualFile rootFile = rootAndConfiguration.getRootFile();
            OCResolveConfiguration rootConfig = rootAndConfiguration.getConfiguration();
            if (rootFile != null && rootConfig != null && !rootFile.equals(file2)) {
                result2 = OCLanguageKindCalculator.tryLanguageKindFromPchRoot(rootConfig, file2, rootFile);
                if (result2 != null) {
                    return result2;
                }
                return OCLanguageKindCalculator.calculateLanguageKind(rootConfig, rootFile, project2);
            }
        }
        return activeConfig != null ? activeConfig.getMaximumLanguageKind() : CLanguageKind.maxLanguage(project2);
    }

    @Nullable
    public static OCLanguageKind tryLanguageKindFromPchRoot(@NotNull OCResolveConfiguration config, @NotNull VirtualFile header, @NotNull VirtualFile pchCandidate) {
        OCImmutableInclusionContext cachedContext = OCInclusionContext.tryFindInCachedPCHPrecompiledContexts(config, header, pchCandidate);
        return cachedContext != null ? cachedContext.getLanguageKind() : null;
    }
}

