/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeaderRoots;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCResolveRootAndConfiguration {
    private final VirtualFile myRootFile;
    @Nullable
    private final OCResolveConfiguration myConfiguration;
    private final OCLanguageKind myKind;

    public OCResolveRootAndConfiguration(@Nullable OCResolveConfiguration configuration, @NotNull OCLanguageKind kind2) {
        this.myConfiguration = configuration;
        this.myRootFile = null;
        this.myKind = kind2;
    }

    public OCResolveRootAndConfiguration(@Nullable OCResolveConfiguration configuration, @NotNull VirtualFile rootFile) {
        this.myConfiguration = configuration;
        this.myRootFile = rootFile;
        this.myKind = null;
    }

    @Nullable
    public VirtualFile getRootFile() {
        return this.myRootFile;
    }

    @Nullable
    public Project getProject() {
        return this.myConfiguration == null ? null : this.myConfiguration.getProject();
    }

    @Nullable
    public OCResolveConfiguration getConfiguration() {
        return this.myConfiguration;
    }

    public OCLanguageKind getKind() {
        return this.myKind;
    }

    @NotNull
    public HeaderRoots getLibraryHeadersRoots() {
        if (this.myConfiguration == null) {
            return HeaderRoots.EMPTY;
        }
        return this.myConfiguration.getLibraryHeadersRoots(this);
    }

    @NotNull
    public HeaderRoots getProjectHeadersRoots() {
        if (this.myConfiguration == null) {
            return HeaderRoots.EMPTY;
        }
        return this.myConfiguration.getProjectHeadersRoots();
    }
}

