/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultModificationTracker;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.util.messages.MessageBus;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCWorkspaceModificationTrackers {
    private final Project myProject;
    private final PsiModificationTrackerImpl myPsiTracker;
    private final DefaultModificationTracker myProjectsListTracker;
    private final DefaultModificationTracker myProjectFilesListTracker;
    private final DefaultModificationTracker mySourceFilesListTracker;
    private final DefaultModificationTracker myBuildSettingsChangesTracker;
    private final DefaultModificationTracker mySelectedResolveConfigurationTracker;
    private final DefaultModificationTracker myBuildsTracker;

    @NotNull
    public static OCWorkspaceModificationTrackers getInstance(@NotNull Project project2) {
        return (OCWorkspaceModificationTrackers)ServiceManager.getService((Project)project2, OCWorkspaceModificationTrackers.class);
    }

    public OCWorkspaceModificationTrackers(@NotNull Project project2) {
        this.myProject = project2;
        this.myPsiTracker = (PsiModificationTrackerImpl)PsiManager.getInstance((Project)project2).getModificationTracker();
        MessageBus bus = project2.getMessageBus();
        this.myProjectsListTracker = new MyModificationTracker(() -> ((OCWorkspaceModificationListener)bus.syncPublisher(OCWorkspaceModificationListener.TOPIC)).projectsChanged());
        this.myProjectFilesListTracker = new MyModificationTracker(() -> ((OCWorkspaceModificationListener)bus.syncPublisher(OCWorkspaceModificationListener.TOPIC)).projectFilesChanged());
        this.mySourceFilesListTracker = new MyModificationTracker(() -> ((OCWorkspaceModificationListener)bus.syncPublisher(OCWorkspaceModificationListener.TOPIC)).sourceFilesChanged());
        this.myBuildSettingsChangesTracker = new MyModificationTracker(() -> ((OCWorkspaceModificationListener)bus.syncPublisher(OCWorkspaceModificationListener.TOPIC)).buildSettingsChanged());
        this.mySelectedResolveConfigurationTracker = new MyModificationTracker(() -> ((OCWorkspaceModificationListener)bus.syncPublisher(OCWorkspaceModificationListener.TOPIC)).selectedResolveConfigurationChanged());
        this.myBuildsTracker = new MyModificationTracker(() -> ((OCWorkspaceModificationListener)bus.syncPublisher(OCWorkspaceModificationListener.TOPIC)).buildFinished());
    }

    @NotNull
    public DefaultModificationTracker getProjectsListTracker() {
        return this.myProjectsListTracker;
    }

    @NotNull
    public DefaultModificationTracker getProjectFilesListTracker() {
        return this.myProjectFilesListTracker;
    }

    @NotNull
    public DefaultModificationTracker getSourceFilesListTracker() {
        return this.mySourceFilesListTracker;
    }

    @NotNull
    public DefaultModificationTracker getBuildSettingsChangesTracker() {
        return this.myBuildSettingsChangesTracker;
    }

    @NotNull
    public DefaultModificationTracker getSelectedResolveConfigurationTracker() {
        return this.mySelectedResolveConfigurationTracker;
    }

    @NotNull
    public DefaultModificationTracker getBuildsTracker() {
        return this.myBuildsTracker;
    }

    private class MyModificationTracker
    extends DefaultModificationTracker {
        @Nullable
        private final Runnable myPublisher;

        private MyModificationTracker(Runnable publisher) {
            this.myPublisher = publisher;
        }

        public void incModificationCount() {
            super.incModificationCount();
            OCWorkspaceModificationTrackers.this.myPsiTracker.incCounter();
            OCWorkspaceModificationTrackers.this.myPsiTracker.incOutOfCodeBlockModificationCounter();
            if (this.myPublisher != null) {
                this.myPublisher.run();
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (OCWorkspaceModificationTrackers.this.myProject.isDisposed()) {
                    return;
                }
                DaemonCodeAnalyzer.getInstance((Project)OCWorkspaceModificationTrackers.this.myProject).restart();
            }, ModalityState.NON_MODAL);
        }
    }
}

