/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCRunConfigurationWithResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationListener;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackers;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCWorkspaceRunConfigurationListener
extends AbstractProjectComponent {
    private final RunManagerEx myRunManager;
    @Nullable
    private volatile OCResolveConfiguration mySelectedResolveConfiguration;

    protected OCWorkspaceRunConfigurationListener(Project project2, RunManagerEx runManager) {
        super(project2);
        this.myRunManager = runManager;
        runManager.addRunManagerListener(new RunManagerListener(){
            boolean isBatchUpdate;

            @Override
            public void beginUpdate() {
                this.isBatchUpdate = true;
            }

            @Override
            public void endUpdate() {
                this.isBatchUpdate = false;
                this.doUpdate();
            }

            @Override
            public void runConfigurationSelected() {
                this.doUpdate();
            }

            @Override
            public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
                this.doUpdate();
            }

            @Override
            public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
                this.doUpdate();
            }

            @Override
            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings, String existingId) {
                this.doUpdate();
            }

            void doUpdate() {
                if (this.isBatchUpdate) {
                    return;
                }
                OCWorkspaceRunConfigurationListener.this.updateSelectedConfiguration();
            }
        });
        project2.getMessageBus().connect().subscribe(OCWorkspaceModificationListener.TOPIC, (Object)new OCWorkspaceModificationListener(){

            @Override
            public void projectsChanged() {
                OCWorkspaceRunConfigurationListener.this.updateSelectedConfiguration();
            }
        });
    }

    public void projectOpened() {
        this.updateSelectedConfiguration();
    }

    private void updateSelectedConfiguration() {
        RunnerAndConfigurationSettings settings = this.myRunManager.getSelectedConfiguration();
        if (settings != null && settings.getConfiguration() instanceof OCRunConfigurationWithResolveConfiguration) {
            OCWorkspaceRunConfigurationListener.setSelectedResolveConfiguration(this.myProject, ((OCRunConfigurationWithResolveConfiguration)settings.getConfiguration()).getResolveConfiguration());
        }
    }

    @Nullable
    public static OCResolveConfiguration getSelectedResolveConfiguration(@NotNull Project project2) {
        return project2.isDefault() ? null : OCWorkspaceRunConfigurationListener.getInstance((Project)project2).mySelectedResolveConfiguration;
    }

    public static void setSelectedResolveConfiguration(@NotNull Project project2, @Nullable OCResolveConfiguration selectedResolveConfiguration) {
        if (project2.isDefault()) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            OCWorkspaceRunConfigurationListener instance = OCWorkspaceRunConfigurationListener.getInstance(project2);
            if (!Objects.equals(instance.mySelectedResolveConfiguration, selectedResolveConfiguration)) {
                instance.mySelectedResolveConfiguration = selectedResolveConfiguration;
                OCWorkspaceModificationTrackers.getInstance(project2).getSelectedResolveConfigurationTracker().incModificationCount();
            }
        });
    }

    @NotNull
    private static OCWorkspaceRunConfigurationListener getInstance(@NotNull Project project2) {
        return (OCWorkspaceRunConfigurationListener)((Object)project2.getComponent(OCWorkspaceRunConfigurationListener.class));
    }
}

