/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCWorkspaceUtil {
    @NotNull
    public static String getConfigurationDisplayName(@Nullable String targetName, @NotNull String configName, boolean shorten) {
        if (targetName == null) {
            return OCWorkspaceUtil.getOrUnnamed(configName);
        }
        if (shorten) {
            Object[] parts = NameUtil.splitNameIntoWords((String)configName);
            configName = StringUtil.join((Collection)ContainerUtil.map((Object[])parts, it -> {
                if (!(it = it.trim()).isEmpty()) {
                    boolean digitsOnly = true;
                    boolean lettersOnly = true;
                    for (int i2 = 0; i2 < it.length(); ++i2) {
                        char ch = it.charAt(i2);
                        if (!Character.isAlphabetic(ch)) {
                            lettersOnly = false;
                        }
                        if (Character.isDigit(ch)) continue;
                        digitsOnly = false;
                    }
                    if (lettersOnly) {
                        return it.substring(0, 1);
                    }
                    if (digitsOnly) {
                        return it;
                    }
                }
                return "";
            }), (String)"");
        }
        if (StringUtil.isEmptyOrSpaces((String)configName)) {
            return OCWorkspaceUtil.getOrUnnamed(targetName);
        }
        return targetName + " [" + configName + "]";
    }

    @NotNull
    public static String getOrUnnamed(@NotNull String configName) {
        return StringUtil.notNullize((String)StringUtil.nullize((String)configName, (boolean)true), (String)"Unnamed");
    }

    public static int compareConfigurations(@NotNull OCResolveConfiguration a, @NotNull OCResolveConfiguration b) {
        return a.getDisplayName(false).compareToIgnoreCase(b.getDisplayName(false));
    }

    @NotNull
    public static OCLanguageKind getMaximumLanguageKind(@NotNull Collection<OCLanguageKind> all, @NotNull Project project2) {
        CLanguageKind result2 = null;
        for (OCLanguageKind each : all) {
            if (result2 != null && (!(each instanceof CLanguageKind) || ((CLanguageKind)each).ordinal() <= result2.ordinal())) continue;
            result2 = (CLanguageKind)each;
        }
        return result2 == null ? CLanguageKind.maxLanguage(project2) : result2;
    }
}

