/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.PredefinedVariables;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCPreprocessingLexer;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import java.util.Arrays;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class OCCompilerMacros {
    public static final OCCompilerMacros BUILT_INS = new OCCompilerMacros(){

        @Override
        protected void fillFileMacros(@NotNull OCInclusionContext context, @NotNull PsiFile sourceFile) {
        }
    };
    public static final String __STDC__ = "__STDC__";
    public static final String __STDC_VERSION__ = "__STDC_VERSION__";
    public static final String __CPLUSPLUS = "__cplusplus";
    private static final String STANDARD_MACROS = "\n" + OCCompilerMacros.getIDEMacros() + "\n#define __PRETTY_FUNCTION__ \"_function_name_\"\n#define __FUNCTION__ \"_function_name_\"\n#define __FUNCDNAME__ \"_function_decorated_name_\"\n#define __FUNCSIG__ \"_function__signature_\"\n#define __func__ \"_function_name_\"\n#define __DATE__ \"_date_\"\n#define __TIME__ \"_time_\"\n#define __TIMESTAMP__ \"_timestamp_\"\n#define __FILE__ \"_file_name_\"\n#define __BASE_FILE__ \"_base_file_name_\"\n#define __LINE__ 0\n#define __COUNTER__ 0\n#define __INCLUDE_LEVEL__ 0\n#define va_start(v,l)\t__builtin_va_start(v,l)\n#define va_end(v)\t__builtin_va_end(v)\n#define va_arg(v,l)\t__builtin_va_arg(v,l)\n#define va_copy(d,s)\t__builtin_va_copy(d,s)\n#define __va_copy(d,s)\t__builtin_va_copy(d,s)\n#define __builtin_va_arg(list, type) __builtin_jb_va_args(list, sizeof(type)) \n#define __builtin_offsetof(type, member) __builtin_jb_offsetof(&(((type *)0)->member)) \n#define __builtin_types_compatible_p(X,Y) 1\n#define __builtin_choose_expr(C,T,E) T\n#define __builtin_va_start(list, options) list = \"builtin initialization\" \n#define __glibcxx_function_requires(...) \n#define __BEGIN_DECLS \n#define __END_DECLS \n#define __extension__\n#define __has_feature 1\n#define __has_feature(X) " + OCCompilerMacros.clangFeature("##X") + "\n#define __has_extension(X) " + OCCompilerMacros.clangExtension("##X") + "\n#define __has_attribute(X) " + OCCompilerMacros.clangAttribute("##X") + "\n";
    public static final String PREDEFINED_MACROS;
    private static final String NO_REDEFINE_MACROS = "\n#define _GLIBCXX_COMMA ,\n#define _GLIBCXX_TEMPLATE_PARAMS typename... __T\n#define _GLIBCXX_TEMPLATE_ARGS __T...\n#define _GLIBCXX_PARAMS __T... params\n#define _GLIBCXX_ARGS params\n#define _GLIBCXX_BEGIN_NESTED_NAMESPACE(X, Y) namespace X  { \n#undef _LIBCPP_HAS_NO_INT128";

    @NotNull
    private static String getIDEMacros() {
        return StringUtil.join(PredefinedVariables.getIDEVariables(), it -> "#define __" + it + "__ " + PredefinedVariables.getVersionNumber() + "L", (String)"\n");
    }

    public final void fillContext(@NotNull OCInclusionContext context, @NotNull PsiFile sourceFile) {
        if (!context.isInitial()) {
            OCLog.LOG.error("Macro injection for non-initial context!");
        }
        context.addNeverRedefineMacros(ContainerUtil.flatten((Iterable)ContainerUtil.map(OCCompilerFeatures.UNSUPPORTED_CLANG_FEATURES, each -> Arrays.asList(OCCompilerMacros.clangFeature(each), OCCompilerMacros.clangExtension(each)))));
        OCCompilerMacros.fillSubstitutions(context, PREDEFINED_MACROS);
        OCInclusionContext newContext = OCInclusionContext.empty(context.getLanguageKind(), sourceFile);
        OCCompilerMacros.fillSubstitutions(newContext, NO_REDEFINE_MACROS);
        context.addNeverRedefineMacros(newContext.getSubstitutions().keySet());
        context.getSubstitutions().putAll(newContext.getSubstitutions());
        this.fillFileMacros(context, sourceFile);
    }

    protected abstract void fillFileMacros(@NotNull OCInclusionContext var1, @NotNull PsiFile var2);

    public static void fillSubstitutions(@NotNull OCInclusionContext context, @NotNull String text) {
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            return;
        }
        OCPreprocessingLexer lexer = new OCPreprocessingLexer(context, null);
        lexer.start(text);
        while (lexer.getTokenType() != null) {
            lexer.advance();
        }
    }

    public void enableClangFeatures(@NotNull OCInclusionContext context, @NotNull Map<String, String> features) {
        for (Map.Entry<String, String> each : features.entrySet()) {
            this.enableClangFeature(context, each.getKey(), each.getValue());
        }
    }

    public void enableClangExtensions(@NotNull OCInclusionContext context, @NotNull Map<String, String> extensions) {
        for (Map.Entry<String, String> each : extensions.entrySet()) {
            this.enableClangExtension(context, each.getKey(), each.getValue());
        }
    }

    public void enableClangAttributes(@NotNull OCInclusionContext context, @NotNull Map<String, String> attributes) {
        for (Map.Entry<String, String> each : attributes.entrySet()) {
            this.enableClangAttribute(context, each.getKey(), each.getValue());
        }
    }

    public void enableClangFeature(@NotNull OCInclusionContext context, @NotNull String feature) {
        this.enableClangFeature(context, feature, "1");
    }

    public void enableClangExtension(@NotNull OCInclusionContext context, @NotNull String extension) {
        this.enableClangExtension(context, extension, "1");
    }

    public void enableClangAttribute(@NotNull OCInclusionContext context, @NotNull String attribute) {
        this.enableClangAttribute(context, attribute, "1");
    }

    public void enableClangFeature(@NotNull OCInclusionContext context, @NotNull String feature, @NotNull String value2) {
        context.localDefine(OCCompilerMacros.clangFeature(feature), value2);
    }

    public void enableClangExtension(@NotNull OCInclusionContext context, @NotNull String extension, @NotNull String value2) {
        context.localDefine(OCCompilerMacros.clangExtension(extension), value2);
    }

    public void enableClangAttribute(@NotNull OCInclusionContext context, @NotNull String attribute, @NotNull String value2) {
        context.localDefine(OCCompilerMacros.clangAttribute(attribute), value2);
        if (!attribute.startsWith("__")) {
            context.localDefine(OCCompilerMacros.clangAttribute("__" + attribute + "__"), value2);
        }
    }

    @NotNull
    public static String clangFeature(@NotNull String feature) {
        return "__CIDR_clang__has_feature_" + feature;
    }

    @NotNull
    public static String clangExtension(@NotNull String extension) {
        return "__CIDR_clang__has_extension_" + extension;
    }

    @NotNull
    public static String clangAttribute(@NotNull String extension) {
        return "__CIDR_clang__has_attribute_" + extension;
    }

    static {
        StringBuilder result2 = new StringBuilder(STANDARD_MACROS);
        for (String macro : OCCompilerFeatures.FAKE_BUILT_INS.values()) {
            result2.append("\n").append(macro);
        }
        result2.append("\n");
        PREDEFINED_MACROS = result2.toString();
    }
}

