/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRootProcessor;
import com.jetbrains.cidr.lang.workspace.headerRoots.RealFramework;
import com.jetbrains.cidr.modulemap.resolve.ModuleMapResolveUtil;
import com.jetbrains.cidr.modulemap.symbols.ModuleMapFileSymbol;
import com.jetbrains.cidr.modulemap.symbols.ModuleMapModuleSymbol;
import icons.CidrLangIcons;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AppleFramework
extends HeadersSearchRoot {
    public static boolean SORTED_ITERATION = ApplicationManager.getApplication().isUnitTestMode();
    public static final String HEADERS_DIR_NAME = "Headers";
    public static final String PRIVATE_HEADERS_DIR_NAME = "PrivateHeaders";
    public static final String MODULES_DIR_NAME = "Modules";
    public static final String FRAMEWORKS_DIR_NAME = "Frameworks";
    public static final String[] HEADERS_DIR_NAMES = new String[]{"Headers", "PrivateHeaders"};
    @NotNull
    private final String myName;
    static final Condition<VirtualFile> FRAMEWORK_CONDITION = file2 -> file2.isDirectory() && file2.getName().endsWith(".framework");
    private static final Comparator<VirtualFile> FILE_NAME_COMPARATOR = (f1, f2) -> f1.getName().compareTo(f2.getName());

    protected AppleFramework(@NotNull Project project2, @NotNull String name) {
        super(project2);
        this.myName = name;
    }

    @Override
    @NotNull
    public String getName() {
        return this.myName;
    }

    @Nullable
    public abstract PsiFileSystemItem getParentSdkOrFrameworkItem();

    public boolean isLibrary() {
        return false;
    }

    @Nullable
    public VirtualFile getMainFile() {
        ModuleMapModuleSymbol module2 = this.getMainFrameworkModule();
        if (module2 != null) {
            return ModuleMapResolveUtil.getUmbrellaHeader(module2);
        }
        return null;
    }

    @NotNull
    public List<VirtualFile> getPublicHeadersToInclude() {
        ModuleMapModuleSymbol module2 = this.getMainFrameworkModule();
        if (module2 != null) {
            return ModuleMapResolveUtil.getIncludeHeaders(module2);
        }
        return ContainerUtil.createMaybeSingletonList((Object)this.getMainFile());
    }

    @Nullable
    protected ModuleMapModuleSymbol getMainFrameworkModule() {
        ModuleMapFileSymbol moduleMap = this.getModuleMap();
        return moduleMap != null ? moduleMap.findModule(this.getName()) : null;
    }

    public abstract boolean containsHeader(@Nullable VirtualFile var1);

    public boolean process(@NotNull PsiElementProcessor<PsiFileSystemItem> processor2, @NotNull Set<String> processed2) {
        if (!processed2.add(this.getName())) {
            return true;
        }
        if (processor2 instanceof HeadersSearchRootProcessor) {
            return this.processChildren(processor2);
        }
        return AppleFramework.processFileSystemItem(processor2, this);
    }

    public static boolean processFrameworksUnder(@NotNull PsiFileSystemItem parentSdkOrFramework, @Nullable VirtualFile root, @NotNull PsiElementProcessor<PsiFileSystemItem> processor2, @NotNull Set<String> processed2) {
        if (root != null && root.isDirectory()) {
            List frameworks = ContainerUtil.filter((Object[])root.getChildren(), FRAMEWORK_CONDITION);
            if (SORTED_ITERATION) {
                Collections.sort(frameworks, FILE_NAME_COMPARATOR);
            }
            for (VirtualFile frameworkPath : frameworks) {
                RealFramework framework = new RealFramework(parentSdkOrFramework.getProject(), frameworkPath, parentSdkOrFramework);
                if (framework.process(processor2, processed2)) continue;
                return false;
            }
        }
        return true;
    }

    public Icon getIcon(int flags) {
        return CidrLangIcons.Framework;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AppleFramework framework = (AppleFramework)((Object)o);
        return this.myName.equals(framework.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }
}

