/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.NullVirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.modulemap.psi.ModuleMapFile;
import com.jetbrains.cidr.modulemap.psi.impl.ModuleMapFileImpl;
import com.jetbrains.cidr.modulemap.resolve.ModuleMapInCollectionPathResolver;
import com.jetbrains.cidr.modulemap.resolve.ModuleMapPathResolver;
import com.jetbrains.cidr.modulemap.symbols.ModuleMapFileSymbol;
import com.jetbrains.cidr.modulemap.symbols.ModuleMapSymbolBuilder;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomHeadersRoot
extends HeadersSearchRoot {
    @Nullable
    private final VirtualFile myRoot;
    @NotNull
    private final VirtualFile[] myFilesCache;
    private final int myHashCodeCache;

    public CustomHeadersRoot(@NotNull Project project2, @Nullable VirtualFile root, @NotNull Collection<VirtualFile> files) {
        super(project2);
        this.myRoot = root;
        this.myFilesCache = files.toArray(new VirtualFile[files.size()]);
        Arrays.sort(this.myFilesCache, (o1, o2) -> FileUtil.comparePaths((String)o1.getPath(), (String)o2.getPath()));
        this.myHashCodeCache = Arrays.hashCode(this.myFilesCache);
    }

    public VirtualFile getVirtualFile() {
        return this.myRoot;
    }

    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor2) {
        return this.processCustomFileSet(processor2, Arrays.asList(this.myFilesCache), false);
    }

    @Override
    @NotNull
    protected ModuleMapPathResolver createModuleMapPathResolver() {
        return new ModuleMapInCollectionPathResolver((VirtualFile)(this.myRoot == null ? NullVirtualFile.INSTANCE : this.myRoot), Arrays.asList(this.myFilesCache));
    }

    @Override
    @Nullable
    protected ModuleMapFileSymbol buildModuleMap() {
        VirtualFile virtualFile = (VirtualFile)ContainerUtil.find((Object[])this.myFilesCache, file2 -> FileUtil.pathsEqual((String)"module.modulemap", (String)file2.getName()));
        if (virtualFile == null) {
            virtualFile = (VirtualFile)ContainerUtil.find((Object[])this.myFilesCache, file2 -> FileUtil.pathsEqual((String)"module.map", (String)file2.getName()));
        }
        if (virtualFile == null) {
            return null;
        }
        try {
            String text = VfsUtilCore.loadText((VirtualFile)virtualFile);
            ModuleMapFile moduleMapFile = ModuleMapFileImpl.createFromText(text, PsiManager.getInstance((Project)this.myProject));
            return new ModuleMapSymbolBuilder(this.myProject, this.createModuleMapPathResolver()).processFile(moduleMapFile);
        }
        catch (IOException e) {
            OCLog.LOG.error("Failed to read module map from " + virtualFile, (Throwable)e);
            return null;
        }
    }

    public String toString() {
        return this.getName() + ", size: " + this.myFilesCache.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CustomHeadersRoot root = (CustomHeadersRoot)((Object)o);
        return this.myHashCodeCache == root.myHashCodeCache && Arrays.equals(this.myFilesCache, root.myFilesCache);
    }

    public int hashCode() {
        return this.myHashCodeCache;
    }
}

