/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.SyntheticFileSystemItem;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SpecificNameItemProcessor;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.workspace.headerRoots.FrameworksSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRootProcessor;
import com.jetbrains.cidr.lang.workspace.headerRoots.IncludedFilesProcessor;
import com.jetbrains.cidr.lang.workspace.headerRoots.IncludedHeadersRoot;
import com.jetbrains.cidr.modulemap.ModuleMapModules;
import com.jetbrains.cidr.modulemap.ModuleMapModulesImpl;
import com.jetbrains.cidr.modulemap.psi.ModuleMapFile;
import com.jetbrains.cidr.modulemap.psi.impl.ModuleMapFileImpl;
import com.jetbrains.cidr.modulemap.resolve.ModuleMapPathResolver;
import com.jetbrains.cidr.modulemap.symbols.ModuleMapCache;
import com.jetbrains.cidr.modulemap.symbols.ModuleMapDiskCache;
import com.jetbrains.cidr.modulemap.symbols.ModuleMapFileSymbol;
import com.jetbrains.cidr.modulemap.symbols.ModuleMapSymbolBuilder;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HeadersSearchRoot
extends SyntheticFileSystemItem {
    @Nullable
    public static HeadersSearchRoot createFromHeaderSearchPath(@NotNull Project project2, @NotNull HeadersSearchPath searchPath) {
        VirtualFile headersDir = LocalFileSystem.getInstance().findFileByIoFile(searchPath.getFile());
        if (headersDir == null || !headersDir.isDirectory()) {
            return null;
        }
        return searchPath.isFrameworksSearchPath() ? new FrameworksSearchRoot(project2, headersDir) : new IncludedHeadersRoot(project2, headersDir, searchPath.isRecursive(), searchPath.isUserHeaders());
    }

    public HeadersSearchRoot(Project project2) {
        super(project2);
    }

    public PsiFileSystemItem getParent() {
        return null;
    }

    @NotNull
    public ModuleMapModules collectDeclaredModules() {
        ModuleMapModulesImpl result2 = new ModuleMapModulesImpl();
        this.getPossibleModuleMapLocations().forEach(root -> {
            ModuleMapFileSymbol map2 = root.getModuleMap();
            if (map2 != null) {
                result2.add(map2.getAllModulesRecursively());
            }
        });
        return result2.isEmpty() ? ModuleMapModules.Companion.getEMPTY() : result2;
    }

    @NotNull
    public Collection<? extends HeadersSearchRoot> getPossibleModuleMapLocations() {
        return Collections.singletonList(this);
    }

    @Nullable
    public ModuleMapFileSymbol getModuleMap() {
        ModuleMapCache.Key cacheKey;
        ModuleMapCache moduleMapCache = ModuleMapCache.getInstance(this.myProject);
        ModuleMapFileSymbol moduleMap = moduleMapCache.get(cacheKey = ModuleMapCache.Key.create(this));
        if (moduleMap == null) {
            ModuleMapDiskCache moduleMapDiskCache = ModuleMapDiskCache.getInstance();
            moduleMap = moduleMapDiskCache.getModuleMap(this);
            if (moduleMap == null) {
                moduleMap = this.buildModuleMap();
                moduleMapDiskCache.cache(this, moduleMap);
            }
            moduleMap = moduleMapCache.cacheOrGet(cacheKey, moduleMap);
        }
        return moduleMap == ModuleMapFileSymbol.Companion.getEMPTY() ? null : moduleMap;
    }

    @Nullable
    protected ModuleMapFileSymbol buildModuleMap() {
        File moduleMapFile = this.findModuleMapFile();
        ModuleMapFileSymbol moduleMap = null;
        if (moduleMapFile != null && moduleMapFile.isFile()) {
            try {
                ModuleMapFile file2 = ModuleMapFileImpl.createFromText(FileUtil.loadFile((File)moduleMapFile), PsiManager.getInstance((Project)this.myProject));
                moduleMap = new ModuleMapSymbolBuilder(this.myProject, this.createModuleMapPathResolver()).processFile(file2);
            }
            catch (IOException e) {
                OCLog.LOG.info("IOException reading module map at path " + moduleMapFile.getPath(), (Throwable)e);
            }
        }
        return moduleMap;
    }

    @NotNull
    protected ModuleMapPathResolver createModuleMapPathResolver() {
        throw new IllegalStateException("createModuleMapPathResolver() is not implemented for a HeadersSearchRoot with findModuleMapFile() implemented");
    }

    @Nullable
    protected File findModuleMapFile() {
        return null;
    }

    public boolean isUserHeaders() {
        return false;
    }

    protected boolean processUnder(@NotNull PsiElementProcessor<PsiFileSystemItem> processor2, @Nullable VirtualFile base) {
        return this.processUnder(processor2, base, null);
    }

    protected boolean processUnder(@NotNull PsiElementProcessor<PsiFileSystemItem> processor2, @Nullable VirtualFile base, @Nullable Condition<VirtualFile> condition2) {
        return this.processUnder(processor2, base, false, condition2);
    }

    protected boolean processUnder(@NotNull PsiElementProcessor<PsiFileSystemItem> processor2, @Nullable VirtualFile base, boolean recursive, @Nullable Condition<VirtualFile> condition2) {
        if (base == null) {
            return true;
        }
        if (IncludedFilesProcessor.shouldSkip(base)) {
            return true;
        }
        if (processor2 instanceof HeadersSearchRootProcessor) {
            if (!IncludedFilesProcessor.processFile(this.myProject, base, condition2, processor2)) {
                return false;
            }
            if (((HeadersSearchRootProcessor)processor2).shouldProcessRootsOnly()) {
                return true;
            }
        }
        if (processor2 instanceof SpecificNameItemProcessor) {
            String name = ((SpecificNameItemProcessor)processor2).getName();
            VirtualFile file2 = base.findChild(name);
            return file2 == null || IncludedFilesProcessor.processFile(this.myProject, file2, condition2, processor2);
        }
        VirtualFile[] children2 = base.getChildren();
        return children2 == null || IncludedFilesProcessor.processFiles(this.myProject, Arrays.asList(children2), condition2, recursive, processor2);
    }

    protected boolean processCustomFileSet(@NotNull PsiElementProcessor<PsiFileSystemItem> processor2, @NotNull Iterable<VirtualFile> files, boolean recursive) {
        return IncludedFilesProcessor.processFiles(this.myProject, files, null, recursive, processor2);
    }
}

