/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.PsiElementProcessor;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.modulemap.resolve.ModuleMapDefaultPathResolver;
import com.jetbrains.cidr.modulemap.resolve.ModuleMapPathResolver;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class IncludedHeadersRoot
extends HeadersSearchRoot {
    @NotNull
    private final VirtualFile myIncludedDir;
    private final boolean myRecursive;
    private final boolean myUserHeaders;

    public IncludedHeadersRoot(@NotNull Project project2, @NotNull VirtualFile includedDir, boolean recursive, boolean userHeaders) {
        super(project2);
        this.myIncludedDir = includedDir;
        this.myRecursive = recursive;
        this.myUserHeaders = userHeaders;
    }

    @Override
    @NotNull
    public String getName() {
        return "Included Headers";
    }

    public VirtualFile getVirtualFile() {
        return this.myIncludedDir;
    }

    @Override
    @NotNull
    protected ModuleMapPathResolver createModuleMapPathResolver() {
        return new ModuleMapDefaultPathResolver(this.myIncludedDir);
    }

    @Override
    @NotNull
    protected File findModuleMapFile() {
        File file2 = new File(this.myIncludedDir.getPath(), "module.modulemap");
        if (!file2.exists()) {
            file2 = new File(this.myIncludedDir.getPath(), "module.map");
        }
        return file2;
    }

    public boolean isRecursive() {
        return this.myRecursive;
    }

    @Override
    public boolean isUserHeaders() {
        return this.myUserHeaders;
    }

    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor2) {
        return this.processUnder(processor2, this.myIncludedDir, this.myRecursive, null);
    }

    public String toString() {
        return this.getName() + " @ " + this.myIncludedDir + ": " + (this.myUserHeaders ? "user" : "system") + (this.myRecursive ? " [recursive]" : "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        IncludedHeadersRoot root = (IncludedHeadersRoot)((Object)o);
        if (this.myRecursive != root.myRecursive) {
            return false;
        }
        if (this.myUserHeaders != root.myUserHeaders) {
            return false;
        }
        return this.myIncludedDir.equals(root.myIncludedDir);
    }

    public int hashCode() {
        int result2 = this.myIncludedDir.hashCode();
        result2 = 31 * result2 + (this.myRecursive ? 1 : 0);
        result2 = 31 * result2 + (this.myUserHeaders ? 1 : 0);
        return result2;
    }
}

