/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.PsiElementProcessor;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRootProcessor;
import com.jetbrains.cidr.modulemap.resolve.ModuleMapPathResolver;
import com.jetbrains.cidr.modulemap.resolve.ModuleMapRealFrameworkPathResolver;
import com.jetbrains.cidr.modulemap.symbols.ModuleMapFileSymbol;
import com.jetbrains.cidr.modulemap.symbols.ModuleMapModuleSymbol;
import com.jetbrains.cidr.modulemap.symbols.ModuleMapSymbolBuilder;
import gnu.trove.THashSet;
import java.io.File;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RealFramework
extends AppleFramework {
    @Nullable
    private final PsiFileSystemItem myParent;
    @NotNull
    private final VirtualFile myBaseFile;

    public RealFramework(@NotNull Project project2, @NotNull VirtualFile baseFile, @Nullable PsiFileSystemItem parentSdkOrFramework) {
        super(project2, baseFile.getNameWithoutExtension());
        this.myParent = parentSdkOrFramework;
        this.myBaseFile = baseFile;
    }

    @Override
    @Nullable
    public PsiFileSystemItem getParent() {
        return this.myManager.findDirectory(this.myBaseFile);
    }

    @Override
    @NotNull
    public ModuleMapFileSymbol getModuleMap() {
        return super.getModuleMap();
    }

    @Override
    @NotNull
    protected ModuleMapFileSymbol buildModuleMap() {
        ModuleMapFileSymbol moduleMap = super.buildModuleMap();
        if (moduleMap == null) {
            moduleMap = new ModuleMapSymbolBuilder(this.myProject, this.createModuleMapPathResolver()).buildLegacy(this.myBaseFile.getNameWithoutExtension());
        }
        return moduleMap;
    }

    @Override
    @NotNull
    protected ModuleMapPathResolver createModuleMapPathResolver() {
        return new ModuleMapRealFrameworkPathResolver(this.myBaseFile);
    }

    @Override
    @Nullable
    protected File findModuleMapFile() {
        File moduleMapFile = null;
        File modulesDir = new File(this.myBaseFile.getPath(), "Modules");
        if (modulesDir.exists() && modulesDir.isDirectory()) {
            moduleMapFile = new File(modulesDir, "module.modulemap");
        }
        if (moduleMapFile == null || !moduleMapFile.exists()) {
            moduleMapFile = new File(this.myBaseFile.getPath(), "module.map");
        }
        if (!moduleMapFile.exists()) {
            moduleMapFile = null;
        }
        return moduleMapFile;
    }

    @Override
    @Nullable
    public PsiFileSystemItem getParentSdkOrFrameworkItem() {
        return this.myParent;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        return this.myBaseFile;
    }

    @Override
    public boolean containsHeader(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return false;
        }
        ModuleMapModuleSymbol module2 = this.getMainFrameworkModule();
        if (module2 == null) {
            return false;
        }
        return module2.getPathResolver().containsHeader(file2);
    }

    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor2) {
        if (this.myBaseFile.isValid()) {
            if (processor2 instanceof HeadersSearchRootProcessor && !((HeadersSearchRootProcessor)processor2).processFramework(this)) {
                return false;
            }
            for (String eachDir : HEADERS_DIR_NAMES) {
                if (this.processUnder(processor2, this.myBaseFile.findChild(eachDir))) continue;
                return false;
            }
            if (!RealFramework.processFrameworksUnder(this, this.myBaseFile.findChild("Frameworks"), processor2, (Set<String>)new THashSet())) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RealFramework framework = (RealFramework)((Object)o);
        if (!this.myBaseFile.equals(framework.myBaseFile)) {
            return false;
        }
        return !(this.myParent != null ? !this.myParent.equals(framework.myParent) : framework.myParent != null);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.myParent != null ? this.myParent.hashCode() : 0);
        result2 = 31 * result2 + this.myBaseFile.hashCode();
        return result2;
    }

    public String toString() {
        return "AppleFramework: [" + this.getName() + ": " + this.myBaseFile.getPath() + "]";
    }
}

