/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.modulemap.resolve;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import com.jetbrains.cidr.modulemap.resolve.ModuleMapPathResolver;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\fH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/modulemap/resolve/ModuleMapRealFrameworkPathResolver;", "Lcom/jetbrains/cidr/modulemap/resolve/ModuleMapPathResolver;", "frameworkRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "getFrameworkRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "containsHeader", "", "file", "derive", "moduleName", "", "isFramework", "getContainingHeaderRoot", "getRelativeHeaderPath", "resolveDir", "relativePath", "resolveHeader", "Companion", "cidr-lang"})
public final class ModuleMapRealFrameworkPathResolver
implements ModuleMapPathResolver {
    @NotNull
    private final VirtualFile frameworkRoot;
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public VirtualFile resolveHeader(@NotNull String relativePath) {
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        return this.frameworkRoot.findFileByRelativePath("Headers/" + relativePath);
    }

    @Override
    @Nullable
    public VirtualFile resolveDir(@NotNull String relativePath) {
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        return this.frameworkRoot.findFileByRelativePath(relativePath);
    }

    @Override
    public boolean containsHeader(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return this.getContainingHeaderRoot(file2) != null;
    }

    @Override
    @Nullable
    public String getRelativeHeaderPath(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        VirtualFile virtualFile = this.getContainingHeaderRoot(file2);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile root = virtualFile;
        return VfsUtilCore.getRelativePath((VirtualFile)file2, (VirtualFile)root);
    }

    @Override
    @NotNull
    public ModuleMapPathResolver derive(@NotNull String moduleName, boolean isFramework) {
        Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
        if (isFramework) {
            VirtualFile derivedFramework;
            VirtualFile virtualFile = this.frameworkRoot.findFileByRelativePath("Frameworks");
            VirtualFile virtualFile2 = derivedFramework = virtualFile != null ? virtualFile.findFileByRelativePath(moduleName + ".framework") : null;
            if (derivedFramework != null) {
                return new ModuleMapRealFrameworkPathResolver(derivedFramework);
            }
        }
        return this;
    }

    private final VirtualFile getContainingHeaderRoot(VirtualFile file2) {
        String[] stringArray = AppleFramework.HEADERS_DIR_NAMES;
        for (int j = 0; j < stringArray.length; ++j) {
            String each = stringArray[j];
            VirtualFile headers = this.frameworkRoot.findChild(each);
            if (headers == null || !VfsUtilCore.isAncestor((VirtualFile)headers, (VirtualFile)file2, (boolean)true)) continue;
            return headers;
        }
        return null;
    }

    @NotNull
    public final VirtualFile getFrameworkRoot() {
        return this.frameworkRoot;
    }

    public ModuleMapRealFrameworkPathResolver(@NotNull VirtualFile frameworkRoot) {
        Intrinsics.checkParameterIsNotNull((Object)frameworkRoot, (String)"frameworkRoot");
        this.frameworkRoot = frameworkRoot;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/cidr/modulemap/resolve/ModuleMapRealFrameworkPathResolver$Companion;", "", "()V", "createUninitialized", "Lcom/jetbrains/cidr/modulemap/resolve/ModuleMapRealFrameworkPathResolver;", "cidr-lang"})
    public static final class Companion {
        @NotNull
        public final ModuleMapRealFrameworkPathResolver createUninitialized() {
            return new ModuleMapRealFrameworkPathResolver((VirtualFile)new LightVirtualFile());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

