/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.modulemap.resolve;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.modulemap.symbols.ModuleMapModuleSymbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleMapResolveUtil {
    @NotNull
    public static List<VirtualFile> getIncludeHeaders(@NotNull ModuleMapModuleSymbol module2) {
        ArrayList result2 = ContainerUtil.newArrayList();
        VirtualFile umbrellaFile = ModuleMapResolveUtil.getUmbrellaHeader(module2);
        if (umbrellaFile != null) {
            ContainerUtil.addAll((Collection)result2, (Object[])new VirtualFile[]{umbrellaFile});
        } else {
            VirtualFile umbrellaDir;
            String umbrellaDirName = module2.getUmbrellaDir();
            if (umbrellaDirName != null && (umbrellaDir = module2.getPathResolver().resolveDir(umbrellaDirName)) != null) {
                ContainerUtil.addAll((Collection)result2, (Object[])umbrellaDir.getChildren());
            }
        }
        ContainerUtil.addAll((Collection)result2, (Iterable)ContainerUtil.mapNotNull(module2.getHeaders(), headerName -> module2.getPathResolver().resolveHeader((String)headerName)));
        if (!result2.isEmpty()) {
            return Collections.unmodifiableList(result2);
        }
        return Collections.emptyList();
    }

    @Nullable
    public static VirtualFile getUmbrellaHeader(@NotNull ModuleMapModuleSymbol module2) {
        String umbrellaHeader = module2.getUmbrellaHeader();
        if (umbrellaHeader != null) {
            return module2.getPathResolver().resolveHeader(umbrellaHeader);
        }
        return null;
    }
}

