/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.modulemap.symbols;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.PsiElementProcessor;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.IncludedHeadersRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.RealFramework;
import com.jetbrains.cidr.modulemap.ModuleMapLog;
import com.jetbrains.cidr.modulemap.psi.ModuleMapFile;
import com.jetbrains.cidr.modulemap.symbols.ModuleMapFileSymbol;
import com.jetbrains.cidr.modulemap.symbols.ModuleMapSerializer;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\t\u001a\u0004\u0018\u00010\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/modulemap/symbols/ModuleMapDiskCache;", "", "()V", "mySerializer", "Lcom/jetbrains/cidr/modulemap/symbols/ModuleMapSerializer;", "cache", "Lcom/jetbrains/cidr/modulemap/symbols/ModuleMapFileSymbol;", "root", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchRoot;", "moduleMap", "calculateHashCode", "", "deserializeModuleMap", "inputStream", "Ljava/io/InputStream;", "getModuleMap", "serializeModuleMap", "", "outputStream", "Ljava/io/OutputStream;", "Companion", "cidr-lang"})
public final class ModuleMapDiskCache {
    private final ModuleMapSerializer mySerializer = new ModuleMapSerializer();
    private static final int SERIALIZATION_VERSION = 163001;
    private static final String TABLES_KEY_PREFIX = "clang_module_map_attribute";
    private static final FileAttribute ourFileCacheAttribute;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final ModuleMapFileSymbol cache(@NotNull HeadersSearchRoot root, @Nullable ModuleMapFileSymbol moduleMap) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)root), (String)"root");
        ModuleMapDiskCache moduleMapDiskCache = this;
        synchronized (moduleMapDiskCache) {
            VirtualFile virtualFile;
            block16: {
                block15: {
                    if (root instanceof IncludedHeadersRoot || root instanceof RealFramework) break block15;
                    ModuleMapFileSymbol moduleMapFileSymbol = null;
                    return moduleMapFileSymbol;
                }
                virtualFile = root.getVirtualFile();
                if (virtualFile.isValid()) break block16;
                ModuleMapFileSymbol moduleMapFileSymbol = null;
                return moduleMapFileSymbol;
            }
            Closeable closeable = ModuleMapDiskCache.Companion.getOurFileCacheAttribute().writeAttribute(virtualFile);
            boolean bl = false;
            try {
                DataOutputStream it;
                DataOutputStream dataOutputStream = it = (DataOutputStream)closeable;
                Intrinsics.checkExpressionValueIsNotNull((Object)dataOutputStream, (String)"it");
                boolean bl2 = this.serializeModuleMap(root, dataOutputStream, moduleMap);
            }
            catch (Exception exception) {
                bl = true;
                try {
                    Closeable closeable2 = closeable;
                    if (closeable2 != null) {
                        closeable2.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            finally {
                if (!bl) {
                    Closeable closeable3 = closeable;
                    if (closeable3 != null) {
                        closeable3.close();
                    }
                }
            }
            ModuleMapFileSymbol moduleMapFileSymbol = moduleMap;
            return moduleMapFileSymbol;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final ModuleMapFileSymbol getModuleMap(@NotNull HeadersSearchRoot root) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)root), (String)"root");
        ModuleMapDiskCache moduleMapDiskCache = this;
        synchronized (moduleMapDiskCache) {
            ModuleMapFileSymbol moduleMapFileSymbol;
            if (!(root instanceof IncludedHeadersRoot) && !(root instanceof RealFramework)) {
                return null;
            }
            VirtualFile virtualFile = root.getVirtualFile();
            if (!virtualFile.isValid()) {
                return null;
            }
            DataInputStream dataInputStream = ModuleMapDiskCache.Companion.getOurFileCacheAttribute().readAttribute(virtualFile);
            if (dataInputStream == null) {
                return null;
            }
            Closeable closeable = dataInputStream;
            boolean bl = false;
            try {
                DataInputStream it;
                DataInputStream dataInputStream2 = it = (DataInputStream)closeable;
                Intrinsics.checkExpressionValueIsNotNull((Object)dataInputStream2, (String)"it");
                ModuleMapFileSymbol moduleMapFileSymbol2 = this.deserializeModuleMap(root, dataInputStream2);
                moduleMapFileSymbol = moduleMapFileSymbol2;
            }
            catch (Exception exception) {
                bl = true;
                try {
                    Closeable closeable2 = closeable;
                    if (closeable2 == null) throw (Throwable)exception;
                    closeable2.close();
                    throw (Throwable)exception;
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            return moduleMapFileSymbol;
            finally {
                if (!bl) {
                    Closeable closeable3 = closeable;
                    if (closeable3 != null) {
                        closeable3.close();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean serializeModuleMap(HeadersSearchRoot root, OutputStream outputStream, ModuleMapFileSymbol moduleMap) {
        ModuleMapLog.LOG.debug("Serialize Module Map for " + (Object)((Object)root));
        DataOutputStream dos = new DataOutputStream(outputStream);
        try {
            dos.writeLong(this.calculateHashCode(root));
            ModuleMapFileSymbol moduleMapFileSymbol = moduleMap;
            if (moduleMapFileSymbol == null) {
                moduleMapFileSymbol = ModuleMapFileSymbol.Companion.getEMPTY();
            }
            boolean bl = this.mySerializer.writeModuleMap(dos, moduleMapFileSymbol);
            return bl;
        }
        catch (IOException e) {
            ModuleMapLog.LOG.warn("Failed to serialize Module Map for " + (Object)((Object)root), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            StreamUtil.closeStream((Closeable)dos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ModuleMapFileSymbol deserializeModuleMap(HeadersSearchRoot root, InputStream inputStream) {
        ModuleMapLog.LOG.debug("Deserialize Module Map for " + (Object)((Object)root));
        DataInputStream dis = new DataInputStream(inputStream);
        if (dis.available() == 0) {
            return null;
        }
        try {
            if (dis.readLong() != this.calculateHashCode(root)) {
                ModuleMapFileSymbol moduleMapFileSymbol = null;
                return moduleMapFileSymbol;
            }
            ModuleMapFileSymbol moduleMapFileSymbol = this.mySerializer.readModuleMap(dis);
            return moduleMapFileSymbol;
        }
        catch (IOException e) {
            ModuleMapLog.LOG.warn("Failed to deserialize Module Map for " + (Object)((Object)root), (Throwable)e);
            ModuleMapFileSymbol moduleMapFileSymbol = null;
            return moduleMapFileSymbol;
        }
        finally {
            StreamUtil.closeStream((Closeable)dis);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final long calculateHashCode(HeadersSearchRoot root) {
        void hash;
        ModuleMapLog.LOG.debug("Calculate Hash Code for " + (Object)((Object)root));
        Ref.LongRef longRef = new Ref.LongRef();
        longRef.element = 0L;
        root.processChildren((PsiElementProcessor)new PsiElementProcessor<PsiFileSystemItem>((Ref.LongRef)hash){
            final /* synthetic */ Ref.LongRef $hash;

            public final boolean execute(@NotNull PsiFileSystemItem element) {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                if (element instanceof OCFile || element instanceof ModuleMapFile) {
                    this.$hash.element += element.getVirtualFile().getTimeStamp();
                }
                return true;
            }
            {
                this.$hash = longRef;
            }
        });
        return hash.element;
    }

    static {
        Companion = new Companion(null);
        ourFileCacheAttribute = new FileAttribute(TABLES_KEY_PREFIX, 163001, false);
    }

    @JvmStatic
    @NotNull
    public static final ModuleMapDiskCache getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/modulemap/symbols/ModuleMapDiskCache$Companion;", "", "()V", "SERIALIZATION_VERSION", "", "TABLES_KEY_PREFIX", "", "ourFileCacheAttribute", "Lcom/intellij/openapi/vfs/newvfs/FileAttribute;", "getOurFileCacheAttribute", "()Lcom/intellij/openapi/vfs/newvfs/FileAttribute;", "getInstance", "Lcom/jetbrains/cidr/modulemap/symbols/ModuleMapDiskCache;", "cidr-lang"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ModuleMapDiskCache getInstance() {
            Object object = ServiceManager.getService(ModuleMapDiskCache.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getServic\u2026MapDiskCache::class.java)");
            return (ModuleMapDiskCache)object;
        }

        private final FileAttribute getOurFileCacheAttribute() {
            return ourFileCacheAttribute;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

