/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.projectView;

import com.intellij.ide.SelectInTarget;
import com.intellij.ide.impl.ProjectViewSelectInTarget;
import com.intellij.ide.projectView.impl.AbstractProjectViewPSIPane;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationListener;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public abstract class CidrView
extends AbstractProjectViewPSIPane {
    public CidrView(Project project2) {
        super(project2);
        project2.getMessageBus().connect().subscribe(OCWorkspaceModificationListener.TOPIC, (Object)new OCWorkspaceModificationListener(){

            @Override
            public void projectsChanged() {
                this.somethingChanged();
            }

            @Override
            public void projectFilesChanged() {
                this.somethingChanged();
            }

            @Override
            public void sourceFilesChanged() {
                this.somethingChanged();
            }

            @Override
            public void buildSettingsChanged() {
                this.somethingChanged();
            }

            @Override
            public void selectedResolveConfigurationChanged() {
                this.somethingChanged();
            }

            @Override
            public void buildFinished() {
                this.somethingChanged();
            }

            void somethingChanged() {
                CidrView.this.queueUpdate();
            }
        });
    }

    protected void queueUpdate() {
        AbstractTreeBuilder builder = this.getTreeBuilder();
        if (builder != null) {
            builder.queueUpdate();
        }
    }

    @Override
    protected AbstractTreeUpdater createTreeUpdater(AbstractTreeBuilder treeBuilder) {
        return new AbstractTreeUpdater(treeBuilder);
    }

    @Override
    public SelectInTarget createSelectInTarget() {
        return new ProjectViewSelectInTarget(this.myProject){

            @Override
            public String toString() {
                return CidrView.this.getTitle();
            }

            public String getMinorViewId() {
                return CidrView.this.getId();
            }

            public float getWeight() {
                return CidrView.this.getWeight();
            }
        };
    }

    @Override
    @NotNull
    public PsiDirectory[] getSelectedDirectories() {
        PsiDirectory[] directories = super.getSelectedDirectories();
        if (directories.length > 0) {
            return directories;
        }
        PsiElement[] elements = this.getSelectedPSIElements();
        ArrayList<PsiDirectory> result2 = new ArrayList<PsiDirectory>();
        for (PsiElement element : elements) {
            PsiDirectory containingDirectory;
            if (element instanceof PsiDirectory) {
                result2.add((PsiDirectory)element);
                continue;
            }
            PsiFile containingFile = element.getContainingFile();
            if (containingFile == null || (containingDirectory = containingFile.getContainingDirectory()) == null) continue;
            result2.add(containingDirectory);
        }
        return result2.toArray(new PsiDirectory[result2.size()]);
    }
}

