/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.toolchains;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.Function;
import com.jetbrains.cidr.CidrLog;
import com.jetbrains.cidr.toolchains.CidrCompiler;
import com.jetbrains.cidr.toolchains.CidrExecutableTool;
import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrCompilerBase
extends CidrExecutableTool
implements CidrCompiler {
    protected static final int COMPILER_TIMEOUT = 30000;
    private static final CompilerRunner DEFAULT_RUNNER;
    @NotNull
    protected static volatile CompilerRunner outCompilerRunner;
    @NotNull
    protected final File myWorkingDirectory;

    public static void setCompilerRunnerInTests(@Nullable CompilerRunner runner) {
        outCompilerRunner = runner == null ? DEFAULT_RUNNER : runner;
    }

    public CidrCompilerBase(@NotNull File executable, @NotNull File workingDirectory) {
        super(executable);
        this.myWorkingDirectory = workingDirectory;
    }

    @Nullable
    protected String doReadVersion(@NotNull List<String> arguments, Function<ProcessOutput, String> versionParser) {
        ProcessOutput output;
        GeneralCommandLine cl = new GeneralCommandLine();
        cl.setExePath(this.getExecutablePath());
        cl.addParameters(arguments);
        try {
            output = outCompilerRunner.run(cl);
            if (output.isTimeout()) {
                throw new ExecutionException("process timed out");
            }
        }
        catch (ExecutionException e) {
            CidrLog.LOG.info("Cannot read compiler version: " + cl.getCommandLineString(), (Throwable)e);
            return null;
        }
        String result2 = (String)versionParser.fun((Object)output);
        if (result2 == null) {
            CidrLog.LOG.info("Cannot read compiler version: " + cl.getCommandLineString() + "\n" + output.getStderr() + "\n" + output.getStdout());
        }
        return result2;
    }

    protected static void checkCompilerOutput(@NotNull ProcessOutput output, @NotNull String userFriendlyCommandLine) throws ExecutionException {
        if (output.isTimeout()) {
            throw CidrCompilerBase.throwCompilerTimeout(userFriendlyCommandLine);
        }
        if (output.getExitCode() != 0) {
            throw CidrCompilerBase.throwCompilerError(output, userFriendlyCommandLine);
        }
    }

    protected static ExecutionException throwCompilerTimeout(@NotNull String userFriendlyCommandLine) throws ExecutionException {
        throw new ExecutionException("Compiler command timed out: " + userFriendlyCommandLine);
    }

    protected static ExecutionException throwCompilerError(@NotNull ProcessOutput output, @NotNull String userFriendlyCommandLine) throws ExecutionException {
        String message2 = "Compiler exited with error code " + output.getExitCode() + ": " + userFriendlyCommandLine + "\n" + output.getStderr() + "\n";
        throw new ExecutionException(message2);
    }

    protected static boolean collectOptionsToSkip(@NotNull List<String> lines, @NotNull Set<String> skipOptions, Pattern ... errorPatterns) {
        boolean hasNewSkipOptions = false;
        block0: for (String eachError : lines) {
            eachError = eachError.trim();
            for (Pattern rule : errorPatterns) {
                Matcher badOptionOrSwitch = rule.matcher(eachError);
                if (!badOptionOrSwitch.matches()) continue;
                hasNewSkipOptions |= skipOptions.add(badOptionOrSwitch.group(1));
                continue block0;
            }
        }
        return hasNewSkipOptions;
    }

    static {
        outCompilerRunner = DEFAULT_RUNNER = new CompilerRunner();
    }

    public static class CompilerRunner {
        @NotNull
        public ProcessOutput run(@NotNull GeneralCommandLine cl) throws ExecutionException {
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator == null) {
                indicator = new EmptyProgressIndicator();
            }
            return new CapturingProcessHandler(cl).runProcessWithProgressIndicator(indicator, 30000, true);
        }
    }
}

