/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.toolchains;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.toolchains.CidrTool;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrToolSet
extends CidrTool {
    protected static final int READ_VERSION_TIMEOUT = 10000;
    @NotNull
    protected final File myHome;

    public CidrToolSet(@NotNull File home) {
        this.myHome = home;
    }

    @NotNull
    public abstract String getName();

    public abstract String checkVersion(@NotNull String var1);

    public boolean isMSVC() {
        return false;
    }

    public boolean isCygwin() {
        return false;
    }

    public boolean isMinGW() {
        return false;
    }

    public boolean isMinGW64() {
        return false;
    }

    @NotNull
    public File getHome() {
        return this.myHome;
    }

    @NotNull
    public String getHomePath() {
        return this.myHome.getPath();
    }

    @Contract(value="null -> null")
    public File getSubFile(@Nullable String relativePath) {
        return relativePath == null ? null : new File(this.myHome, relativePath);
    }

    @Contract(value="null -> null")
    public String getSubFilePath(@Nullable String relativePath) {
        File result2 = this.getSubFile(relativePath);
        return result2 == null ? null : result2.getPath();
    }

    @NotNull
    public abstract File getGDBPath();

    public abstract boolean forceToolSetGDB();

    public void prepareEnvironment(@NotNull GeneralCommandLine cl, @NotNull CidrToolEnvironment.PrepareFor prepareFor, @NotNull List<Option> options) throws ExecutionException {
    }

    protected static void prependPathVariable(@NotNull GeneralCommandLine cl, @NotNull String path) {
        path = FileUtil.toSystemDependentName((String)path);
        THashMap system = new THashMap(cl.getParentEnvironment(), (TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        if (cl.isPassParentEnvironment() && system.containsKey("PATH")) {
            path = path + ";" + (String)system.get("PATH");
        }
        cl.getEnvironment().put("PATH", path);
    }

    public static interface Option {
        @NotNull
        public String getValue();

        public void write(@NotNull Element var1);

        @NotNull
        public String getUniqueID();
    }
}

