/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.toolchains;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrLog;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrSwitchBuilder;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.toolchains.CidrCompilerBase;
import com.jetbrains.cidr.toolchains.CompilerInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GCCCompiler
extends CidrCompilerBase {
    private static final String QUERY_PREFIX = "____CIDR_test_query_";
    private static final Pattern QUERY_RESULT_PATTERN = Pattern.compile("^____CIDR_test_query_(feature|extension|attribute)->([^=]+)=([01])$");
    private static final Pattern UNSUPPORTED_SWITCH_PATTERN = Pattern.compile(".*error:[^\\w-](-+\\S+) is not supported.*");
    private static final Pattern INVALID_SWITCH_PATTERN = Pattern.compile(".*error:.*(?:unrecognized|invalid|unsupported).*[^\\w-](-+\\S+)\\W.*");
    private static final Pattern CPP_OPTIONS_PATTERN = Pattern.compile(".*error:[^\u2018\u2019'\"]*[\u2018\u2019'\"]([^\u2018\u2019'\"]+)[\u2019'\"].*");
    private static final Pattern CPP_FILE_NOT_FOUND_PATTERN = Pattern.compile(".*error:\\s(.+):\\sNo such file or directory");
    private static final Pattern INCLUDE_FILE_PATTERN = Pattern.compile("# 1 \"(.*)\" 1\\s*[\\r\\n]");
    private static final Pattern DEPENDENCY_PATTERN = Pattern.compile(".*:(?:\\s|(?:\\\\[\\r\\n]))*((?:[\\S&&[^\\\\]]+(?:\\\\[ ]?)*)*)");
    private static final Pattern[] BAD_SWITCH_FILTER_RULES = new Pattern[]{INVALID_SWITCH_PATTERN, UNSUPPORTED_SWITCH_PATTERN, CPP_OPTIONS_PATTERN, CPP_FILE_NOT_FOUND_PATTERN};
    public static final String CIDR_IGNORE_DEFINITIONS_START = "___CIDR_IGNORE_DEFINITIONS_START";
    public static final String CIDR_IGNORE_DEFINITIONS_END = "___CIDR_IGNORE_DEFINITIONS_END";

    public static void setGCCErrorInTests(boolean emulate) {
        GCCCompiler.setCompilerRunnerInTests(!emulate ? null : new CidrCompilerBase.CompilerRunner(){

            @Override
            @NotNull
            public ProcessOutput run(@NotNull GeneralCommandLine cl) throws ExecutionException {
                ProcessOutput output = new ProcessOutput(1);
                output.appendStderr("Emulated GCC error");
                return output;
            }
        });
    }

    public GCCCompiler(@NotNull File executable, @NotNull File workingDirectory) {
        super(executable, workingDirectory);
    }

    @Override
    @Nullable
    public String readVersion() {
        return this.doReadVersion(Collections.singletonList("--version"), (Function<ProcessOutput, String>)((Function)output -> {
            List lines = output.getStdoutLines();
            for (String each : lines) {
                if (StringUtil.isEmptyOrSpaces((String)each)) continue;
                return each;
            }
            return null;
        }));
    }

    @NotNull
    public static String getLanguageOption(@NotNull OCLanguageKind kind2) {
        if (kind2 instanceof CLanguageKind) {
            switch ((CLanguageKind)kind2) {
                case C: {
                    return "-xc";
                }
                case OBJ_C: {
                    return "-xobjective-c";
                }
                case CPP: {
                    return "-xc++";
                }
                case OBJ_CPP: {
                    return "-xobjective-c++";
                }
            }
        }
        return "";
    }

    @Override
    @NotNull
    public CompilerInfo collectInfo(@NotNull OCLanguageKind languageKind, @NotNull CidrCompilerSwitches switches, @NotNull CidrToolEnvironment environment) throws ExecutionException {
        switches = new CidrSwitchBuilder().addSingleRaw(GCCCompiler.getLanguageOption(languageKind)).addAll(switches).addSingleRaw("-fpch-preprocess").addSingleRaw("-v").addSingleRaw("-dD").addSingleRaw("-E").addSingleRaw("-D___CIDR_IGNORE_DEFINITIONS_START").build();
        ProcessOutput output = this.runGCC(environment, switches, "#define ___CIDR_IGNORE_DEFINITIONS_END\n" + GCCCompiler.buildFeaturesCheckText());
        String stdout = output.getStdout();
        StringBuilder defines = new StringBuilder();
        int size = OCCompilerFeatures.getAllFeatures().size();
        HashMap<String, String> features = new HashMap<String, String>(size);
        HashMap<String, String> extensions = new HashMap<String, String>(size);
        HashMap<String, String> attributes = new HashMap<String, String>(OCCompilerFeatures.getAllAttributes().size());
        GCCCompiler.collectDefinitionsAndFeatures(stdout, defines, features, extensions, attributes);
        String definesString = defines.toString();
        boolean shouldEnableFrameworksWorkaround = SystemInfo.isMac && !definesString.contains("__clang_version__");
        List<HeadersSearchPath> headersSearchPaths = GCCCompiler.collectHeaderSearchPaths(output, shouldEnableFrameworksWorkaround, environment, this.myWorkingDirectory);
        List<File> precompiledHeaders = this.getPrecompiledHeaders(switches, environment, stdout);
        return new CompilerInfo(definesString, features, extensions, attributes, headersSearchPaths, precompiledHeaders);
    }

    @NotNull
    private List<File> getPrecompiledHeaders(@NotNull CidrCompilerSwitches switches, @NotNull CidrToolEnvironment environment, @NotNull String stdout) {
        LinkedHashSet<File> result2 = new LinkedHashSet<File>(1);
        List<String> args = switches.getList(CidrCompilerSwitches.Format.RAW);
        boolean isFirst = true;
        for (int i2 = 0; i2 < args.size(); ++i2) {
            if (!args.get(i2).equals("-include") || ++i2 >= args.size()) continue;
            String arg = args.get(i2);
            String pathPCH = this.preparePath(environment, arg);
            File pch = new File(pathPCH);
            if (!pch.exists() || pch.isDirectory()) {
                File file2 = pch = isFirst ? this.extractOriginalPrecompiledHeaderFile(stdout, environment, pch) : null;
            }
            if (pch != null) {
                result2.add(pch);
            } else {
                CidrLog.LOG.debug("Cannot find PCH file: " + pathPCH);
            }
            isFirst = false;
        }
        return new SmartList(result2);
    }

    @Nullable
    private File extractOriginalPrecompiledHeaderFile(@NotNull String stdout, @NotNull CidrToolEnvironment env, @NotNull File pch) {
        Matcher matcher;
        int start = stdout.indexOf(CIDR_IGNORE_DEFINITIONS_START);
        int end = stdout.indexOf(CIDR_IGNORE_DEFINITIONS_END);
        if (start >= 0 && end >= 0) {
            stdout = stdout.substring(start + CIDR_IGNORE_DEFINITIONS_START.length(), end);
        }
        if (!stdout.contains("#pragma GCC pch_preprocess") && (matcher = INCLUDE_FILE_PATTERN.matcher(stdout)).find()) {
            String path = this.preparePath(env, matcher.group(1));
            return new File(path);
        }
        File dependencyFile = null;
        if (!pch.isDirectory()) {
            dependencyFile = new File(pch.getAbsolutePath() + ".d");
        } else {
            File[] files = pch.listFiles();
            if (files != null) {
                for (File file2 : files) {
                    if (!file2.getName().endsWith(".d")) continue;
                    dependencyFile = file2;
                    break;
                }
            }
        }
        if (dependencyFile != null && dependencyFile.exists()) {
            try {
                String data = FileUtil.loadFile((File)dependencyFile);
                Matcher dependency = DEPENDENCY_PATTERN.matcher(data);
                if (dependency.find()) {
                    String path = dependency.group(1).replaceAll("\\\\[ ]", " ");
                    File result2 = new File(this.preparePath(env, path));
                    return result2.exists() ? result2 : null;
                }
            }
            catch (IOException e) {
                CidrLog.LOG.warn("Cannot read dependency file: " + dependencyFile, (Throwable)e);
            }
        }
        return null;
    }

    static List<HeadersSearchPath> collectHeaderSearchPaths(ProcessOutput output, boolean enableFrameworksWorkaround, CidrToolEnvironment environment, File workingDirectory) {
        ArrayList<HeadersSearchPath> headersSearchPaths = new ArrayList<HeadersSearchPath>();
        ArrayList<HeadersSearchPath> additionalFrameworks = enableFrameworksWorkaround ? new ArrayList<HeadersSearchPath>() : null;
        Boolean userHeaders = null;
        for (String each : output.getStderrLines()) {
            if ("#include \"...\" search starts here:".equals(each = each.trim())) {
                userHeaders = true;
                continue;
            }
            if ("#include <...> search starts here:".equals(each)) {
                userHeaders = false;
                continue;
            }
            if ("End of search list.".equals(each)) break;
            if (userHeaders == null) continue;
            String trimmed = StringUtil.trimEnd((String)each, (String)" (framework directory)");
            boolean isFramework = false;
            if (!each.equals(trimmed)) {
                each = trimmed;
                isFramework = true;
                enableFrameworksWorkaround = false;
            }
            each = StringUtil.nullize((String)each.trim(), (boolean)true);
            if ((each = environment.toLocalPath(workingDirectory, each)) == null) continue;
            File file2 = new File(FileUtil.toCanonicalPath((String)each, (boolean)true));
            headersSearchPaths.add(new HeadersSearchPath(file2, false, userHeaders, isFramework));
            if (!enableFrameworksWorkaround) continue;
            additionalFrameworks.add(new HeadersSearchPath(file2, false, userHeaders, true));
        }
        if (enableFrameworksWorkaround && additionalFrameworks != null) {
            headersSearchPaths.addAll(additionalFrameworks);
        }
        return headersSearchPaths;
    }

    protected static void collectDefinitionsAndFeatures(@NotNull String output, @NotNull StringBuilder defines, @NotNull Map<String, String> features, @NotNull Map<String, String> extensions, @NotNull Map<String, String> attributes) {
        int ignoreStart;
        for (ignoreStart = output.indexOf(CIDR_IGNORE_DEFINITIONS_START); ignoreStart > 0 && !StringUtil.isLineBreak((char)output.charAt(ignoreStart - 1)); --ignoreStart) {
        }
        int ignoreEnd = output.indexOf(CIDR_IGNORE_DEFINITIONS_END);
        if (ignoreEnd > 0) {
            ignoreEnd += CIDR_IGNORE_DEFINITIONS_END.length();
        }
        if (ignoreStart >= 0) {
            CidrLog.LOG.assertTrue(ignoreStart < ignoreEnd);
            output = output.substring(0, ignoreStart) + output.substring(ignoreEnd);
        }
        defines.ensureCapacity(output.length());
        for (String eachLine : StringUtil.splitByLines((String)output)) {
            if ((eachLine = eachLine.trim()).isEmpty()) continue;
            if (eachLine.startsWith("#define ")) {
                defines.append(eachLine).append("\n");
                continue;
            }
            Matcher matcher = QUERY_RESULT_PATTERN.matcher(eachLine);
            if (!matcher.find()) continue;
            String kind2 = matcher.group(1);
            String feature = matcher.group(2);
            String value2 = matcher.group(3);
            Map<String, String> container = null;
            if (kind2.equals("feature")) {
                container = features;
            }
            if (kind2.equals("extension")) {
                container = extensions;
            }
            if (kind2.equals("attribute")) {
                container = attributes;
            }
            if (container == null) continue;
            container.put(feature, value2);
        }
    }

    protected static String buildFeaturesCheckText() {
        StringBuilder result2 = new StringBuilder("#if !(defined (__has_extension)) && defined(__has_feature)\n  #define __has_extension __has_feature\n#endif\n#if !defined(__has_attribute)\n  #define __has_attribute(x) 0\n#endif\n");
        GCCCompiler.addQuery("feature", result2, OCCompilerFeatures.getAllFeatures());
        GCCCompiler.addQuery("extension", result2, OCCompilerFeatures.getAllFeatures());
        GCCCompiler.addQuery("attribute", result2, OCCompilerFeatures.getAllAttributes());
        return result2.toString();
    }

    private static void addQuery(String kind2, StringBuilder result2, Collection<String> items) {
        result2.append("#ifdef __has_").append(kind2).append("\n");
        for (String each : items) {
            result2.append("#if __has_").append(kind2).append("(").append(each).append(")\n").append(QUERY_PREFIX).append(kind2).append("->").append(each).append("=1\n").append("#else\n").append(QUERY_PREFIX).append(kind2).append("->").append(each).append("=0\n").append("#endif\n");
        }
        result2.append("#endif\n");
    }

    private ProcessOutput runGCC(@NotNull CidrToolEnvironment environment, @NotNull CidrCompilerSwitches options, @NotNull String fileText) throws ExecutionException {
        Set skipOptions = ContainerUtil.set((Object[])new String[]{"-Werror", "-fdiagnostics-format", "-imacros", "-", "-o"});
        return this.tryRunGCC(environment, options, skipOptions, 0, 0, false, fileText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessOutput tryRunGCC(@NotNull CidrToolEnvironment environment, @NotNull CidrCompilerSwitches options, @NotNull Set<String> skipOptions, int optionsRetriesNumber, int timeoutsNumber, boolean skipResponseFile, @NotNull String fileText) throws ExecutionException {
        ProcessOutput output;
        String responseFileText;
        String responseFileArg;
        String gccPath;
        File responseFile;
        block17: {
            CidrCompilerSwitches filteredOptions = GCCCompiler.filterOptions(options.getList(CidrCompilerSwitches.Format.RAW), skipOptions);
            responseFile = null;
            File bodyFile = null;
            gccPath = this.getExecutablePath();
            try {
                try {
                    responseFile = FileUtil.createTempFile((String)"response-file", (String)".txt", (boolean)true);
                    responseFileArg = "@" + environment.toEnvPath(responseFile.getAbsolutePath());
                    responseFileText = filteredOptions.getCommandLineString(CidrCompilerSwitches.Format.GCC_RESPONSE_FILE);
                    if (!skipResponseFile) {
                        FileUtil.writeToFile((File)responseFile, (String)responseFileText);
                    }
                    bodyFile = FileUtil.createTempFile((String)"compiler-file", (String)"", (boolean)true);
                    FileUtil.writeToFile((File)bodyFile, (String)fileText);
                }
                catch (IOException e) {
                    throw new ExecutionException("Unable to create temporary file", (Throwable)e);
                }
                GeneralCommandLine cl = new GeneralCommandLine();
                environment.prepare(cl, CidrToolEnvironment.PrepareFor.BUILD);
                cl.setExePath(gccPath);
                cl.withWorkDirectory(this.myWorkingDirectory);
                cl.getEnvironment().put("LC_ALL", "C");
                if (!skipResponseFile) {
                    cl.addParameters(new String[]{responseFileArg});
                } else {
                    cl.addParameters(filteredOptions.getList(CidrCompilerSwitches.Format.RAW));
                }
                cl.addParameters(new String[]{environment.toEnvPath(bodyFile.getAbsolutePath())});
                if (CidrLog.LOG.isDebugEnabled()) {
                    CidrLog.LOG.debug("Running compiler: " + cl.getCommandLineString() + "\nArguments file contents: " + filteredOptions);
                }
                output = outCompilerRunner.run(cl);
                if (bodyFile == null) break block17;
            }
            catch (Throwable throwable) {
                if (bodyFile != null) {
                    FileUtil.delete(bodyFile);
                }
                if (responseFile != null) {
                    FileUtil.delete((File)responseFile);
                }
                throw throwable;
            }
            FileUtil.delete((File)bodyFile);
        }
        if (responseFile != null) {
            FileUtil.delete((File)responseFile);
        }
        String userFriendlyCommandLine = gccPath + " " + responseFileText.replaceFirst(Matcher.quoteReplacement(" -D___CIDR_IGNORE_DEFINITIONS_START"), "");
        if (output.isTimeout()) {
            if (timeoutsNumber < 1) {
                CidrLog.LOG.debug("Trying to run compiler after timeout");
                return this.tryRunGCC(environment, options, skipOptions, optionsRetriesNumber, timeoutsNumber + 1, skipResponseFile, fileText);
            }
            throw GCCCompiler.throwCompilerTimeout(userFriendlyCommandLine);
        }
        if (output.getExitCode() != 0) {
            if (!skipResponseFile && output.getStderr().contains(responseFileArg)) {
                CidrLog.LOG.debug("Trying to run compiler without a @response file");
                return this.tryRunGCC(environment, options, skipOptions, optionsRetriesNumber, timeoutsNumber, true, fileText);
            }
            if (optionsRetriesNumber < 2 && GCCCompiler.collectSkipOptionsGcc(output.getStderrLines(), skipOptions)) {
                if (CidrLog.LOG.isDebugEnabled()) {
                    CidrLog.LOG.debug("Trying to run compiler with skipped options: " + StringUtil.join(skipOptions, (String)" "));
                }
                return this.tryRunGCC(environment, options, skipOptions, optionsRetriesNumber + 1, timeoutsNumber, skipResponseFile, fileText);
            }
            throw GCCCompiler.throwCompilerError(output, userFriendlyCommandLine);
        }
        return output;
    }

    @NotNull
    private static CidrCompilerSwitches filterOptions(@NotNull List<String> options, final @NotNull Set<String> skipOptions) {
        BiFunction<String, String, Boolean> argumentsFilter = new BiFunction<String, String, Boolean>(){
            boolean archAdded = false;
            boolean skipOptionValue = false;

            @Override
            public Boolean apply(String parameter, String nextParameter) {
                parameter = parameter.trim();
                boolean tokenIsSwitch = GCCCompiler.isOptionSwitch(parameter);
                if (this.skipOptionValue) {
                    this.skipOptionValue = false;
                    if (!tokenIsSwitch) {
                        return false;
                    }
                }
                if (!skipOptions.contains(parameter)) {
                    if ("-arch".equals(parameter)) {
                        if (this.archAdded) {
                            this.skipOptionValue = true;
                            return false;
                        }
                        this.archAdded = true;
                    }
                    if ("-include".equals(parameter) && skipOptions.contains(nextParameter)) {
                        return false;
                    }
                    return true;
                }
                this.skipOptionValue = tokenIsSwitch;
                return false;
            }
        };
        ArrayList<String> filtered = new ArrayList<String>();
        int size = options.size();
        for (int i2 = 0; i2 < size; ++i2) {
            String nextParam;
            String param = options.get(i2);
            String string = nextParam = i2 + 1 < size ? options.get(i2 + 1) : null;
            if (!((Boolean)argumentsFilter.apply(param, nextParam)).booleanValue()) continue;
            filtered.add(param);
        }
        return new CidrCompilerSwitches(filtered);
    }

    @NotNull
    private String preparePath(@NotNull CidrToolEnvironment env, @NotNull String path) {
        return FileUtil.toCanonicalPath((String)env.toLocalPath(this.myWorkingDirectory, path));
    }

    private static boolean isOptionSwitch(@NotNull String option) {
        return option.startsWith("-");
    }

    static boolean collectSkipOptionsGcc(List<String> lines, Set<String> skipOptions) {
        return GCCCompiler.collectOptionsToSkip(lines, skipOptions, BAD_SWITCH_FILTER_RULES);
    }
}

