/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gsa.files;

import com.jetbrains.gsa.data.HashElem;
import com.jetbrains.gsa.data.HashTab;
import com.jetbrains.gsa.files.EchoFile;
import com.jetbrains.gsa.files.File;
import com.jetbrains.gsa.others.GSAException;
import com.jetbrains.gsa.others.Nonterms;
import com.jetbrains.gsa.text.CType;
import com.jetbrains.gsa.text.ReadString;
import com.jetbrains.gsa.text.SearchString;
import com.jetbrains.gsa.text.WriteString;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class NontermFile
extends File {
    ReadString source;
    ReadString comments;
    WriteString grText;
    String clName;
    String packageDir;
    HashTab semProcsTable;
    public boolean isNonterm = false;
    public static HashTab packageTable = new HashTab();

    public NontermFile(String filename, String packageDir) throws GSAException {
        super(filename);
        this.packageDir = packageDir;
        if (packageDir != null && !packageDir.equals("")) {
            packageTable.add(new HashElem(packageDir));
        }
        try {
            FileInputStream file2 = new FileInputStream(filename);
            DataInputStream stream = new DataInputStream(file2);
            int size = ((InputStream)file2).available();
            byte[] byteArr = new byte[size];
            char[] charArr = new char[size];
            size = ((InputStream)file2).read(byteArr);
            for (int i2 = 0; i2 < size; ++i2) {
                charArr[i2] = (char)byteArr[i2];
            }
            this.source = new ReadString(String.valueOf(charArr), filename, filename);
            stream.close();
        }
        catch (FileNotFoundException ex) {
            throw new GSAException("File " + filename + " not found");
        }
        catch (IOException ex) {
            throw new GSAException("Error reading file " + filename + ": " + ex);
        }
    }

    @Override
    public void collect() throws GSAException {
        SearchString clStr = new SearchString("class");
        while (true) {
            if (!this.source.findSubstr(clStr)) {
                return;
            }
            if (!CType.isAlNum(this.source.getSymbol())) continue;
            this.source.pushBack();
            this.clName = this.source.getID();
            this.source.clname = this.packageDir + this.clName;
            char symb = this.source.getSymbol();
            if (symb == '{') break;
            if (!CType.isAlNum(symb)) continue;
            this.source.pushBack();
            String word = this.source.getID();
            if (word.equals("extends") || word.equals("implements")) break;
        }
        this.data.append(this.source, 0, this.source.ptr);
        this.readNonterm();
        this.data.append(this.source, this.source.ptr, this.source.str.length());
    }

    void readNonterm() throws GSAException {
        SearchString grStr = new SearchString("GRAMMAR");
        while (!this.source.gone()) {
            this.comments = this.source.readComments();
            if (this.comments != null) {
                if (this.comments.findSubstr(grStr)) break;
                this.data.append(this.comments.str);
                continue;
            }
            char symb = this.source.getNext();
            this.data.append(String.valueOf(symb));
        }
        if (this.source.gone()) {
            return;
        }
        this.data.append(this.comments, 0, this.comments.ptr);
        this.data.curTab = 1;
        this.processComments();
        this.isNonterm = true;
    }

    void processComments() throws GSAException {
        int ptrSave = this.comments.ptr;
        int lineSave = this.comments.lines;
        this.readSemProcs();
        this.comments.ptr = ptrSave;
        this.comments.lines = lineSave;
        this.comments.ptr = ptrSave;
        this.comments.lines = lineSave;
        this.grText = new WriteString();
        this.genSemProcs();
        this.comments = new ReadString(this.grText.toString(), this.comments.filename, this.comments.clname);
        this.comments.lines = lineSave;
        Nonterms.Nonterm nonterm = Nonterms.add(new Nonterms.Nonterm(this.clName));
        nonterm.readGrammar(this.comments);
        EchoFile.echo(this);
        this.data.append(this.grText.toString());
        this.data.appendf(nonterm.genDefs(this.source).toString());
    }

    void readSemProcs() throws GSAException {
        this.semProcsTable = new HashTab();
        for (int i2 = this.comments.ptr; i2 < this.comments.str.length(); ++i2) {
            if (this.comments.getNext() != '%' || i2 > 0 && this.comments.str.charAt(i2 - 1) == '\"' || !CType.isAlpha(this.comments.getNext())) continue;
            this.comments.pushBack();
            String curProc = this.comments.getID();
            this.semProcsTable.add(new HashElem(curProc));
        }
    }

    void genSemProcs() {
        class NameGener {
            char[] curName = new String("p000").toCharArray();

            NameGener() {
            }

            String generate() {
                String ans;
                do {
                    int i2;
                    for (i2 = 3; i2 > 0 && this.curName[i2] == '9'; --i2) {
                        this.curName[i2] = 48;
                    }
                    int n = i2;
                    this.curName[n] = (char)(this.curName[n] + '\u0001');
                } while (NontermFile.this.semProcsTable.search(ans = new String(this.curName)) != null);
                return ans;
            }
        }
        NameGener gener = new NameGener();
        for (int i2 = this.comments.ptr; i2 < this.comments.str.length(); ++i2) {
            char symb = this.comments.getNext();
            this.grText.append(String.valueOf(symb));
        }
    }
}

