/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gsa.terms;

import com.jetbrains.gsa.terms.Term;
import com.jetbrains.gsa.terms.Terms;
import com.jetbrains.gsa.text.WriteString;

public class StartTables {
    static final int MAX_TERMS = 1024;
    static StartTable[] store = new StartTable[1024];
    public static int numOfTables = 0;

    public static WriteString writeTables() {
        WriteString ans = new WriteString();
        ans.appendf("private boolean start [] [];\n");
        ans.appendf("private static int startRLE [] [] = {");
        for (int i2 = 0; i2 < numOfTables; ++i2) {
            ans.appendf("\n{ " + (StartTables.store[i2].table[0] ? "1" : "0"));
            boolean last = StartTables.store[i2].table[0];
            int lastStart = 0;
            for (int j = 1; j < Terms.numElems; ++j) {
                if (StartTables.store[i2].table[j] == last) continue;
                ans.appendf(", " + (j - lastStart));
                last = !last;
                lastStart = j;
            }
            ans.appendf(", " + (Terms.numElems - lastStart) + " }");
            if (i2 >= numOfTables - 1) continue;
            ans.appendf(",");
        }
        ans.appendf("\n};\n\n");
        return ans;
    }

    public static class StartTable {
        public boolean[] table = new boolean[1024];
        public boolean first;
        public int oneTerm = -1;
        private int number = -1;
        public static final int undefined = -1;

        public StartTable() {
            for (int i2 = 0; i2 < 1024; ++i2) {
                this.table[i2] = false;
            }
            this.number = -1;
            this.first = true;
        }

        public int getNumber() {
            if (this.number == -1) {
                for (int i2 = 0; i2 < numOfTables; ++i2) {
                    if (!this.equalsTo(store[i2])) continue;
                    return i2;
                }
                StartTables.store[StartTables.numOfTables] = this;
                return numOfTables++;
            }
            return this.number;
        }

        private boolean equalsTo(StartTable table) {
            for (int i2 = 0; i2 < Terms.numElems; ++i2) {
                if (this.table[i2] == table.table[i2]) continue;
                return false;
            }
            return true;
        }

        public boolean transparent() {
            return this.table[Terms.emptyWord.number];
        }

        public void include(Term term) {
            this.table[term.number] = true;
        }

        public void exclude(Term term) {
            this.table[term.number] = false;
        }

        public int merge(StartTable table) {
            int flag = -1;
            for (int i2 = 0; i2 < Terms.numElems; ++i2) {
                if (this.table[i2] && table.table[i2]) {
                    flag = i2;
                }
                int n = i2;
                this.table[n] = this.table[n] | table.table[i2];
            }
            return flag;
        }

        public boolean hasOneTerm() {
            int oneTerm = -1;
            int numOfTerms = 0;
            for (int i2 = 0; i2 < Terms.numElems; ++i2) {
                if (!this.table[i2] || i2 == Terms.emptyWord.number) continue;
                ++numOfTerms;
                oneTerm = i2;
            }
            if (numOfTerms == 1) {
                this.oneTerm = oneTerm;
            }
            return numOfTerms == 1;
        }
    }
}

