/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.BeforeAfter;
import com.intellij.util.ThreeState;
import com.jetbrains.jsonSchema.JsonSchemaMappingsConfigurationBase;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaPatternComparator {
    @NotNull
    private final Project myProject;

    public JsonSchemaPatternComparator(@NotNull Project project2) {
        this.myProject = project2;
    }

    @NotNull
    public ThreeState isSimilar(@NotNull JsonSchemaMappingsConfigurationBase.Item itemLeft, @NotNull JsonSchemaMappingsConfigurationBase.Item itemRight) {
        if (itemLeft.isPattern() != itemRight.isPattern()) {
            return ThreeState.NO;
        }
        if (itemLeft.isPattern()) {
            return JsonSchemaPatternComparator.comparePatterns(itemLeft, itemRight);
        }
        return this.comparePaths(itemLeft, itemRight);
    }

    private ThreeState comparePaths(JsonSchemaMappingsConfigurationBase.Item left, JsonSchemaMappingsConfigurationBase.Item right) {
        File leftFile = new File(this.myProject.getBasePath(), left.getPath());
        File rightFile = new File(this.myProject.getBasePath(), right.getPath());
        if (left.isDirectory() && FileUtil.isAncestor((File)leftFile, (File)rightFile, (boolean)true)) {
            return ThreeState.YES;
        }
        if (right.isDirectory() && FileUtil.isAncestor((File)rightFile, (File)leftFile, (boolean)true)) {
            return ThreeState.YES;
        }
        return FileUtil.filesEqual((File)leftFile, (File)rightFile) && left.isDirectory() == right.isDirectory() ? ThreeState.YES : ThreeState.NO;
    }

    private static ThreeState comparePatterns(JsonSchemaMappingsConfigurationBase.Item left, JsonSchemaMappingsConfigurationBase.Item right) {
        if (left.getPath().equals(right.getPath())) {
            return ThreeState.YES;
        }
        BeforeAfter<String> beforeAfterLeft = JsonSchemaPatternComparator.getBeforeAfterAroundWildCards(left.getPath());
        BeforeAfter<String> beforeAfterRight = JsonSchemaPatternComparator.getBeforeAfterAroundWildCards(right.getPath());
        if (beforeAfterLeft == null || beforeAfterRight == null) {
            if (beforeAfterLeft == null && beforeAfterRight == null) {
                return left.getPath().equals(right.getPath()) ? ThreeState.YES : ThreeState.NO;
            }
            if (beforeAfterLeft == null) {
                return JsonSchemaPatternComparator.checkOneSideWithoutWildcard(left, beforeAfterRight);
            }
            return JsonSchemaPatternComparator.checkOneSideWithoutWildcard(right, beforeAfterLeft);
        }
        if (!StringUtil.isEmptyOrSpaces((String)((String)beforeAfterLeft.getBefore())) && !StringUtil.isEmptyOrSpaces((String)((String)beforeAfterRight.getBefore()))) {
            if (((String)beforeAfterLeft.getBefore()).startsWith((String)beforeAfterRight.getBefore()) || ((String)beforeAfterRight.getBefore()).startsWith((String)beforeAfterLeft.getBefore())) {
                return ThreeState.YES;
            }
            return ThreeState.NO;
        }
        if (!StringUtil.isEmptyOrSpaces((String)((String)beforeAfterLeft.getAfter())) && !StringUtil.isEmptyOrSpaces((String)((String)beforeAfterRight.getAfter()))) {
            if (((String)beforeAfterLeft.getAfter()).endsWith((String)beforeAfterRight.getAfter()) || ((String)beforeAfterRight.getAfter()).endsWith((String)beforeAfterLeft.getAfter())) {
                return ThreeState.YES;
            }
            return ThreeState.NO;
        }
        return ThreeState.UNSURE;
    }

    @NotNull
    private static ThreeState checkOneSideWithoutWildcard(JsonSchemaMappingsConfigurationBase.Item item, BeforeAfter<String> beforeAfter) {
        if (!StringUtil.isEmptyOrSpaces((String)((String)beforeAfter.getBefore())) && item.getPath().startsWith((String)beforeAfter.getBefore())) {
            return ThreeState.YES;
        }
        if (!StringUtil.isEmptyOrSpaces((String)((String)beforeAfter.getAfter())) && item.getPath().endsWith((String)beforeAfter.getAfter())) {
            return ThreeState.YES;
        }
        return ThreeState.UNSURE;
    }

    @Nullable
    private static BeforeAfter<String> getBeforeAfterAroundWildCards(@NotNull String pattern) {
        int firstIdx = pattern.indexOf(42);
        int lastIdx = pattern.lastIndexOf(42);
        if (firstIdx < 0 || lastIdx < 0) {
            return null;
        }
        return new BeforeAfter((Object)pattern.substring(0, firstIdx), (Object)pattern.substring(lastIdx + 1, pattern.length()));
    }
}

