/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.json.JsonFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ZipperUpdater;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileContentsChangedAdapter;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.JsonSchemaMappingsProjectConfiguration;
import com.jetbrains.jsonSchema.impl.JsonSchemaServiceEx;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JsonSchemaVfsListener
extends BulkVirtualFileListenerAdapter {
    public static void startListening(@NotNull Project project2, @NotNull JsonSchemaServiceEx service) {
        MyUpdater updater = new MyUpdater(project2, service);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)project2).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new JsonSchemaVfsListener(updater));
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)new MyDocumentListener(updater), (Disposable)project2);
    }

    private JsonSchemaVfsListener(final @NotNull MyUpdater updater) {
        super((VirtualFileListener)new VirtualFileContentsChangedAdapter(){
            private final MyUpdater myUpdater;
            {
                this.myUpdater = updater;
            }

            protected void onFileChange(@NotNull VirtualFile schemaFile) {
                this.myUpdater.onFileChange(schemaFile);
            }

            protected void onBeforeFileChange(@NotNull VirtualFile schemaFile) {
                this.myUpdater.onFileChange(schemaFile);
            }
        });
    }

    private static class MyUpdater {
        @NotNull
        private final JsonSchemaServiceEx myService;
        private JsonSchemaMappingsProjectConfiguration myMappingsProjectConfiguration;
        private final ZipperUpdater myUpdater;
        private final Set<VirtualFile> myDirtySchemas = ContainerUtil.newConcurrentSet();
        private final Runnable myRunnable;

        protected MyUpdater(@NotNull Project project2, @NotNull JsonSchemaServiceEx service) {
            this.myService = service;
            this.myMappingsProjectConfiguration = JsonSchemaMappingsProjectConfiguration.getInstance(project2);
            this.myUpdater = new ZipperUpdater(200, Alarm.ThreadToUse.POOLED_THREAD, (Disposable)project2);
            this.myRunnable = () -> {
                Editor[] editors;
                HashSet<VirtualFile> scope = new HashSet<VirtualFile>(this.myDirtySchemas);
                this.myDirtySchemas.removeAll(scope);
                if (scope.isEmpty()) {
                    return;
                }
                DaemonCodeAnalyzer analyzer = DaemonCodeAnalyzer.getInstance((Project)project2);
                PsiManager psiManager = PsiManager.getInstance((Project)project2);
                block0: for (Editor editor : editors = EditorFactory.getInstance().getAllEditors()) {
                    Collection<Pair<VirtualFile, String>> collection;
                    VirtualFile file2;
                    if (!(editor instanceof EditorEx) || (file2 = ((EditorEx)editor).getVirtualFile()) == null || !file2.isValid() || !((Object)((Object)JsonFileType.INSTANCE)).equals(file2.getFileType()) || (collection = this.myService.getSchemaFilesByFile(file2)) == null || collection.isEmpty()) continue;
                    for (Pair<VirtualFile, String> pair : collection) {
                        if (!scope.contains(pair.getFirst())) continue;
                        ApplicationManager.getApplication().runReadAction(() -> {
                            PsiFile psiFile = psiManager.findFile(file2);
                            if (psiFile != null) {
                                analyzer.restart(psiFile);
                            }
                        });
                        continue block0;
                    }
                }
            };
        }

        protected void onFileChange(@NotNull VirtualFile schemaFile) {
            if (this.myMappingsProjectConfiguration.isRegisteredSchemaFile(schemaFile)) {
                this.myService.dropProviderFromCache(schemaFile);
                this.myDirtySchemas.add(schemaFile);
                this.myUpdater.queue(this.myRunnable);
            }
        }
    }

    private static class MyDocumentListener
    extends DocumentAdapter {
        private final MyUpdater myUpdater;

        private MyDocumentListener(MyUpdater updater) {
            this.myUpdater = updater;
        }

        public void documentChanged(DocumentEvent e) {
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(e.getDocument());
            if (file2 != null) {
                this.myUpdater.onFileChange(file2);
            }
        }
    }
}

