/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.extension;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.jetbrains.jsonSchema.JsonSchemaMappingsConfigurationBase;
import com.jetbrains.jsonSchema.JsonSchemaMappingsProjectConfiguration;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaImportedProviderMarker;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaImportedProviderFactory
implements JsonSchemaProviderFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.jsonSchema.extension.JsonSchemaImportedProviderFactory");

    @Override
    public List<JsonSchemaFileProvider> getProviders(@Nullable Project project2) {
        ArrayList<JsonSchemaFileProvider> list = new ArrayList<JsonSchemaFileProvider>();
        if (project2 != null) {
            JsonSchemaImportedProviderFactory.processConfiguration(project2, JsonSchemaMappingsProjectConfiguration.getInstance(project2), list);
        }
        return list.isEmpty() ? Collections.emptyList() : list;
    }

    private static void processConfiguration(Project project2, @NotNull JsonSchemaMappingsConfigurationBase configuration, @NotNull List<JsonSchemaFileProvider> list) {
        Map<String, JsonSchemaMappingsConfigurationBase.SchemaInfo> map2 = configuration.getStateMap();
        for (JsonSchemaMappingsConfigurationBase.SchemaInfo info : map2.values()) {
            list.add(new MyProvider(project2, info.getName(), configuration.convertToAbsoluteFile(info.getRelativePathToSchema()), info.getCalculatedPatterns(project2)));
        }
    }

    private static class MyProvider
    implements JsonSchemaFileProvider,
    JsonSchemaImportedProviderMarker {
        @Nullable
        private final Project myProject;
        @NotNull
        private final String myName;
        @NotNull
        private final File myFile;
        private VirtualFile myVirtualFile;
        @NotNull
        private final List<Processor<VirtualFile>> myPatterns;

        public MyProvider(@Nullable Project project2, @NotNull String name, @NotNull File file2, @NotNull List<Processor<VirtualFile>> patterns) {
            this.myProject = project2;
            this.myName = name;
            this.myFile = file2;
            this.myPatterns = patterns;
        }

        @Override
        public VirtualFile getSchemaFile() {
            if (this.myVirtualFile != null && this.myVirtualFile.isValid()) {
                return this.myVirtualFile;
            }
            LocalFileSystem lfs = LocalFileSystem.getInstance();
            this.myVirtualFile = lfs.findFileByIoFile(this.myFile);
            if (this.myVirtualFile == null) {
                this.myVirtualFile = lfs.refreshAndFindFileByIoFile(this.myFile);
            }
            return this.myVirtualFile;
        }

        @Override
        public SchemaType getSchemaType() {
            return SchemaType.userSchema;
        }

        @Override
        public int getOrder() {
            return 1000;
        }

        @Override
        @NotNull
        public String getName() {
            return this.myName;
        }

        @Override
        public boolean isAvailable(@NotNull Project project2, @NotNull VirtualFile file2) {
            if (this.myPatterns.isEmpty() || file2.isDirectory() || !file2.isValid() || this.myProject != null && JsonSchemaMappingsProjectConfiguration.getInstance(this.myProject).isRegisteredSchemaFile(file2)) {
                return false;
            }
            for (Processor<VirtualFile> pattern : this.myPatterns) {
                if (!pattern.process((Object)file2)) continue;
                return true;
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyProvider provider2 = (MyProvider)o;
            if (!this.myName.equals(provider2.myName)) {
                return false;
            }
            return this.myFile.equals(provider2.myFile);
        }

        public int hashCode() {
            int result2 = this.myName.hashCode();
            result2 = 31 * result2 + this.myFile.hashCode();
            return result2;
        }
    }
}

