/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.extension;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import java.net.URL;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JsonSchemaProviderFactory {
    public static final ExtensionPointName<JsonSchemaProviderFactory> EP_NAME = ExtensionPointName.create((String)"JavaScript.JsonSchema.ProviderFactory");
    public static final Logger LOG = Logger.getInstance(JsonSchemaProviderFactory.class);

    public List<JsonSchemaFileProvider> getProviders(@Nullable Project var1);

    public static VirtualFile getResourceFile(@NotNull Class baseClass, @NotNull String resourcePath) {
        URL url = baseClass.getResource(resourcePath);
        if (url == null) {
            LOG.error("Cannot find resource " + resourcePath);
            return null;
        }
        VirtualFile file2 = VfsUtil.findFileByURL((URL)url);
        if (file2 == null) {
            LOG.error("Cannot find file by " + resourcePath);
            return null;
        }
        return file2;
    }
}

