/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.extension.schema;

import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Processor;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaWalker;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JsonSchemaInsideSchemaResolver {
    public static final String PROPERTIES = "/properties/";
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile mySchemaFile;
    @NotNull
    private final String myReference;
    @NotNull
    private final List<JsonSchemaWalker.Step> mySteps;

    public JsonSchemaInsideSchemaResolver(@NotNull Project project2, @NotNull VirtualFile schemaFile, @NotNull String reference, @NotNull List<JsonSchemaWalker.Step> steps) {
        this.myProject = project2;
        this.mySchemaFile = schemaFile;
        this.myReference = reference;
        this.mySteps = steps;
    }

    public PsiElement resolveInSchemaRecursively() {
        final Ref ref = new Ref();
        JsonSchemaWalker.CompletionSchemesConsumer consumer2 = new JsonSchemaWalker.CompletionSchemesConsumer(){

            @Override
            public void consume(boolean isName, @NotNull JsonSchemaObject schema, @NotNull VirtualFile schemaFile, @NotNull List<JsonSchemaWalker.Step> steps) {
                if (!ref.isNull()) {
                    return;
                }
                PsiFile file2 = PsiManager.getInstance((Project)JsonSchemaInsideSchemaResolver.this.myProject).findFile(JsonSchemaInsideSchemaResolver.this.mySchemaFile);
                if (file2 == null) {
                    return;
                }
                JsonObject jsonObject = (JsonObject)schema.getPeerPointer().getElement();
                if (jsonObject != null && jsonObject.isValid()) {
                    if (jsonObject.getParent() instanceof JsonProperty) {
                        ref.set((Object)((JsonProperty)jsonObject.getParent()).getNameElement());
                    } else {
                        ref.set((Object)jsonObject);
                    }
                }
            }

            @Override
            public void oneOf(boolean isName, @NotNull List<JsonSchemaObject> list, @NotNull VirtualFile schemaFile, @NotNull List<JsonSchemaWalker.Step> steps) {
                list.stream().findFirst().ifPresent(object -> this.consume(isName, (JsonSchemaObject)object, schemaFile, steps));
            }

            @Override
            public void anyOf(boolean isName, @NotNull List<JsonSchemaObject> list, @NotNull VirtualFile schemaFile, @NotNull List<JsonSchemaWalker.Step> steps) {
                list.stream().findFirst().ifPresent(object -> this.consume(isName, (JsonSchemaObject)object, schemaFile, steps));
            }
        };
        JsonSchemaService.Impl.getEx(this.myProject).visitSchemaObject(this.mySchemaFile, (Processor<JsonSchemaObject>)((Processor)object -> {
            JsonSchemaWalker.extractSchemaVariants(this.myProject, consumer2, this.mySchemaFile, object, true, this.mySteps, false);
            return true;
        }));
        return (PsiElement)ref.get();
    }
}

