/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.psi.PsiElement;
import com.jetbrains.jsonSchema.impl.JsonArrayValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonJsonArrayAdapter;
import com.jetbrains.jsonSchema.impl.JsonJsonGenericValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonJsonObjectAdapter;
import com.jetbrains.jsonSchema.impl.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.impl.JsonValueAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonJsonPropertyAdapter
implements JsonPropertyAdapter {
    @NotNull
    private final JsonProperty myProperty;

    public JsonJsonPropertyAdapter(@NotNull JsonProperty property) {
        this.myProperty = property;
    }

    @Override
    @Nullable
    public String getName() {
        return this.myProperty.getName();
    }

    @Override
    @Nullable
    public JsonValueAdapter getValue() {
        return this.myProperty.getValue() == null ? null : JsonJsonPropertyAdapter.createAdapterByType(this.myProperty.getValue());
    }

    @Override
    @NotNull
    public PsiElement getDelegate() {
        return this.myProperty;
    }

    @Override
    @Nullable
    public JsonObjectValueAdapter getParentObject() {
        return this.myProperty.getParent() instanceof JsonObject ? new JsonJsonObjectAdapter((JsonObject)this.myProperty.getParent()) : null;
    }

    @Override
    @Nullable
    public JsonArrayValueAdapter getParentArray() {
        return this.myProperty.getParent() instanceof JsonArray ? new JsonJsonArrayAdapter((JsonArray)this.myProperty.getParent()) : null;
    }

    @NotNull
    static JsonValueAdapter createAdapterByType(@NotNull JsonValue value2) {
        if (value2 instanceof JsonObject) {
            return new JsonJsonObjectAdapter((JsonObject)value2);
        }
        if (value2 instanceof JsonArray) {
            return new JsonJsonArrayAdapter((JsonArray)value2);
        }
        return new JsonJsonGenericValueAdapter(value2);
    }
}

