/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.BidirectionalMap;
import com.jetbrains.jsonSchema.impl.JsonSchemaReader;
import com.jetbrains.jsonSchema.impl.JsonSchemaServiceEx;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaExportedDefinitions {
    private final Object myLock = new Object();
    private final BidirectionalMap<String, VirtualFile> myId2Key = new BidirectionalMap();
    private Set<VirtualFile> myFilesToRefresh = new HashSet<VirtualFile>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(@NotNull VirtualFile key2, @NotNull String url) {
        Object object = this.myLock;
        synchronized (object) {
            this.myFilesToRefresh.remove(key2);
            this.myId2Key.put((Object)JsonSchemaExportedDefinitions.normalizeId(url), (Object)key2);
            if (this.myId2Key.size() > 10000) {
                JsonSchemaReader.LOG.info("Too many schema definitions registered. Something could go wrong.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.myLock;
        synchronized (object) {
            this.myFilesToRefresh.addAll(this.myId2Key.values());
            this.myId2Key.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropKey(@NotNull VirtualFile key2) {
        Object object = this.myLock;
        synchronized (object) {
            this.myFilesToRefresh.add(key2);
            this.myId2Key.removeValue((Object)key2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public VirtualFile getSchemaFileById(@NotNull String id, JsonSchemaServiceEx jsonSchemaService) {
        for (int i2 = 0; i2 < 100; ++i2) {
            HashSet<VirtualFile> toRefresh = new HashSet<VirtualFile>();
            Object object = this.myLock;
            synchronized (object) {
                toRefresh.addAll(this.myFilesToRefresh);
            }
            if (!toRefresh.isEmpty()) {
                jsonSchemaService.refreshSchemaIds(toRefresh);
            }
            object = this.myLock;
            synchronized (object) {
                if (this.myFilesToRefresh.isEmpty()) {
                    break;
                }
                continue;
            }
        }
        Object object = this.myLock;
        synchronized (object) {
            return (VirtualFile)this.myId2Key.get((Object)id);
        }
    }

    @NotNull
    public static String normalizeId(@NotNull String id) {
        id = id.endsWith("#") ? id.substring(0, id.length() - 1) : id;
        return id.startsWith("#") ? id.substring(1) : id;
    }
}

