/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PairConsumer;
import com.intellij.util.Processor;
import com.jetbrains.jsonSchema.CodeInsightProviders;
import com.jetbrains.jsonSchema.extension.SchemaType;
import com.jetbrains.jsonSchema.impl.JsonBySchemaDocumentationProvider;
import com.jetbrains.jsonSchema.impl.JsonBySchemaObjectAnnotator;
import com.jetbrains.jsonSchema.impl.JsonBySchemaObjectCompletionContributor;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import org.jetbrains.annotations.NotNull;

class JsonSchemaObjectCodeInsightWrapper
implements CodeInsightProviders {
    @NotNull
    private final String myName;
    @NotNull
    private final SchemaType mySchemaType;
    @NotNull
    private final VirtualFile mySchemaFile;
    @NotNull
    private final JsonSchemaObject mySchemaObject;
    @NotNull
    private final CompletionContributor myContributor;
    @NotNull
    private final Annotator myAnnotator;
    @NotNull
    private final DocumentationProvider myDocumentationProvider;

    public JsonSchemaObjectCodeInsightWrapper(@NotNull Project project2, @NotNull String name, @NotNull SchemaType type2, @NotNull VirtualFile schemaFile, @NotNull JsonSchemaObject schemaObject) {
        this.myName = name;
        this.mySchemaType = type2;
        this.mySchemaFile = schemaFile;
        this.mySchemaObject = schemaObject;
        this.myContributor = new JsonBySchemaObjectCompletionContributor(type2, schemaFile, schemaObject);
        this.myAnnotator = new JsonBySchemaObjectAnnotator(schemaFile, schemaObject);
        this.myDocumentationProvider = new JsonBySchemaDocumentationProvider(schemaFile, schemaObject);
    }

    @Override
    @NotNull
    public CompletionContributor getContributor() {
        return this.myContributor;
    }

    @Override
    @NotNull
    public Annotator getAnnotator() {
        return this.myAnnotator;
    }

    @Override
    @NotNull
    public String getName() {
        return this.myName;
    }

    @Override
    @NotNull
    public DocumentationProvider getDocumentationProvider() {
        return this.myDocumentationProvider;
    }

    @Override
    public boolean iterateSchemaObjects(@NotNull Processor<JsonSchemaObject> consumer2) {
        return consumer2.process((Object)this.mySchemaObject);
    }

    @Override
    public void iterateSchemaFiles(@NotNull PairConsumer<VirtualFile, String> consumer2) {
        consumer2.consume((Object)this.mySchemaFile, (Object)this.mySchemaObject.getId());
    }

    @Override
    public boolean isUserSchema() {
        return SchemaType.userSchema.equals((Object)this.mySchemaType);
    }
}

