/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonValue;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Consumer;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.ReadJsonSchemaFromPsi;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaReader {
    public static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.jsonSchema.impl.JsonSchemaReader");
    public static final NotificationGroup ERRORS_NOTIFICATION = NotificationGroup.logOnlyGroup((String)"JSON Schema");
    @NotNull
    private final JsonObject myRoot;

    public JsonSchemaReader(@NotNull JsonObject root) {
        this.myRoot = root;
    }

    @Nullable
    public static JsonSchemaReader create(@NotNull Project project2, @NotNull VirtualFile key2) {
        PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(key2);
        if (!(psiFile instanceof JsonFile)) {
            return null;
        }
        List<JsonValue> values = ((JsonFile)psiFile).getAllTopLevelValues();
        if (values.size() != 1 || !(values.get(0) instanceof JsonObject)) {
            return null;
        }
        return new JsonSchemaReader((JsonObject)values.get(0));
    }

    public JsonSchemaObject read() throws IOException {
        ReadJsonSchemaFromPsi reader = new ReadJsonSchemaFromPsi();
        JsonSchemaObject object = reader.read(this.myRoot);
        this.processReferences(object, reader.getAllObjects());
        ArrayList<JsonSchemaObject> withoutDefinitions = new ArrayList<JsonSchemaObject>(reader.getAllObjects());
        JsonSchemaReader.removeDefinitions(object, withoutDefinitions);
        return object;
    }

    public static boolean isJsonSchema(@NotNull Project project2, @NotNull VirtualFile key2, Consumer<String> errorConsumer) throws IOException {
        JsonSchemaReader reader = JsonSchemaReader.create(project2, key2);
        if (reader == null) {
            return false;
        }
        try {
            reader.read();
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            errorConsumer.consume((Object)e.getMessage());
            return false;
        }
        return true;
    }

    private static void removeDefinitions(JsonSchemaObject root, ArrayList<JsonSchemaObject> objects) {
        ArrayList<JsonSchemaObject> queue = new ArrayList<JsonSchemaObject>(objects.size() + 1);
        queue.addAll(objects);
        queue.add(root);
        for (JsonSchemaObject object : queue) {
            Map<String, JsonSchemaObject> definitions = object.getDefinitions();
            if (definitions == null) continue;
            objects.removeAll(definitions.values());
        }
    }

    private void processReferences(JsonSchemaObject root, Set<JsonSchemaObject> objects) {
        HashSet<String> queuedDefinitions = new HashSet<String>();
        ArrayDeque<JsonSchemaObject> queue = new ArrayDeque<JsonSchemaObject>();
        queue.add(root);
        queue.addAll(objects);
        int control = 10000;
        while (!queue.isEmpty()) {
            if (--control == 0) {
                throw new RuntimeException("cyclic definitions search");
            }
            JsonSchemaObject current = (JsonSchemaObject)queue.removeFirst();
            if ("#".equals(current.getRef()) || current.getRef() == null) continue;
            JsonSchemaObject definition = JsonSchemaReader.findDefinition(current.getRef(), root);
            if (definition == null) {
                current.setDefinitionAddress(current.getRef());
                current.setRef(null);
                continue;
            }
            if (definition.getRef() != null && !"#".equals(definition.getRef()) && !queuedDefinitions.contains(definition.getRef())) {
                queuedDefinitions.add(definition.getRef());
                queue.addFirst(current);
                queue.addFirst(definition);
                continue;
            }
            JsonSchemaObject copy = new JsonSchemaObject(this.myRoot);
            copy.setDefinitionAddress(current.getRef());
            copy.mergeValues(definition);
            copy.mergeValues(current);
            copy.setPeerPointer(current.getPeerPointer());
            copy.setDefinitionsPointer(current.getDefinitionsPointer());
            current.copyValues(copy);
            current.setRef(null);
        }
    }

    @Nullable
    private static JsonSchemaObject findDefinition(@NotNull String ref, @NotNull JsonSchemaObject root) {
        if ("#".equals(ref)) {
            return root;
        }
        if (JsonSchemaReader.isAbsoluteReference(ref)) {
            return null;
        }
        return JsonSchemaReader.findRelativeDefinition(ref, root);
    }

    static boolean isAbsoluteReference(@NotNull String ref) {
        return !ref.startsWith("#/");
    }

    @Nullable
    public static JsonSchemaObject findRelativeDefinition(@NotNull String ref, @NotNull JsonSchemaObject root) {
        if ("#".equals(ref)) {
            return root;
        }
        if (JsonSchemaReader.isAbsoluteReference(ref)) {
            throw new RuntimeException("Non-relative or erroneous reference: " + ref);
        }
        ref = ref.substring(2);
        List parts = StringUtil.split((String)ref, (String)"/");
        JsonSchemaObject current = root;
        for (int i2 = 0; i2 < parts.size(); ++i2) {
            if (current == null) {
                return null;
            }
            String part = (String)parts.get(i2);
            if ("definitions".equals(part)) {
                if (i2 == parts.size() - 1) {
                    throw new RuntimeException("Incorrect definition reference: " + ref);
                }
                current = current.getDefinitions().get(parts.get(++i2));
                continue;
            }
            if ("properties".equals(part)) {
                if (i2 == parts.size() - 1) {
                    throw new RuntimeException("Incorrect properties reference: " + ref);
                }
                current = current.getProperties().get(parts.get(++i2));
                continue;
            }
            current = current.getDefinitions().get(part);
        }
        if (current == null) {
            return null;
        }
        return current;
    }

    public static class SchemaUrlSplitter {
        @Nullable
        private final String mySchemaId;
        @NotNull
        private final String myRelativePath;

        public SchemaUrlSplitter(@NotNull String ref) {
            if (JsonSchemaReader.isAbsoluteReference(ref)) {
                int idx = ref.indexOf("#/");
                if (idx == -1) {
                    this.mySchemaId = ref.endsWith("#") ? ref.substring(0, ref.length() - 1) : ref;
                    this.myRelativePath = "";
                } else {
                    this.mySchemaId = ref.substring(0, idx);
                    this.myRelativePath = ref.substring(idx);
                }
            } else {
                this.mySchemaId = null;
                this.myRelativePath = ref;
            }
        }

        public boolean isAbsolute() {
            return this.mySchemaId != null;
        }

        @Nullable
        public String getSchemaId() {
            return this.mySchemaId;
        }

        @NotNull
        public String getRelativePath() {
            return this.myRelativePath;
        }
    }
}

