/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.indexing.IndexableSetContributor;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JsonSchemaResourcesRootsProvider
extends IndexableSetContributor {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.jsonSchema.impl.JsonSchemaResourcesRootsProvider");
    public static final NotNullLazyValue<Set<VirtualFile>> ourFiles = new AtomicNotNullLazyValue<Set<VirtualFile>>(){

        @NotNull
        protected Set<VirtualFile> compute() {
            JsonSchemaProviderFactory[] extensions;
            HashSet<VirtualFile> set2 = new HashSet<VirtualFile>();
            for (JsonSchemaProviderFactory extension : extensions = (JsonSchemaProviderFactory[])Extensions.getExtensions(JsonSchemaProviderFactory.EP_NAME)) {
                List<JsonSchemaFileProvider> providers = extension.getProviders(null);
                for (JsonSchemaFileProvider provider2 : providers) {
                    if (SchemaType.userSchema.equals((Object)provider2.getSchemaType())) continue;
                    VirtualFile schemaFile = provider2.getSchemaFile();
                    if (schemaFile == null) {
                        LOG.info("Can not find resource file for json schema provider: " + provider2.getName());
                        continue;
                    }
                    set2.add(schemaFile);
                }
            }
            return set2;
        }
    };

    @NotNull
    public Set<VirtualFile> getAdditionalRootsToIndex() {
        return (Set)ourFiles.getValue();
    }

    @NotNull
    public static GlobalSearchScope enlarge(@NotNull Project project2, final @NotNull GlobalSearchScope scope) {
        return scope.union((SearchScope)new GlobalSearchScope(){

            public boolean contains(@NotNull VirtualFile file2) {
                return ((Set)ourFiles.getValue()).contains(file2);
            }

            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                return scope.compare(file1, file2);
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                return scope.isSearchInModuleContent(aModule);
            }

            public boolean isSearchInLibraries() {
                return scope.isSearchInLibraries();
            }

            public boolean isSearchOutsideRootModel() {
                return true;
            }
        });
    }
}

