/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.idea.RareLogger;
import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PairConsumer;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.CodeInsightProviders;
import com.jetbrains.jsonSchema.JsonSchemaFileTypeManager;
import com.jetbrains.jsonSchema.JsonSchemaVfsListener;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaImportedProviderMarker;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaExportedDefinitions;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaObjectCodeInsightWrapper;
import com.jetbrains.jsonSchema.impl.JsonSchemaReader;
import com.jetbrains.jsonSchema.impl.JsonSchemaServiceEx;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaServiceImpl
implements JsonSchemaServiceEx {
    private static final Logger LOGGER = Logger.getInstance(JsonSchemaServiceImpl.class);
    private static final Logger RARE_LOGGER = RareLogger.wrap(LOGGER, false);
    public static final Comparator<JsonSchemaFileProvider> FILE_PROVIDER_COMPARATOR = Comparator.comparingInt(JsonSchemaFileProvider::getOrder);
    @NotNull
    private final Project myProject;
    private final Object myLock;
    private final Map<VirtualFile, CodeInsightProviders> myWrappers = new HashMap<VirtualFile, CodeInsightProviders>();
    private final Set<VirtualFile> mySchemaFiles = ContainerUtil.newConcurrentSet();
    private volatile boolean initialized;
    private final JsonSchemaExportedDefinitions myDefinitions;

    public JsonSchemaServiceImpl(@NotNull Project project2) {
        this.myLock = new Object();
        this.myProject = project2;
        this.myDefinitions = new JsonSchemaExportedDefinitions();
        JsonSchemaVfsListener.startListening(project2, this);
        this.ensureSchemaFiles();
    }

    @NotNull
    protected JsonSchemaProviderFactory[] getProviderFactories() {
        return (JsonSchemaProviderFactory[])JsonSchemaProviderFactory.EP_NAME.getExtensions();
    }

    private List<JsonSchemaFileProvider> getProviders() {
        ArrayList<JsonSchemaFileProvider> providers = new ArrayList<JsonSchemaFileProvider>();
        for (JsonSchemaProviderFactory factory : this.getProviderFactories()) {
            providers.addAll(factory.getProviders(this.myProject));
        }
        Collections.sort(providers, FILE_PROVIDER_COMPARATOR);
        return providers;
    }

    @Override
    @Nullable
    public Annotator getAnnotator(@Nullable VirtualFile file2) {
        CodeInsightProviders wrapper = this.getWrapper(file2);
        return wrapper != null ? wrapper.getAnnotator() : null;
    }

    @Override
    @Nullable
    public CompletionContributor getCompletionContributor(@Nullable VirtualFile file2) {
        CodeInsightProviders wrapper = this.getWrapper(file2);
        return wrapper != null ? wrapper.getContributor() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureSchemaFiles() {
        Object object = this.myLock;
        synchronized (object) {
            if (!this.initialized) {
                for (JsonSchemaFileProvider provider2 : this.getProviders()) {
                    VirtualFile schemaFile = provider2.getSchemaFile();
                    if (schemaFile == null) continue;
                    this.mySchemaFiles.add(schemaFile);
                    this.myDefinitions.dropKey(schemaFile);
                    this.myWrappers.remove(schemaFile);
                }
                this.initialized = true;
            }
        }
    }

    @Override
    public boolean isSchemaFile(@NotNull VirtualFile file2, @NotNull Consumer<String> errorConsumer) {
        try {
            VfsUtilCore.loadText((VirtualFile)file2);
        }
        catch (IOException e) {
            errorConsumer.consume((Object)e.getMessage());
            return false;
        }
        try {
            return JsonSchemaReader.isJsonSchema(this.myProject, file2, errorConsumer);
        }
        catch (Exception e) {
            this.reset();
            errorConsumer.consume((Object)e.getMessage());
            return false;
        }
    }

    @Override
    @Nullable
    public DocumentationProvider getDocumentationProvider(@Nullable VirtualFile file2) {
        CodeInsightProviders wrapper = this.getWrapper(file2);
        return wrapper != null ? wrapper.getDocumentationProvider() : null;
    }

    @Override
    public void visitSchemaObject(@NotNull VirtualFile schemaFile, @NotNull Processor<JsonSchemaObject> consumer2) {
        CodeInsightProviders wrapper = this.getWrapperBySchemaFile(schemaFile);
        if (wrapper == null) {
            return;
        }
        wrapper.iterateSchemaObjects(consumer2);
    }

    @Override
    @Nullable
    public List<Pair<Boolean, String>> getMatchingSchemaDescriptors(@Nullable VirtualFile file2) {
        List<CodeInsightProviders> wrappers = this.getWrappers(file2);
        if (wrappers.isEmpty()) {
            return null;
        }
        return ContainerUtil.map(wrappers, (Function)((NotNullFunction)wrapper -> Pair.create((Object)wrapper.isUserSchema(), (Object)wrapper.getName())));
    }

    @Nullable
    private CodeInsightProviders createWrapper(@NotNull JsonSchemaFileProvider provider2) {
        JsonSchemaObject resultObject = this.readObject(provider2);
        if (resultObject == null) {
            return null;
        }
        return provider2.proxyCodeInsightProviders(new JsonSchemaObjectCodeInsightWrapper(this.myProject, provider2.getName(), provider2.getSchemaType(), provider2.getSchemaFile(), resultObject));
    }

    private JsonSchemaObject readObject(@NotNull JsonSchemaFileProvider provider2) {
        VirtualFile file2 = provider2.getSchemaFile();
        if (file2 == null) {
            return null;
        }
        return (JsonSchemaObject)ReadAction.compute(() -> {
            try {
                JsonSchemaReader reader = JsonSchemaReader.create(this.myProject, file2);
                if (reader == null) {
                    return null;
                }
                JsonSchemaObject schemaObject = reader.read();
                if (schemaObject.getId() != null) {
                    this.myDefinitions.register(file2, schemaObject.getId());
                }
                return schemaObject;
            }
            catch (ProcessCanceledException reader) {
            }
            catch (Exception e) {
                JsonSchemaServiceImpl.logException(provider2, e);
            }
            return null;
        });
    }

    private static void logException(@NotNull JsonSchemaFileProvider provider2, Exception e) {
        String message2 = "Error while processing json schema file: " + e.getMessage();
        if (provider2 instanceof JsonSchemaImportedProviderMarker) {
            RARE_LOGGER.info(message2, (Throwable)e);
        } else {
            LOGGER.error(message2, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Object object = this.myLock;
        synchronized (object) {
            this.myWrappers.clear();
            this.myDefinitions.reset();
            this.initialized = false;
            this.mySchemaFiles.clear();
        }
        JsonSchemaFileTypeManager.getInstance().reset();
    }

    @Nullable
    private CodeInsightProviders getWrapper(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        List<CodeInsightProviders> wrappers = this.getWrappers(file2);
        if (wrappers.isEmpty()) {
            return null;
        }
        return wrappers.size() == 1 ? wrappers.get(0) : new CompositeCodeInsightProviderWithWarning(wrappers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropProviderFromCache(@NotNull VirtualFile schemaFile) {
        Object object = this.myLock;
        synchronized (object) {
            this.myDefinitions.dropKey(schemaFile);
            this.myWrappers.remove(schemaFile);
        }
    }

    @NotNull
    private List<CodeInsightProviders> getWrappers(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return Collections.emptyList();
        }
        FileType type2 = file2.getFileType();
        boolean isJson = type2 instanceof LanguageFileType && ((LanguageFileType)type2).getLanguage().isKindOf((Language)JsonLanguage.INSTANCE);
        SmartList wrappers = new SmartList();
        this.getWrapperSkeletonMethod((Processor<JsonSchemaFileProvider>)((Processor)provider2 -> (isJson || !SchemaType.userSchema.equals((Object)provider2.getSchemaType())) && provider2.isAvailable(this.myProject, file2)), (Consumer<CodeInsightProviders>)((Consumer)arg_0 -> JsonSchemaServiceImpl.lambda$getWrappers$3((List)wrappers, arg_0)), true);
        return wrappers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private CodeInsightProviders getWrapperBySchemaFile(@NotNull VirtualFile schemaFile) {
        Object object = this.myLock;
        synchronized (object) {
            CodeInsightProviders wrapper2 = this.myWrappers.get(schemaFile);
            if (wrapper2 != null) {
                return wrapper2;
            }
        }
        Ref ref = new Ref();
        this.getWrapperSkeletonMethod((Processor<JsonSchemaFileProvider>)((Processor)provider2 -> schemaFile.equals(provider2.getSchemaFile())), (Consumer<CodeInsightProviders>)((Consumer)wrapper -> ref.set(wrapper)), false);
        return (CodeInsightProviders)ref.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getWrapperSkeletonMethod(@NotNull Processor<JsonSchemaFileProvider> processor2, @NotNull Consumer<CodeInsightProviders> consumer2, boolean multiple) {
        CodeInsightProviders wrapper;
        List filtered = this.getProviders().stream().filter(arg_0 -> processor2.process(arg_0)).collect(Collectors.toList());
        if (filtered.isEmpty()) {
            return;
        }
        SmartList matchingProviders = new SmartList();
        Object object = this.myLock;
        synchronized (object) {
            for (JsonSchemaFileProvider provider2 : filtered) {
                wrapper = this.myWrappers.get(provider2.getSchemaFile());
                if (wrapper != null) {
                    consumer2.consume((Object)wrapper);
                    if (multiple) continue;
                    return;
                }
                matchingProviders.add(provider2);
                if (multiple) continue;
                break;
            }
        }
        if (matchingProviders.isEmpty()) {
            return;
        }
        HashMap<VirtualFile, Pair> created = new HashMap<VirtualFile, Pair>();
        for (JsonSchemaFileProvider provider2 : matchingProviders) {
            wrapper = this.createWrapper(provider2);
            if (wrapper == null) continue;
            created.put(provider2.getSchemaFile(), Pair.create((Object)wrapper, (Object)provider2));
        }
        List<JsonSchemaFileProvider> providers = this.getProviders();
        Object object2 = this.myLock;
        synchronized (object2) {
            created.forEach((file2, pair) -> {
                CodeInsightProviders wrapper = (CodeInsightProviders)pair.getFirst();
                JsonSchemaFileProvider provider2 = (JsonSchemaFileProvider)pair.getSecond();
                if (!providers.contains(provider2)) {
                    return;
                }
                if (processor2.process((Object)provider2)) {
                    this.myWrappers.putIfAbsent((VirtualFile)file2, wrapper);
                    consumer2.consume((Object)wrapper);
                }
            });
        }
    }

    @Override
    @Nullable
    public VirtualFile getSchemaFileById(@NotNull String id, @Nullable VirtualFile referent) {
        VirtualFile schemaFile = this.myDefinitions.getSchemaFileById(id, this);
        if (schemaFile != null) {
            return schemaFile;
        }
        return JsonSchemaServiceImpl.getSchemaFileByRefAsLocalFile(id, referent);
    }

    @Nullable
    public static VirtualFile getSchemaFileByRefAsLocalFile(@NotNull String id, @Nullable VirtualFile referent) {
        VirtualFile dir;
        String normalizedId = JsonSchemaExportedDefinitions.normalizeId(id);
        if (FileUtil.isAbsolute((String)normalizedId) || referent == null) {
            return VfsUtil.findFileByIoFile((File)new File(normalizedId), (boolean)false);
        }
        VirtualFile virtualFile = dir = referent.isDirectory() ? referent : referent.getParent();
        if (dir != null && dir.isValid()) {
            List parts = StringUtil.split((String)normalizedId.replace("\\", "/"), (String)"/");
            return VfsUtil.findRelativeFile((VirtualFile)dir, (String[])ArrayUtil.toStringArray((Collection)parts));
        }
        return null;
    }

    @Override
    @Nullable
    public Collection<Pair<VirtualFile, String>> getSchemaFilesByFile(@NotNull VirtualFile file2) {
        CodeInsightProviders wrapper = this.getWrapper(file2);
        if (wrapper != null) {
            SmartList result2 = new SmartList();
            wrapper.iterateSchemaFiles((PairConsumer<VirtualFile, String>)((PairConsumer)(arg_0, arg_1) -> JsonSchemaServiceImpl.lambda$getSchemaFilesByFile$7((List)result2, arg_0, arg_1)));
            return result2;
        }
        return null;
    }

    @Override
    public Set<VirtualFile> getSchemaFiles() {
        if (!this.initialized) {
            this.ensureSchemaFiles();
        }
        return Collections.unmodifiableSet(this.mySchemaFiles);
    }

    @Override
    public void refreshSchemaIds(Set<VirtualFile> toRefresh) {
        for (VirtualFile refresh : toRefresh) {
            this.getWrapperBySchemaFile(refresh);
        }
    }

    private static /* synthetic */ void lambda$getSchemaFilesByFile$7(List result2, VirtualFile schemaFile, String schemaId) {
        result2.add(Pair.create((Object)schemaFile, (Object)schemaId));
    }

    private static /* synthetic */ void lambda$getWrappers$3(List wrappers, CodeInsightProviders wrapper) {
        wrappers.add(wrapper);
    }

    private static class CompositeCodeInsightProviderWithWarning
    implements CodeInsightProviders {
        private final List<CodeInsightProviders> myWrappers;
        private final CompletionContributor myContributor;
        private final Annotator myAnnotator;
        private final DocumentationProvider myDocumentationProvider;

        public CompositeCodeInsightProviderWithWarning(List<CodeInsightProviders> wrappers) {
            List<Object> userSchemaWrappers = ContainerUtil.filter(wrappers, CodeInsightProviders::isUserSchema);
            this.myWrappers = !userSchemaWrappers.isEmpty() && userSchemaWrappers.size() + 1 == wrappers.size() ? userSchemaWrappers : wrappers;
            this.myContributor = new CompletionContributor(){

                public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result2) {
                    for (CodeInsightProviders wrapper : myWrappers) {
                        wrapper.getContributor().fillCompletionVariants(parameters2, result2);
                    }
                }
            };
            this.myAnnotator = new Annotator(){

                public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
                    for (CodeInsightProviders wrapper : myWrappers) {
                        wrapper.getAnnotator().annotate(element, holder);
                    }
                }
            };
            ArrayList<DocumentationProvider> list = new ArrayList<DocumentationProvider>();
            for (CodeInsightProviders wrapper : this.myWrappers) {
                list.add(wrapper.getDocumentationProvider());
            }
            this.myDocumentationProvider = CompositeDocumentationProvider.wrapProviders(list);
        }

        @Override
        @NotNull
        public CompletionContributor getContributor() {
            return this.myContributor;
        }

        @Override
        @NotNull
        public Annotator getAnnotator() {
            return this.myAnnotator;
        }

        @Override
        @NotNull
        public DocumentationProvider getDocumentationProvider() {
            return this.myDocumentationProvider;
        }

        @Override
        @NotNull
        public String getName() {
            return "Composite";
        }

        @Override
        public boolean isUserSchema() {
            return false;
        }

        @Override
        public boolean iterateSchemaObjects(@NotNull Processor<JsonSchemaObject> consumer2) {
            for (CodeInsightProviders wrapper : this.myWrappers) {
                if (wrapper.iterateSchemaObjects(consumer2)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void iterateSchemaFiles(@NotNull PairConsumer<VirtualFile, String> consumer2) {
            for (CodeInsightProviders wrapper : this.myWrappers) {
                wrapper.iterateSchemaFiles(consumer2);
            }
        }
    }
}

